# DPP Salesforce ↔ AEI Scheduler Field Mapping

## Permit Number Mapping

AEI stores just the numeric portion. Salesforce uses a prefixed format:

| AEI Field | AEI Example | SF Field | SF Example |
|-----------|-------------|----------|------------|
| `jobs.building_permit` | `189630` | `MUSW__Permit2__c.Name` | `BP-2025-189630` |

**Pattern:** `{Type}-{Year}-{Number}`
- `BP` = Building Permit
- `SD` = Site Development
- `ZP` = Zoning Permit
- `CA` = Coastal Area

## Core Field Mapping: Salesforce → AEI

### Permit Status & Lifecycle

| Salesforce Field | Type | AEI Equivalent | Notes |
|-----------------|------|----------------|-------|
| `Name` | String | `jobs.building_permit` | Strip prefix to match |
| `MUSW__Phase__c` | Picklist | (new) | Review, Inspection, etc. |
| `MUSW__Status__c` | Picklist | `jobs.building_permit_status` | In Progress, Complete, etc. |
| `MUSW__Type2__c` | Picklist | `jobs.permit_type` | Building, Electrical, etc. |
| `MUSW__Work_Type2__c` | Picklist | (none) | Repair, New Construction, etc. |
| `MUSW__Use_Class__c` | Picklist | (none) | Residential, Commercial |
| `MUSW__Use_Type__c` | Picklist | (none) | Single-Unit Dwelling, etc. |
| `MUSW__Description__c` | TextArea | (none) | Full job description from DPP |
| `MUSW__Valuation__c` | Currency | (none) | Project valuation |

### Dates

| Salesforce Field | Type | AEI Equivalent | Notes |
|-----------------|------|----------------|-------|
| `Application_Accepted_Date__c` | Date | (none) | When DPP accepted application |
| `Application_Expiration_Date__c` | Date | (none) | Application expiration |
| `MUSW__Issue_Date__c` | Date | `jobs.building_permit_completeiondate` | When permit was issued |
| `MUSW__DateCompleted__c` | Date | (none) | Construction completion date |
| `MUSW__Expiration_Date__c` | Date | (none) | Permit expiration |
| `CreatedDate` | DateTime | `permit_details.created_date` | Record creation |

### Fees & Payments

| Salesforce Field | Type | AEI Equivalent | Notes |
|-----------------|------|----------------|-------|
| `MUSW__Total_Fees__c` | Currency | `jobs.permit_fee` | Total fees assessed |
| `MUSW__Total_Payments__c` | Currency | (none) | Total payments made |
| `MUSW__Total_Balance__c` | Currency | (none) | Outstanding balance |

### Location

| Salesforce Field | Type | AEI Equivalent | Notes |
|-----------------|------|----------------|-------|
| `MUSW__Address__r` | Reference | `jobs.service_location` | Full address display |
| `MUSW__Parcel__c` | Reference | (TMK in jobs) | Parcel/TMK reference |

### People

| Salesforce Field | Type | AEI Equivalent | Notes |
|-----------------|------|----------------|-------|
| `MUSW__Account__r` | Reference | `customers.name` | Account/customer name |
| `MUSW__Applicant__r` | Reference | `customers.name` | Applicant name |
| `MUSW__Project2__r` | Reference | (none) | DPP project name |

### Certificate of Occupancy

| Salesforce Field | Type | AEI Equivalent |
|-----------------|------|----------------|
| `CO_Required__c` | Picklist | (none) |
| `Final_CO_Issued__c` | Boolean | (none) |

### Building-Specific Fields (Sample)

| Salesforce Field | Type | Description |
|-----------------|------|-------------|
| `Electrical_Phases__c` | String | Number of electrical phases |
| `Plumbing_Phases__c` | String | Number of plumbing phases |
| `NPDES_Permit_No__c` | String | NPDES permit number |
| `Plan_Review_Milestone_Completed__c` | Picklist | Plan review status |
| `Sub_Type_Multi_Select__c` | MultiPicklist | Sub-types (Other, Driveway, etc.) |

## Related Object Mapping

### MUSW__Inspection__c (94 fields) - Inspections

| Key Field | Type | Description |
|-----------|------|-------------|
| `MUSW__Permit__c` | Reference | FK to Permit |
| `Name` | String | Inspection number |
| `MUSW__Status__c` | Picklist | Pass/Fail/Scheduled/etc. |
| `MUSW__Type__c` | Picklist | Inspection type |
| `MUSW__Inspection_Date__c` | Date | Scheduled date |
| `MUSW__Result_Date__c` | Date | Result date |
| `MUSW__Inspector__c` | Reference | Inspector (User) |
| `MUSW__Comments__c` | TextArea | Inspector comments |

### MUSW__Fee__c (61 fields) - Fees

| Key Field | Type | Description |
|-----------|------|-------------|
| `MUSW__Permit2__c` | Reference | FK to Permit |
| `Name` | String | Fee name |
| `MUSW__Amount__c` | Currency | Fee amount |
| `MUSW__Status__c` | Picklist | Paid/Unpaid/Waived |
| `MUSW__Fee_Type__c` | Picklist | Fee category |
| `Fee_Paid_By__c` | Reference | Contact who paid |

### MUSW__Review__c (51 fields) - Plan Reviews

| Key Field | Type | Description |
|-----------|------|-------------|
| `MUSW__Permit2__c` | Reference | FK to Permit |
| `Name` | String | Review name |
| `MUSW__Status__c` | Picklist | Status |
| `MUSW__Review_Type__c` | Picklist | Review type |
| `MUSW__Reviewer__c` | Reference | Reviewer (User) |
| `MUSW__Due_Date__c` | Date | Review due date |
| `MUSW__Comments__c` | TextArea | Review comments |

### MUSW__Address__c (55 fields) - Addresses

| Key Field | Type | Description |
|-----------|------|-------------|
| `Name` | String | Full formatted address |
| `MUSW__Street__c` | String | Street address |
| `MUSW__City__c` | String | City |
| `MUSW__State__c` | String | State |
| `MUSW__Zip__c` | String | ZIP code |
| `MUSW__Parcel__c` | Reference | FK to Parcel |

### MUSW__Parcel__c (169 fields) - Parcels/TMK

| Key Field | Type | Description |
|-----------|------|-------------|
| `Name` | String | Parcel/TMK number |
| `MUSW__Primary_Contact__c` | Reference | Property owner |
| `MUSW__Parent_Parcel__c` | Reference | Parent parcel (subdivisions) |

## Salesforce Data Types Reference

The 529 Permit fields break down as:

| Data Type | Count | Description |
|-----------|-------|-------------|
| String | 118 | Text fields |
| Double | 106 | Numeric fields |
| Picklist | 94 | Single-select dropdowns |
| TextArea | 45 | Long text fields |
| Boolean | 42 | Checkboxes |
| Date | 40 | Date fields |
| Reference | 39 | Lookup/relationship fields |
| MultiPicklist | 26 | Multi-select dropdowns |
| Currency | 10 | Money fields |
| DateTime | 6 | Date + time fields |
| Email | 1 | Email field |
| Location | 1 | Geolocation field |
| Percent | 1 | Percentage field |
