# AEI Current Permit Tracking System - Audit

## Overview

AEI currently has a permit tracking system built into the scheduler that
includes document management, status tracking, and a (broken) DPP scraper.
This document audits the current state to inform the Salesforce integration.

## Database Tables

### 1. permit_files (WORKING - 59,732 rows)

Active document management table for permit-related files.

| Column | Type | Description |
|--------|------|-------------|
| `id` | int, PK | Auto-increment |
| `job_id` | int | FK to jobs table |
| `permit_no` | varchar | Building permit number |
| `original_filename` | varchar | Original upload filename |
| `unique_filename` | varchar | Encrypted storage filename |
| `type` | varchar | File category (37 distinct types) |
| `created` | datetime | Upload timestamp |
| `file_date` | int | File date |
| `filestatus` | varchar | File status |
| `created_by` | int | User who uploaded |

**Top file types:** building (7,527), spa (7,038), permit_open (6,858),
stc (6,140), netmeter (5,158), nemstatus (3,877)

**Stats:** 18,185 unique jobs have permit files. Latest upload: 2026-02-06.

### 2. permit_details (BROKEN - 17,605 rows)

Was intended to store DPP scraped inspection status data. No valid data
since March 2022. All 2,192 entries from 2025 have NULL data.

| Column | Type | Description |
|--------|------|-------------|
| `id` | int, PK | Auto-increment |
| `permit_no` | varchar | Building permit number |
| `objectid` | varchar | DPP PosseObjectId (all NULL since 2022) |
| `application_number` | varchar | DPP application number |
| `job_number` | varchar | AEI job number |
| `status` | varchar | Permit status from DPP |
| `created_date` | varchar | Created date from DPP |
| `issued_date` | varchar | Issue date from DPP |
| `date_construction_completed` | varchar | Completion date |
| `updated_date` | timestamp | Last update timestamp |
| `active` | tinyint | Active flag |

### 3. jobs table - Permit Columns (20+ fields)

The jobs table has permit fields with inconsistent naming and redundancy:

**Building Permit:**
- `building_permit` (int) - Permit number (26,508 jobs have values)
- `building_permit_status` (varchar) - "completed" (8,060) or "revoke" (51)
- `building_permit_completeiondate` (date) - Completion date (typo: "completeion")
- `permit_bulidingdate` (int) - Unix timestamp (typo: "buliding")
- `permit_buliding_updatedby` (int) - User ID

**Electrical Permit:**
- `electrical_permit` (int)
- `electrical_permit_status` (varchar)
- `electrical_permit_completeiondate` (varchar(50)) - Wrong type, should be DATE

**NEM/Net Metering:**
- `nemstatus_permit` (int)
- `nemstatus_permit_status` (varchar)
- `nemstatus_permit_completeiondate` (date)

**Other Permit Fields:**
- `permit_type` (varchar)
- `permit_fee` (varchar)
- `permit_other` (varchar)
- `permitting_status` (varchar)
- `permit_status_new` / `permit_status_new_date` (AJAX updates)
- `building_detail_tab_permit_status` / `building_details_tab_permit_completeiondate`
- `objectid` (varchar) - DPP PosseObjectId

**Data Quality Issues:**
- Column name typos: "buliding" instead of "building"
- Spelling errors: "completeion" instead of "completion"
- Wrong data type: `electrical_permit_completeiondate` is varchar(50)
- Three redundant status tracking approaches for building permits

## Controllers

| Controller | Method | Purpose |
|-----------|--------|---------|
| admin.php | `permit_job($job_id)` | Main permit page |
| admin.php | `downloadpermit($file_id)` | Download permit file |
| admin.php | `delete_permitfile($file_id, $jobid)` | Delete permit file |
| ajax.php | `add_permitfile_new($job_id, $type)` | Upload permit file |
| ajax.php | `permit_stauts_submit()` | Save permit status |
| permitapi.php | `admincron($val)` | DPP scraping cron (BROKEN) |
| permitapi.php | `buildingpermitstatus($permit_no, $jobid)` | Scrape building permit |
| permitapi.php | `electricalpermitstatus($permit_no, $jobid)` | Scrape electrical permit |
| permitapi.php | `permitstatusmail()` | Send status change emails |

## DPP Scraper - Why It Broke

The old DPP scraper (`permitapi.php`) broke because:

1. **Hardcoded ViewState tokens** - ASP.NET form tokens were captured from a
   specific browser session and hardcoded into the POST body
2. **Hardcoded HTML array indices** - Data extraction used `$data[0][14]`
   style indexing that broke when DPP changed their HTML
3. **Regex HTML parsing** - Used `preg_match_all` on `<span>` tags
4. **No error handling** - Silently inserts NULL records on failure
5. **DPP moved to Salesforce** - The old ASP.NET site was replaced with
   the Salesforce Experience Cloud portal, making all scraping obsolete

## Key Relationship: Jobs ↔ Permits

```
customers (id)
    └── jobs (customer_id → customers.id)
            ├── jobs.building_permit = DPP permit number (e.g., "189630")
            ├── jobs.electrical_permit = DPP electrical permit number
            ├── permit_files (job_id → jobs.id) = uploaded documents
            └── permit_details (permit_no = jobs.building_permit) = DPP status (BROKEN)
```

The AEI building permit number (e.g., `189630`) corresponds to the DPP
Salesforce permit `Name` field (e.g., `BP-2025-189630`). The prefix
`BP-2025-` is the permit type and year.
