# DPP Salesforce - Authentication & Session Handling

## Current Login Method

The portal uses standard Salesforce Experience Cloud login via the Aura
framework (not a standard OAuth flow).

**Login URL:** `https://honolulu.my.site.com/s/login/`
**Credentials:** `kahumana@gmail.com` / `Sun888Power`

### Login Flow
1. Navigate to `/s/login/`
2. POST to `/s/sfsites/aura` with action `applauncher.LoginForm.login`
3. Salesforce sets session cookies
4. Redirect to `/s/` (authenticated home)

### Session Cookies Set After Login

| Cookie | Purpose |
|--------|---------|
| `sid` | **Session ID** - used as Bearer token for UI API |
| `sid_Client` | Client-side session reference |
| `oid` | Organization ID (`00Da5000001ExEA`) |
| `inst` | Instance identifier (`APP_cx`) |
| `BrowserId` | Browser fingerprint |
| `__Secure-has-sid` | Secure flag indicating active session |

### Using the Session Token

The `sid` cookie value can be used as a Bearer token for UI API calls:

```
Authorization: Bearer {sid_cookie_value}
```

**Important:** This token is NOT valid for the standard REST API (`/services/data/v62.0/sobjects/`).
It ONLY works for:
- UI API (`/services/data/v62.0/ui-api/...`)
- UserInfo endpoint (`/services/oauth2/userinfo`)

## OAuth 2.0 Configuration

The site exposes a full OpenID Connect configuration at:
```
https://honolulu.my.site.com/.well-known/openid-configuration
```

### OAuth Endpoints

| Endpoint | URL |
|----------|-----|
| Authorization | `https://honolulu.my.site.com/services/oauth2/authorize` |
| Token | `https://honolulu.my.site.com/services/oauth2/token` |
| Revocation | `https://honolulu.my.site.com/services/oauth2/revoke` |
| UserInfo | `https://honolulu.my.site.com/services/oauth2/userinfo` |
| JWKS | `https://honolulu.my.site.com/id/keys` |
| Registration | `https://honolulu.my.site.com/services/oauth2/register` |
| Introspection | `https://honolulu.my.site.com/services/oauth2/introspect` |
| Logout | `https://honolulu.my.site.com/services/auth/idp/oidc/logout` |

### Supported OAuth Scopes

```
cdp_ingest_api, custom_permissions, cdp_segment_api, content, cdp_api,
chatbot_api, cdp_identityresolution_api, interaction_api, wave_api, web,
cdp_calculated_insight_api, einstein_gpt_api, offline_access, id, api,
eclair_api, email, pardot_api, lightning, visualforce, cdp_query_api,
sfap_api, address, openid, profile, scrt_api, cdp_profile_api,
refresh_token, phone, user_registration_api, pwdless_login_api,
chatter_api, mcp_api, full, forgot_password
```

### Supported Response Types
- `code` (Authorization Code)
- `token` (Implicit)
- `token id_token` (Implicit + ID Token)

### Token Endpoint Auth Methods
- `client_secret_post`
- `client_secret_basic`
- `private_key_jwt`

### OAuth Grant Types Tested

| Grant Type | Result | Notes |
|------------|--------|-------|
| `password` | BLOCKED | "unsupported_grant_type" - org has disabled Resource Owner Password flow |
| `authorization_code` | NOT TESTED | Requires a Connected App `client_id` |
| `client_credentials` | NOT TESTED | Requires a Connected App |

**Note:** To use OAuth properly, you would need a **Connected App** registered
in the Salesforce org (by the DPP admin). The `client_id` from that app would
enable the authorization code flow, which could potentially grant REST API access
if the user profile allows it.

## User Profile Details

```json
{
  "user_id": "005cx00000Bh8C5AAJ",
  "user_type": "CSP_LITE_PORTAL",
  "username": "kahumana@gmail.com",
  "name": "JULIAN KAHUMANA",
  "email": "kahumana@gmail.com",
  "org_id": "00Da5000001ExEAEA0"
}
```

### User Type: CSP_LITE_PORTAL

This is a **Customer Community Plus Lite** license. Key characteristics:
- Limited API access (UI API only, no standard REST/SOQL)
- Record visibility limited to owned/shared records
- Cannot query across all records
- No bulk API access
- Access governed by sharing rules set by the org admin

## Programmatic Access Strategy

### Option A: Browser Session Scraping (Current)
1. Login via Aura `LoginForm.login` action
2. Capture `sid` cookie
3. Use Bearer token for UI API calls
4. Session expires after inactivity (timeout config available)

### Option B: OAuth Authorization Code Flow (Requires Admin)
1. Register a Connected App in the Salesforce org
2. Get `client_id` and `client_secret`
3. Use authorization code flow at `/services/oauth2/authorize`
4. Exchange code for access token at `/services/oauth2/token`
5. May enable REST API access depending on profile permissions

### Option C: Headless Browser Automation
1. Use Playwright/Puppeteer to login
2. Capture network requests and session
3. Interact via Aura API as the browser does
4. Most flexible but most fragile approach

### Recommended Approach

For checking permit status programmatically, **Option A** is the most
practical without admin cooperation:

1. POST login credentials via the Aura login endpoint
2. Extract `sid` from response cookies
3. Call UI API endpoints with Bearer token
4. Parse JSON responses for permit data

The UI API provides rich, structured JSON data including all field values,
display values, picklist options, and record metadata.
