# API Test Results - permits@aeihawaii.com

**Test Date:** 2026-02-23
**Tester:** Claude (automated via Playwright + curl)
**Account:** permits@aeihawaii.com (ALTERNATE ENERGY INC)

## Account Profile

| Property | Value |
|----------|-------|
| Username | `permits@aeihawaii.com` |
| Password | `p455word` |
| Account Name | ALTERNATE ENERGY INC |
| User ID | `005cx000005lrh7AAA` |
| Organization ID | `00Da5000001ExEAEA0` |
| User Type | `CSP_LITE_PORTAL` (Customer Community Plus Lite) |
| Nickname | User17543620548262813107 |
| Address | 96-1276 Waihona St., Ste 114, Pearl City, HI 96782 |
| Timezone | Pacific/Honolulu |
| Email Verified | false |
| SF Integration User | false |

## Test Summary

| # | Test | Method | Result |
|---|------|--------|--------|
| 1 | Aura login (permits@) | curl | Login SUCCESS but no `sid` cookie returned |
| 2 | Aura login (kahumana@) | curl | Same - SUCCESS but no `sid` cookie |
| 3 | **Browser login (permits@)** | **Playwright** | **WORKS - full session with `sid` cookie** |
| 4 | UI API `/records/{id}` | curl + Bearer | BLOCKED - `API_DISABLED_FOR_ORG` |
| 5 | UI API `/object-info` | curl + Bearer | BLOCKED - `API_DISABLED_FOR_ORG` |
| 6 | UserInfo endpoint | curl + Bearer | WORKS |
| 7 | API version listing | curl | WORKS |
| 8 | UI API `/list-ui` metadata | curl + Bearer | WORKS (partial - returns list names) |
| 9 | UI API `/list-ui` data | curl + Bearer | BLOCKED - `API_DISABLED_FOR_ORG` |
| 10 | **My Permits portal page** | **Playwright** | **WORKS - 413 shared permits visible** |
| 11 | **Permit detail page** | **Playwright** | **WORKS - full data rendered** |
| 12 | Permit link structure | Playwright | Discovered URL pattern |
| 13 | Network capture (Aura calls) | Playwright | Captured internal Aura requests |
| 14 | Aura API (outside browser) | curl | BLOCKED - requires browser context |
| 15 | Aura API (in-browser fetch) | Playwright evaluate | BLOCKED - `clientOutOfSync` error |
| 16 | REST API (SOQL/sobjects) | curl | BLOCKED - "session not valid for REST API" |

## Detailed Test Results

### Test 1-2: Aura Login via curl

**Endpoint:** `POST https://honolulu.my.site.com/s/sfsites/aura`
**Action:** `apex://applauncher.LoginFormController/ACTION$login`

Both accounts (permits@ and kahumana@) returned:
```json
{"state":"SUCCESS","returnValue":null}
```

No `sid` cookie was set in the response headers. Salesforce changed how the Aura login endpoint works -- curl-based login no longer produces usable session cookies.

**Verdict:** Curl-based auth is dead. Browser login is required.

### Test 3: Playwright Browser Login (KEY FINDING)

**URL:** `https://honolulu.my.site.com/s/login/`
**Method:** Playwright form fill + click

1. Navigated to login page
2. Filled username and password via `page.fill()`
3. Clicked "Log in" button
4. Successfully redirected to `https://honolulu.my.site.com/s/` (Home page)
5. Page title: "Home"
6. Welcome message: "Welcome to the City and County of Honolulu's Online Permitting, Licensing, and Application Portal!"
7. 8 notifications visible for this account

**Session cookies captured:**

| Cookie | Value |
|--------|-------|
| `sid` | `00Da5000001ExEA!AQEAQP...` (truncated) |
| `sid_Client` | `x000005lrh75000001ExEA` |
| `oid` | `00Da5000001ExEA` |
| `inst` | `APP_cx` |
| `BrowserId` | `Q0cbxREIEfGSPG0ydyIm1g` |
| `__Secure-has-sid` | `0DMa50000005oaUGAQ` |

### Test 4-5: UI API with Bearer Token

**Endpoint:** `GET https://honolulu.my.site.com/services/data/v62.0/ui-api/records/a1Bcx000001Evx7EAC`
**Auth:** `Authorization: Bearer {sid}`

```json
{
  "message": "The Chatter Connect API is not enabled for this organization or user type.",
  "errorCode": "API_DISABLED_FOR_ORG"
}
```

This is **different** from the kahumana@ account which returned `"invalid session"`. The permits@ account has a **more restrictive** Salesforce profile.

### Test 6-7: UserInfo and API Versions

Both work fine with the `sid` Bearer token:
- `GET /services/oauth2/userinfo` -- returns full user profile JSON
- `GET /services/data/` -- returns API versions v31.0 through v66.0

### Test 8-9: List UI API

**Metadata works:** `GET /services/data/v62.0/ui-api/list-ui/MUSW__Permit2__c`
Returns 2 list views:
- `__Recent` (Recently Viewed)
- `My_Permits` (ID: `00Ba500000CSejJEAT`)

**Data blocked:** `GET .../list-ui/MUSW__Permit2__c/My_Permits`
Same `API_DISABLED_FOR_ORG` error when trying to fetch actual records.

### Test 10: Shared Permits Page (KEY FINDING)

**URL:** `https://honolulu.my.site.com/s/my-permits`

| Tab | Count |
|-----|-------|
| My Permits | 0 (all are shared, none owned) |
| **Shared Permits** | **413 unique permits** |

- **414 unique Salesforce record IDs** extracted (all starting with `a1B`)
- Includes **2026 permits** (current year)
- 50 permits displayed per page (paginated)

### Test 11: Permit Detail Page (KEY FINDING)

**URL:** `https://honolulu.my.site.com/s/permit2/a1Bcx000001QYezEAG/bp2026984`
**Page title:** "Permit: BP-2026-984"

Full detail page rendered with rich data:
- Phase (e.g., Inspection)
- Status
- Permit type
- Fee information
- Key dates
- Address and location
- CO status
- Action buttons: "Pay Outstanding Items", "Edit Access", "Request For Inspection"

### Test 12: Permit URL Pattern

**Format:** `/s/permit2/{sf_record_id}/{slug}`

Example links discovered:
```
/s/permit2/a1Bcx000001QYezEAG/bp2026984   → BP-2026-984
/s/permit2/a1Bcx000001QYIPEA4/bp2026972   → BP-2026-972
/s/permit2/a1Bcx000001QY0fEAG/bp2026963   → BP-2026-963
/s/permit2/a1Bcx000001Pt5ZEAS/bp2026867   → BP-2026-867
/s/permit2/a1Bcx000001PqfZEAS/bp2026836   → BP-2026-836
```

**Slug format:** lowercase permit type + year + number, no dashes (e.g., `bp2026984`)

### Test 13: Network Capture on Permit Detail

Portal makes internal Aura API calls:
```
POST /s/sfsites/aura?r=2&ui-force-components-controllers-recordGlobalValueProvider.RecordGvp.getRecord=1
```

Multiple `RecordGvp.getRecord` calls (r=2, r=3, r=4), plus `RecordHeadline.getInitData` and `RecordDetail.getInitData`.

### Test 14-15: Aura API Replication Attempts

**curl (outside browser):** Returns `{"state":"warning"}` -- Aura tokens require active browser context.

**In-browser fetch():** Two issues:
1. Aura response has a JSONP-like `*/` prefix that breaks JSON parsing
2. After stripping prefix: `clientOutOfSync` error -- requires exact `fwuid` and `loaded` context
3. `window.$A.getContext()` returns `mode: "PROD"` but `fwuid` is `undefined`

**Verdict:** Aura API cannot be called programmatically -- must parse rendered page content.

## Key Findings

### What Works
1. **Playwright browser login** produces a full session with all cookies
2. **Portal pages render all permit data** -- 413+ permits visible with full details
3. **Permit detail pages** contain all fields we need (phase, status, type, dates, fees, CO)
4. **URL pattern is predictable** from record ID + permit name

### What's Blocked
1. **All REST/UI APIs** return `API_DISABLED_FOR_ORG` for this account
2. **Aura API** requires exact browser context (fwuid, loaded map) -- cannot replicate via curl or fetch()
3. **SOQL queries** -- not available to Community portal users
4. **curl-based auth** -- Aura login no longer returns session cookies

### Comparison: permits@ vs kahumana@

| Capability | kahumana@gmail.com | permits@aeihawaii.com |
|-----------|-------------------|----------------------|
| User Type | CSP_LITE_PORTAL | CSP_LITE_PORTAL |
| Browser Login | Works | Works |
| Portal Pages | Works | Works |
| Shared Permits | 1 | **413** |
| UI API Records | "invalid session" | "API_DISABLED_FOR_ORG" |
| REST API | Blocked | Blocked |

The permits@ account has **more permits** but a **more restrictive** API profile. Both accounts require browser-based access exclusively.

### Conclusion

**The only viable approach is Playwright headless browser automation.** No API endpoints are accessible for programmatic data retrieval. All permit data must be extracted from rendered portal pages using DOM parsing.

The permits@aeihawaii.com account has 413+ shared permits including current-year (2026) permits, making it the correct account for production use.
