# DPP Salesforce - API Access Matrix

## Summary of API Availability

| API | Status | Auth Method | Notes |
|-----|--------|-------------|-------|
| **UI API** | WORKS | Bearer token (session cookie `sid`) | Primary usable API for this account |
| **Aura API** | WORKS | Session cookie (browser) | Internal framework API used by the portal |
| **REST API** (SOQL, sobjects) | BLOCKED | N/A | "This session is not valid for use with the REST API" |
| **Apex REST** | BLOCKED | N/A | 401 Unauthorized |
| **SOAP API** | BLOCKED | N/A | 500 error on login attempt |
| **Chatter/Connect API** | BLOCKED | N/A | "API_DISABLED_FOR_ORG" |
| **OAuth2 Endpoints** | AVAILABLE | See Authentication doc | OpenID config fully exposed |
| **UserInfo Endpoint** | WORKS | Bearer token | Returns user profile data |

## 1. UI API (Working)

The **Salesforce UI API** is the primary usable API. It is what powers the
Lightning Web Components on the portal and is accessible with the session
Bearer token.

**Base URL:** `https://honolulu.my.site.com/services/data/v62.0/ui-api/`

### Get Record by ID
```
GET /services/data/v62.0/ui-api/records/{recordId}?fields={ObjectName.Field1},{ObjectName.Field2}
Authorization: Bearer {sid_cookie_value}
Accept: application/json
```

**Example - Get permit details:**
```
GET /services/data/v62.0/ui-api/records/a1Bcx000001Evx7EAC?fields=MUSW__Permit2__c.Name,MUSW__Permit2__c.MUSW__Phase__c,MUSW__Permit2__c.MUSW__Status__c,MUSW__Permit2__c.MUSW__Description__c
```

**Response:**
```json
{
  "fields": {
    "Name": { "value": "BP-2025-189630", "displayValue": "BP-2025-189630" },
    "MUSW__Phase__c": { "value": "Review", "displayValue": "Review" },
    "MUSW__Status__c": { "value": "In Progress", "displayValue": "In Progress" },
    "MUSW__Description__c": { "value": "(Building Permit) [TMK: 39008016]..." }
  }
}
```

### Get Full Record UI (with layout)
```
GET /services/data/v62.0/ui-api/record-ui/{recordId}
Authorization: Bearer {sid_cookie_value}
```
Returns the full record with layout information, field metadata, and all
accessible field values. This is the richest single-call endpoint.

### Get Object Metadata
```
GET /services/data/v62.0/ui-api/object-info/{ObjectApiName}
Authorization: Bearer {sid_cookie_value}
```
Returns object label, field definitions, record types, picklist values, etc.

**Example:**
```
GET /services/data/v62.0/ui-api/object-info/MUSW__Permit2__c
```
Returns: label="Permit", 529 fields accessible.

### Get Picklist Values
```
GET /services/data/v62.0/ui-api/object-info/{ObjectApiName}/picklist-values/{recordTypeId}
```

### List Views
```
GET /services/data/v62.0/ui-api/list-ui/{ObjectApiName}
```
Returns available list views for the object. Confirmed working for
`MUSW__Permit2__c` (returns "Recently Viewed" and other lists).

### Get UserInfo
```
GET /services/oauth2/userinfo
Authorization: Bearer {sid_cookie_value}
```
Returns: user_id, user_type, username, name, email, org_id, profile URL.

## 2. Aura API (Working - Browser Context)

The Aura API is the internal RPC framework used by Salesforce Lightning
components. All portal interactions go through this endpoint.

**Endpoint:** `POST https://honolulu.my.site.com/s/sfsites/aura`

**Content-Type:** `application/x-www-form-urlencoded`

**Parameters:**
- `message` - JSON payload with action descriptors
- `aura.context` - JSON with framework UID, app name, mode
- `aura.token` - Session token (from sid cookie)

### Key Aura Actions Observed

| Action Descriptor | Purpose |
|-------------------|---------|
| `aura.ApexAction.execute` | Execute server-side Apex methods |
| `aura.RecordUi.getRecordUis` | Fetch record data with UI layout |
| `aura.RecordUi.getRecordCreateDefaults` | Get defaults for new record creation |
| `aura.RecordUi.getPicklistValuesByRecordType` | Get picklist options |
| `aura.Lookup.getLookupMetadata` | Get lookup field configuration |
| `aura.FlowRuntimeConnect.startFlow` | Start a Salesforce Flow |
| `applauncher.LoginForm.login` | Authentication |
| `NavigationMenuDataProvider.getNavigationMenu` | Get portal navigation |
| `Notifications.getNotifications` | User notifications |

### Aura Context Structure
```json
{
  "mode": "PROD",
  "fwuid": "<framework_uid>",
  "app": "siteforce:communityApp",
  "loaded": {},
  "dn": [],
  "globals": {},
  "uad": false
}
```

**Note:** The `fwuid` changes with Salesforce releases and must be captured
from a live session via `window.$A.getContext().fwuid`.

## 3. REST API (Blocked)

Standard Salesforce REST API endpoints return 401 with the community session:

```
GET /services/data/v62.0/sobjects/
GET /services/data/v62.0/query/?q=SELECT+Id+FROM+Account
GET /services/data/v62.0/sobjects/MUSW__Permit2__c/describe
```

**Error:** `{"message":"This session is not valid for use with the REST API","errorCode":"INVALID_SESSION_ID"}`

This is expected behavior - Community Portal user licenses (`CSP_LITE_PORTAL`)
do not include REST API access. The admin would need to enable "API Enabled"
on the user profile or upgrade the license type.

## 4. API Versioning

The site supports API versions **v31.0** (Summer '14) through **v66.0**
(Spring '26). Use **v62.0** or later for the most features.

## Limitations

1. **No SOQL access** - Cannot run arbitrary queries
2. **No sobject describe** - Cannot get full field metadata via REST
3. **Record-level security** - Can only access records shared with this user
4. **UI API only** - Limited to UI API endpoints; no bulk operations
5. **Session-based** - Token comes from browser session, not OAuth client_credentials
6. **Rate limits** - Standard Salesforce API limits apply
