# SSH Access Guide — AEI Infrastructure

**Last Updated:** 2026-02-23

---

## Servers Overview

| Server | Hostname | IP | SSH Port | Role |
|--------|----------|-----|----------|------|
| **Local Dev (WSL2)** | AEI-Chad | 172.25.255.189 (WSL) / 72.235.242.139 (external) | 22 (internal) / 55222 (external) | Development, photo storage |
| **Production (AWS EC2)** | — | 18.225.0.90 | 22 | Production app, database |

---

## 1. Local Dev Server (AEI-Chad)

### SSH Users

| User | Auth Method | Access Level | Purpose |
|------|------------|-------------|---------|
| **root** | Key-only (ed25519) | Full root | System admin, Claude Code |
| **aeiuser** | Password + key | sudo | Remote access (external) |
| **aeidev** | Password + key | sudo (restricted Future_Dev/) | Developer access |

### Root Access (Key-Only)

```bash
# From WSL/local
ssh -i /root/.ssh/aei_root_key root@127.0.0.1

# From Windows host
ssh -i \\wsl.localhost\Ubuntu-24.04-Backup\var\www\html\AEI_REMOTE\CONNECTORS\SSH\LOCAL\aei_root_key root@localhost
```

**Key files:**
- Private key: `/root/.ssh/aei_root_key`
- Public key: `/root/.ssh/aei_root_key.pub`
- Copy in connectors: `CONNECTORS/SSH/LOCAL/aei_root_key`
- Fingerprint: `SHA256:FhxvvGZjfUgyK2qe7uEDdElEb1KGusLHoPMnd+ZDYXk`

**Security:** Root password login is disabled. Only ed25519 key authentication is accepted.

### aeiuser Access (Remote / External)

```bash
# From anywhere (port 55222 forwards to WSL port 22)
ssh -p 55222 aeiuser@72.235.242.139
```

- Has `sudo` access for full root operations
- Password authentication enabled
- Protected by fail2ban (5 attempts / 10 min → 1 hour ban)

### aeidev Access (Developer)

```bash
# From Windows host
ssh aeidev@localhost

# Using stored key
ssh -i /home/aeidev/.ssh/aeidev_key aeidev@localhost
```

- Has `sudo` access (except Future_Dev/ — blocked by file permissions)
- Password + key authentication enabled
- Key fingerprint: `SHA256:WhjMv3YXeoRwzq8lskXkZRmYEMsFIQCGOOF4OrxPHrc`

### Security Configuration

**SSH Daemon** (`/etc/ssh/sshd_config`):
- `PermitRootLogin prohibit-password` — root key-only
- `AllowUsers root aeidev aeiuser` — whitelist only
- `MaxAuthTries 4` — brute force limit
- `LoginGraceTime 1m` — fast timeout
- `ClientAliveInterval 300` — 5-min keepalive (drops idle after 15 min)
- `X11Forwarding no` — disabled globally
- `AllowTcpForwarding no` — disabled per-user

**Fail2ban** (`/etc/fail2ban/jail.local`):
- `sshd` jail: 5 failures in 10 min → 1 hour ban
- `sshd-aggressive` jail: 3 failures in 30 min → 24 hour ban
- Ignores local IPs: `127.0.0.0/8`, `172.25.0.0/16`, `192.168.141.0/24`

**Network:**
- SSH listens on `0.0.0.0:22` (IPv4 only)
- External access via router port forward: `72.235.242.139:55222 → WSL:22`

### Key Storage

```
CONNECTORS/SSH/
├── LOCAL/                          ← Local dev server keys
│   ├── aei_root_key               ← Root private key (ed25519)
│   └── aei_root_key.pub           ← Root public key
├── schedular_server_private_key.ppk   ← Production server key (PuTTY)
├── schedular_server_private_key.pem   ← Production server key (OpenSSH)
└── SSH_ACCESS.md                  ← This file
```

---

## 2. Production Server (AWS EC2)

### SSH Access

```bash
# Quick connect (auto-converts PPK key)
/var/www/html/AEI_REMOTE/scripts/ssh_connect.sh

# Run a remote command
/var/www/html/AEI_REMOTE/scripts/ssh_connect.sh "ls -la /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/"
```

| Field | Value |
|-------|-------|
| **Host** | 18.225.0.90 |
| **User** | Julian (capital J) |
| **Auth** | Key-only (PPK/PEM) |
| **Key (PPK)** | `CONNECTORS/SSH/schedular_server_private_key.ppk` |
| **Key (PEM)** | `CONNECTORS/SSH/schedular_server_private_key.pem` |
| **Converted key** | `/tmp/aei_key` (runtime, generated by `ssh_connect.sh`) |
| **Production path** | `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/` |

### Manual SSH

```bash
ssh -i /var/www/html/AEI_REMOTE/CONNECTORS/SSH/schedular_server_private_key.pem Julian@18.225.0.90
```

---

## Troubleshooting

### SSH Connection Refused
```bash
# Check service
systemctl status ssh

# Restart if needed
systemctl restart ssh
```

### Locked Out (fail2ban)
```bash
# Check banned IPs
fail2ban-client status sshd

# Unban an IP
fail2ban-client set sshd unbanip <IP>
```

### Test Key Auth
```bash
# Verbose connection test
ssh -vvv -i /root/.ssh/aei_root_key root@127.0.0.1

# Verify authorized_keys
cat /root/.ssh/authorized_keys
```

### Config Validation
```bash
# Always test before restarting
sshd -t && systemctl restart ssh
```
