# Database Connection Details

## Local Development

| Parameter | Value |
|-----------|-------|
| **Host** | localhost |
| **Port** | 3306 |
| **Database** | mandhdesign_schedular |
| **Username** | root |
| **Password** | scheduler |

```bash
mysql -u root -pscheduler mandhdesign_schedular
```

### Config File
`/var/www/html/dev_scheduler/SCHEDULER/system/application/config/database.php`
```php
$db['default']['hostname'] = "localhost";
$db['default']['username'] = "root";
$db['default']['password'] = "scheduler";
$db['default']['database'] = "mandhdesign_schedular";
```

---

## Remote Production

| Parameter | Value |
|-----------|-------|
| **Host** | 18.225.0.90 |
| **Port** | 3306 |
| **Database** | mandhdesign_schedular |
| **Username** | AEI_User |
| **Password** | P@55w02d7777 |

```bash
mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' mandhdesign_schedular
```

### Notes
- `AEI_User` has read-only remote access
- `root` has full access from localhost on the server only
- Remote root (no password): `ssh -i /tmp/aei_key Julian@18.225.0.90 "mysql -u root mandhdesign_schedular"`

---

## Database Stats

| Metric | Value |
|--------|-------|
| **Tables** | 453 |
| **Largest table** | system_price_proposal (~4.3M rows) |
| **Second largest** | variable_job (~2.5M rows) |
| **Full dump size** | ~640MB compressed |
| **Dump time** | ~40 minutes |
| **Import time** | ~2 minutes |

### Local-Only Tables
These exist only in the local dev database:
- `esign_requests`
- `esign_signatures`
- `form_drafts`

---

## Weekly Backup

Automatic backups run every Sunday at 2:00 AM.

- **Script:** `/mnt/e/remote_scheduler_backup/scripts/weekly_db_backup.sh`
- **Storage:** `/mnt/e/remote_scheduler_backup/database/`
- **Format:** `full_backup_YYYY-MM-DD.sql.gz`

---

## CRITICAL

**NEVER** overwrite `database.php` or `config.php` on the local dev environment
with remote versions. They contain different connection settings. See
`PROJECT_DOCS/DEPLOYMENT_GUIDE.md` for the sync procedure that protects these files.
