# AEI Remote Project

## Project Purpose
Management hub for the AEI Hawaii Scheduler production system. Used for
bug fixes, enhancements, and maintenance of the scheduler web application.

## Key Paths
- This project: /var/www/html/AEI_REMOTE/
- Local dev site: /var/www/html/dev_scheduler/SCHEDULER/
- Remote production: Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/
- Backup mirror: /mnt/e/remote_scheduler_backup/source/

## Development Workflow

### Unified Deploy Pipeline (preferred)
```bash
# 1. Deploy + pre-flight check locally
scripts/aei_deploy.sh local admin.php

# 2. Test at http://dev.aeihawaii.com/scheduler/admin

# 3. Deploy to production
scripts/aei_deploy.sh production admin.php

# Emergency rollback
scripts/aei_deploy.sh rollback admin.php
```

Non-interactive by default (works from Claude). Add `--confirm` for terminal prompts.
Accepts shorthand names (`admin.php`) or full paths (`system/application/controllers/admin.php`).

### Manual workflow
1. Read PROJECT_DOCS/DEPLOYMENT_GUIDE.md for the full deployment process
2. Make changes in working directory or local dev site
3. Test locally at http://dev.aeihawaii.com/scheduler/
4. Deploy to remote using scripts/deploy_remote.sh
5. Verify on production

## Directory Guide
| Directory | What's In It |
|-----------|-------------|
| SCHEDULER_DOCS/ | **Symlink** → `/var/www/html/dev_scheduler/DOCS/` (canonical scheduler docs, 99+ files) |
| PROJECT_DOCS/ | Deployment, testing, workflow, and architecture guides |
| CONNECTORS/ | SSH keys, DB credentials, email credentials |
| scripts/ | Deployment and sync helper scripts |
| AEI_PHOTO_API_PROJECT/ | Photo upload system project (PHOTO-000 through PHOTO-024 + FUTURE) |
| WORK/ | Production maintenance items (MAINT-001 through MAINT-011) + migrations/ |
| audit/ | System audit scripts and reports (credentials, cron inventory) |
| DATA/ | PV system data mapping reference |
| LOCAL_SYNC/ | Remote-to-local sync procedures (detailed) |
| _backups/ | Symlink to /mnt/e/remote_scheduler_backup/ |

## Backup Locations

Two backup drives are used — local E: drive and AEISERVER NAS:

| Backup | Path | Drive | Contents |
|--------|------|-------|----------|
| **Code sync** | `/mnt/e/remote_scheduler_backup/source/` | E: (932GB) | Production scheduler source, synced from 18.225.0.90 |
| **DB backups** | `/mnt/e/remote_scheduler_backup/database/` | E: (932GB) | Weekly MySQL dumps (`.sql.gz`) |
| **Photo backup** | `/mnt/aeiserver_backup/AEIHawaii.com_backup/photo_backup/` | AEISERVER NAS (13TB) | 202K production `uploads/` root files (verified 2026-02-23) |
| **Dev backup** | `/mnt/aeiserver_backup/AEIHawaii.com_backup/dev_backup/` | AEISERVER NAS (13TB) | Production `/dev/` folder (8.4GB tar, removed from prod 2026-02-23) |
| **Full server** | `/mnt/aeiserver_backup/AEIHawaii.com_backup/` | AEISERVER NAS (13TB) | Full server ZIPs, DB dumps, Ubuntu_Server backup |

Mount points:
```
/mnt/e/                    → Local E: drive (9p/drvfs)
/mnt/aeiserver_backup/     → //AEISERVER/Backup (CIFS, 13TB NAS at 192.168.141.6)
```

## SSH Connection
```bash
scripts/ssh_connect.sh
# Or manually:
puttygen CONNECTORS/SSH/schedular_server_private_key.ppk -O private-openssh -o /tmp/aei_key
chmod 600 /tmp/aei_key
ssh -i /tmp/aei_key Julian@18.225.0.90
```

## Database
- Local: `mysql -u root -pscheduler mandhdesign_schedular`
- Remote: `mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' mandhdesign_schedular`

## Servers
| Server | IP | Domain | Role |
|--------|-----|--------|------|
| **Remote (AWS)** | 18.225.0.90 | aeihawaii.com | Scheduler app, Photo API, database |
| **Local (this machine)** | 72.235.242.139 | upload.aeihawaii.com | Photo storage, Dropbox sync, WSL2 |

## Critical Rules
- NEVER overwrite database.php or config.php on local dev (different credentials)
- After uploading files to remote: `sudo chown -R ec2-user:ec2-user /path/`
- **PHP 7.3.30** (upgraded from 5.3.29 on 2026-02-23) with **Apache 2.4.61** (mod_php7, prefork)
- DB driver is `mysqli` (changed from `mysql`; backup at `database.php.bak_php53`)
- PHP-FPM 7.3 also running as backup handler
- Always create remote backups before deploying
- Remote server runs as `apache` user — new directories need `chmod 777` for Apache write access
- Python on remote: `/usr/local/bin/python3.6` (no `python3` symlink)
- **Rollback:** `sudo yum swap httpd24 httpd` + restore `ssl.conf.rpmsave` + restore `database.php.bak_php53` + `sudo service httpd restart`

## Enhancement Routing

| Area | Path | Tracker | Next ID | Scope |
|------|------|---------|---------|-------|
| **Scheduler Core** | `dev_scheduler/ENHANCEMENTS/` | `TRACKER.md` | SCH-036 | Performance, queries, UI, bugs, cross-cutting features |
| **Photo API** | `AEI_PHOTO_API_PROJECT/ENHANCEMENTS/` | `ENHANCEMENT_LOG.md` | PHOTO-026 | Photo upload/sync/WebP/Dropbox/mobile listing |
| **Prod Maintenance** | `WORK/` | `README.md` | MAINT-015 | Hotfixes, prod performance, ops maintenance |

**Full methodology:** `PROJECT_DOCS/ENHANCEMENT_METHODOLOGY.md`

**Photo API conventions:** `PHOTO-NNN_NAME/` with `ORIGINAL/`, `NEW/`, `README.md`, `CHANGES.md`. Tracker uses table with Status column.
**Scheduler conventions:** `SCH-NNN_name/` with `original/`, `modified/`, `PLAN.md`. Tracker uses checkbox format.

## For Bug Fixes / Enhancements
- Read SCHEDULER_DOCS/README.md to navigate the scheduler docs (symlink to `/var/www/html/dev_scheduler/DOCS/`)
- Use SCHEDULER_DOCS/11-AI_CONTEXT_MAP/ for machine-readable lookups
- Follow PROJECT_DOCS/ENHANCEMENT_METHODOLOGY.md for new enhancement projects
- Follow PROJECT_DOCS/DEPLOYMENT_GUIDE.md for deploying changes
- **Note:** SCHEDULER_DOCS/ is a symlink. Edit docs at the canonical location (`dev_scheduler/DOCS/`) — they appear in both places automatically.

## File Ownership on Remote
- SSH user: Julian (access only)
- File owner: ec2-user:ec2-user (MUST restore after upload)
