<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Gallery – Job #<?php echo (int)$job_id; ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
  body { font-family: Arial, sans-serif; margin:0; background:#111; color:#eee; }
  .wrap { max-width: 1200px; margin: 0 auto; padding: 16px; }
  h1 { font-size:18px; margin: 8px 0 16px; color:#ddd; }
  .grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(160px,1fr));
    grid-gap: 10px;
  }
  .card {
    position: relative; border-radius: 10px; overflow: hidden; background:#1a1a1a;
    cursor: zoom-in; border:1px solid #222;
  }
  .card img {
    width: 100%; height: 160px; object-fit: cover; display:block; background:#222;
  }
  .cap {
    position:absolute; left:0; right:0; bottom:0; padding:6px 8px;
    font-size:12px; color:#ccc; background:linear-gradient(to top, rgba(0,0,0,.6), rgba(0,0,0,0));
  }
  /* Lightbox */
  .lightbox {
    position: fixed; inset:0; background: rgba(0,0,0,.92);
    display:none; align-items:center; justify-content:center; z-index: 9999;
  }
  .lightbox.open { display:flex; }
  .lb-img {
  width: 100vw;
  height: 100vh;
  object-fit: contain;
}
body.lb-open {
  overflow: hidden;
}

  .lb-close, .lb-prev, .lb-next {
    position: absolute; top: 50%; transform: translateY(-50%);
    background: rgba(255,255,255,.12); border:1px solid rgba(255,255,255,.25);
    color:#fff; padding:10px 14px; border-radius: 999px; cursor:pointer; user-select:none;
  }
  .lb-close { top: 24px; right: 24px; transform:none; }
  .lb-prev { left: 16px; }
  .lb-next { right: 16px; }
  .lb-info {
    position:absolute; left:16px; bottom:16px; color:#bbb; font-size:13px;
    background: rgba(0,0,0,.35); padding:6px 10px; border-radius:8px; border:1px solid rgba(255,255,255,.15);
  }
  @media (hover:hover) {
    .lb-prev:hover, .lb-next:hover, .lb-close:hover { background: rgba(255,255,255,.2); }
  }
</style>
</head>
<body>
<div class="wrap">
  <h1>Gallery – Job #<?php echo (int)$job_id; ?></h1> <a class="btn btn-primary" href="<?php echo site_url('preupload/download_all/'.$job_id); ?>">
  Download All Photos (.zip)
</a>
  <?php if (empty($items)): ?>
    <p>No images uploaded yet.</p>
  <?php else: ?>
  <div class="grid" id="gal"> 

    <?php foreach ($items as $i => $it): ?>
      <div class="card" data-idx="<?php echo $i; ?>" data-full="<?php echo htmlspecialchars($it['full']); ?>" data-title="<?php echo htmlspecialchars($it['title']); ?>">
        <img loading="lazy" src="<?php echo htmlspecialchars($it['thumb']); ?>" alt="">
        <div class="cap"><?php echo htmlspecialchars($it['title']); ?></div>
      </div>
    <?php endforeach; ?>
  </div>
  <?php endif; ?>
</div>

<div class="lightbox" id="lb" aria-hidden="true">
  <button class="lb-close" id="lbClose" title="Close">✕</button>
  <button class="lb-prev" id="lbPrev" title="Previous">‹</button>
  <img class="lb-img" id="lbImg" src="" alt="">
  <button class="lb-next" id="lbNext" title="Next">›</button>
  <div class="lb-info" id="lbInfo"></div>
</div>

<script>
(function(){
  var cards = document.querySelectorAll('.card');
  var lb = document.getElementById('lb');
  var lbImg = document.getElementById('lbImg');
  var lbInfo = document.getElementById('lbInfo');
  var lbClose = document.getElementById('lbClose');
  var lbPrev = document.getElementById('lbPrev');
  var lbNext = document.getElementById('lbNext');

  var items = [];
  for (var i=0;i<cards.length;i++){
    items.push({
      full: cards[i].getAttribute('data-full'),
      title: cards[i].getAttribute('data-title') || ''
    });
    (function(idx){
      cards[idx].addEventListener('click', function(){
        openAt(idx);
      });
    })(i);
  }
  var current = -1;

  function openAt(idx){
    if (idx < 0 || idx >= items.length) return;
    current = idx;
    lbImg.src = items[idx].full;
    lbInfo.textContent = (idx+1) + ' / ' + items.length + ' — ' + items[idx].title;
    lb.classList.add('open');
document.body.classList.add('lb-open');
lb.setAttribute('aria-hidden','false');

  }
 function closeLb(){
  lb.classList.remove('open');
  lb.setAttribute('aria-hidden','true');
  lbImg.src = '';
}

  function prev(){ if (items.length) openAt((current-1+items.length)%items.length); }
  function next(){ if (items.length) openAt((current+1)%items.length); }

  lbClose.addEventListener('click', closeLb);
  lbPrev.addEventListener('click', prev);
  lbNext.addEventListener('click', next);
  lb.addEventListener('click', function(e){ if (e.target === lb) closeLb(); });
  document.addEventListener('keydown', function(e){
    if (!lb.classList.contains('open')) return;
    if (e.key === 'Escape') closeLb();
    if (e.key === 'ArrowLeft') prev();
    if (e.key === 'ArrowRight') next();
  });
})();
</script>
</body>
</html>
