<?php
header('Content-Type: application/json');

// Read JSON body (assoc array)
$raw = file_get_contents('php://input');
$input = json_decode($raw, true);

if (!$input) {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid JSON body'));
    exit;
}

if (!isset($input['auth_token']) || !isset($input['job_id'])) {
    echo json_encode(array('status' => 'error', 'message' => 'Missing fields: auth_token, job_id'));
    exit;
}

// Same token as upload.php
if ($input['auth_token'] !== 'aei@89806849') {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid token'));
    exit;
}

// Collect input file references from multiple possible keys
$files = array();
if (isset($input['paths']) && is_array($input['paths'])) {
    $files = $input['paths']; // array of URLs (or strings)
} else if (isset($input['files']) && is_array($input['files'])) {
    $files = $input['files']; // array of names
} else if (isset($input['file_name']) && is_string($input['file_name']) && $input['file_name'] !== '') {
    $files = array($input['file_name']); // single string
} else {
    echo json_encode(array('status' => 'error', 'message' => 'Provide paths[], files[] or file_name'));
    exit;
}

// Sanitize job_id
$jobId = intval($input['job_id']);
if ($jobId <= 0) {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid job_id'));
    exit;
}

$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

// Get job_pid for this job (meter_files uses job_pid as job_id)
$pidQuery = "SELECT job_pid FROM jobs WHERE id = " . $jobId;
$pidResult = mysqli_query($sdb, $pidQuery);
$pidRow = mysqli_fetch_assoc($pidResult);
$jobPid = $pidRow ? intval($pidRow['job_pid']) : $jobId;

// Flat storage paths
$uploadsDir = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/';
$webpDir = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp/';

// --- optional logging with fwrite() ---
$logFile = __DIR__ . '/delete_log.txt';
$logHandle = fopen($logFile, 'a');
if (!$logHandle) {
    $logHandle = false; // continue silently if logging fails
}

// Helper: extract a safe filename from a URL or raw string
function get_safe_name_from_path($p) {
    if (!is_string($p) || $p === '') return '';

    // Try to parse as URL
    $u = @parse_url($p);
    if (is_array($u)) {
        // 1) Prefer ?img=... if present
        if (isset($u['query'])) {
            $qs = array();
            parse_str($u['query'], $qs);
            if (isset($qs['img']) && is_string($qs['img']) && $qs['img'] !== '') {
                $candidate = urldecode($qs['img']);
                return basename($candidate); // strip any path
            }
        }
        // 2) Fallback to URL path's basename
        if (isset($u['path'])) {
            $candidate = urldecode($u['path']);
            $name = basename($candidate);
            if ($name !== '' && $name !== '/' && $name !== '.' && $name !== '..') {
                return $name;
            }
        }
    }

    // Not a URL or parse failed; treat input as a filename
    return basename(urldecode($p));
}

$deleted = array();
$errors  = array();

foreach ($files as $ref) {
    $safeName = get_safe_name_from_path($ref);

    // Validate extracted filename
    if ($safeName === '' || preg_match('/[\/\\\\]/', $safeName)) {
        $errors[] = array('input' => $ref, 'error' => 'Invalid or empty filename');
        continue;
    }

    // Look up this file in meter_files by webpfilename
    $escapedName = mysqli_real_escape_string($sdb, $safeName);
    $lookupQuery = "SELECT id, unique_filename, webpfilename FROM meter_files
        WHERE job_id = " . $jobPid . "
        AND (webpfilename = '" . $escapedName . "' OR unique_filename = '" . $escapedName . "')
        LIMIT 1";
    $lookupResult = mysqli_query($sdb, $lookupQuery);
    $mfRow = $lookupResult ? mysqli_fetch_assoc($lookupResult) : null;

    $filesDeleted = false;

    if ($mfRow) {
        // Delete WebP file from flat storage
        if (!empty($mfRow['webpfilename'])) {
            $webpPath = $webpDir . $mfRow['webpfilename'];
            if (file_exists($webpPath)) {
                @unlink($webpPath);
            }
        }

        // Delete original file from flat storage
        if (!empty($mfRow['unique_filename'])) {
            $origPath = $uploadsDir . $mfRow['unique_filename'];
            if (file_exists($origPath)) {
                @unlink($origPath);
            }
        }

        // Delete meter_files DB row
        $deleteQuery = "DELETE FROM meter_files WHERE id = " . intval($mfRow['id']);
        mysqli_query($sdb, $deleteQuery);

        $filesDeleted = true;
        $deleted[] = $safeName;
    } else {
        // No DB record found — try direct file delete as fallback
        $webpPath = $webpDir . $safeName;
        $origPath = $uploadsDir . $safeName;

        if (file_exists($webpPath)) {
            @unlink($webpPath);
            $filesDeleted = true;
        }
        if (file_exists($origPath)) {
            @unlink($origPath);
            $filesDeleted = true;
        }

        if ($filesDeleted) {
            $deleted[] = $safeName;
        } else {
            $errors[] = array('file' => $safeName, 'error' => 'Not found in DB or filesystem');
        }
    }

    // Log success
    if ($filesDeleted && $logHandle) {
        $line = date('Y-m-d H:i:s') . " | Deleted: " . $safeName . " | JobID: " . $jobId . " | DB row: " . ($mfRow ? $mfRow['id'] : 'none') . "\n";
        fwrite($logHandle, $line);
    }
}

if ($logHandle) fclose($logHandle);

$status = 'ok';
if (!empty($errors) && !empty($deleted)) $status = 'partial';
if (!empty($errors) && empty($deleted))  $status = 'error';

echo json_encode(array(
    'status'  => $status,
    'job_id'  => $jobId,
    'deleted' => $deleted,
    'errors'  => $errors
));
