# AEI Photo Upload Pipeline — QA

**Last Updated:** 2026-02-22

---

## Overview

This folder contains QA tools for testing the AEI Photo Upload Pipeline — the complete flow from upload through remote server processing, WebP derivative generation, local server sync, and photo listing.

---

## Tools

| File | Purpose |
|------|---------|
| `test_upload_pipeline.py` | End-to-end pipeline test (52 steps, 10 phases) |

---

## Quick Start

```bash
cd /var/www/html/AEI_REMOTE/AEI_PHOTO_API_PROJECT

# Full E2E test (default job)
python3 QA/test_upload_pipeline.py

# Test with specific job
python3 QA/test_upload_pipeline.py --job-id 108946

# Skip cleanup to inspect test data
python3 QA/test_upload_pipeline.py --skip-cleanup

# Remote-only (skip local server checks)
python3 QA/test_upload_pipeline.py --remote-only

# Adjust wait time for slow networks
python3 QA/test_upload_pipeline.py --wait 20
```

### Prerequisites

- **Python packages:** `requests`, `Pillow` (pre-installed on this machine)
- **SSH key:** `/tmp/aei_key` (converted from PPK by `scripts/ssh_connect.sh`)
- **Network:** Access to `aeihawaii.com` (remote) and `upload.aeihawaii.com` (local)
- **Firewall:** AWS IP `18.225.0.90` must be in `trusted_whitelist` ipset on local server
- **DNS:** `aeihawaii.com` must resolve to `18.225.0.90` (check /etc/hosts)

---

## Test Phases (52 steps total, 44 remote-only)

### Phase 1: Mobile Upload (Steps 1-8)

| # | Step | What It Verifies |
|---|------|-----------------|
| 1 | API response | `upload.php` returns `{"success":1,"status":"ok"}` |
| 2 | Response time | Total response < 2 seconds (target: ~0.5s) |
| 3 | File saved | Original in `/mnt/dropbox/` or `uploads/staging/` |
| 4 | WebP generated | WebP derivative in `uploads/webp/` |
| 5 | File in staging/ | Upload landed in `uploads/staging/{disk_filename}` |
| 6 | WebP by DB name | WebP found via `meter_files.webpfilename` lookup |
| 7 | DB insert | `meter_files` record with correct fields |
| 8 | Sync log | `sync_to_local.py` success in logs |

### Phase 2: Duplicate Prevention (Steps 9-13)

| # | Step | What It Verifies |
|---|------|-----------------|
| 9-13 | Re-upload + unique filename | Duplicate uploads get unique filenames, no overwrite |

### Phase 3: Scheduler Upload (Steps 14-17)

| # | Step | What It Verifies |
|---|------|-----------------|
| 14-17 | Scheduler photo tab upload | CI multipart upload → staging/ → DB insert |

### Phase 4: Bad Input (Steps 18-21)

| # | Step | What It Verifies |
|---|------|-----------------|
| 18-21 | Invalid auth, bad job_id, empty file | Error handling and validation |

### Phase 5: Remote Checks (Steps 22-23)

| # | Step | What It Verifies |
|---|------|-----------------|
| 22 | File in staging/ | SSH verification: file exists in `uploads/staging/` |
| 23 | WebP exists | SSH verification: WebP in `uploads/webp/` via DB webpfilename |

### Phase 6: PHOTO-009 Listing (Steps 24-36)

| # | Step | What It Verifies |
|---|------|-----------------|
| 24-34 | Listing API structure | `getimagelisting.php` returns DB-driven results with correct fields |
| 35 | full_link → webp/ | PHOTO-022: `full_link` changed from `/hi-res/` to `/webp/` (hi-res tier removed) |
| 36 | Listing count | Expected number of results |

### Phase 7: Cleanup (Steps 37-42)

| # | Step | What It Verifies |
|---|------|-----------------|
| 37-42 | Test data cleanup | meter_files rows deleted, remote files cleaned |

### Phase 8: Directory Permissions (Steps 43-45)

| # | Step | What It Verifies |
|---|------|-----------------|
| 43-44 | uploads/ and webp/ dirs | Writable directories on remote |
| 45 | staging/thumbs/ | PHOTO-021/PHOTO-022 directories exist and writable (hi-res/ removed) |

### Phase 9: Large Photo Upload (Steps 46-47)

| # | Step | What It Verifies |
|---|------|-----------------|
| 46-47 | Real photo upload | Full-size photo upload + derivative generation (requires test_photos/ dir) |

### Phase 10: PHOTO-021/PHOTO-022 Staging & 2-Tier (Steps 48-52)

| # | Step | What It Verifies |
|---|------|-----------------|
| 48 | staging/ dir exists | `uploads/staging/` directory present on remote |
| 49 | Upload in staging/ | New upload lands in staging/ (disk_filename from API response) |
| 50 | WebP derivatives | thumbs/ + webp/ exist for uploaded photo; hi-res/ not generated (PHOTO-022) |
| 51 | DB-only listing | Listing API returns results from meter_files DB |
| 52 | full_link → webp/ | API `full_link` now points to `/webp/` (same as `link`) (PHOTO-022) |

---

## Test Results Log

### 2026-02-22 — Post-PHOTO-021 Full QA (52 steps)

**Changes tested:** PHOTO-021 (staging direct, DB-only listing, API full_link fix)

**Results: 42/44 PASS** (2 skips: Phase 9 requires test_photos/ directory)

Key PHOTO-021 validations — all passing:
- Step 5: File in uploads/staging/ — PASS
- Step 6: WebP found via DB webpfilename — PASS
- Step 22: File in uploads/staging/ (SSH) — PASS
- Step 35: full_link → /webp/ (PHOTO-022) — PASS (changed from /hi-res/)
- Step 45: staging/thumbs dirs writable (hi-res/ removed) — N/A
- Steps 48-52: Phase 10 PHOTO-021 tests — all PASS

### 2026-02-05 — Initial Deployment (19 steps)

**Results: 19/19 PASS** — see archive/OLD_PHOTO_SYSTEM_PROCESS_MAP.md for details

---

## Architecture Reference (Post-PHOTO-021)

```
Mobile App / Scheduler Web
  │
  ▼
upload.php / phototab.php / preupload.php
  ├── 1. Save to uploads/staging/{filename}
  ├── 2. INSERT meter_files (webpfilename, file_type=99)
  ├── 3. nohup generate_thumbnails.py &  → thumbs/ + webp/
  ├── 4. nohup sync_to_local.py &        → local server archival
  └── 5. Return response (immediate)
```

---

## Troubleshooting

### DNS / connectivity
- Ensure `aeihawaii.com` resolves to `18.225.0.90`: check `/etc/hosts`
- SSL: Test uses `verify=False` (self-signed cert on remote)

### SSH key
- Test uses `/tmp/aei_key` — convert from PPK: `AEI_REMOTE/scripts/ssh_connect.sh`

### Test fails at step 1 (API response)
- Check remote server: `ssh -i /tmp/aei_key Julian@18.225.0.90 "service httpd status"`
- Check PHP syntax: `ssh ... "php -l /var/www/.../photoapi/upload.php"`

### Test fails at step 5 (file not in staging/)
- `upload.php` saves as `{uniqid}_{filename}` — test looks for disk_filename from API response
- Check: `ssh ... "ls -la /var/www/.../scheduler/uploads/staging/ | tail -5"`

### Test fails at step 6 (WebP not found)
- Test looks up `webpfilename` from `meter_files` DB, then checks `uploads/webp/{webpfilename}`
- Check: `ssh ... "ls -la /var/www/.../scheduler/uploads/webp/ | tail -5"`

### Steps 46-47 skip (no test_photos/)
- Phase 9 requires a `test_photos/` directory with real high-res photos
- This is a pre-existing infrastructure gap — create the directory to enable these tests

### Firewall whitelist
```bash
# Required after local server reboot
sudo ipset add trusted_whitelist 18.225.0.90
```

---

## Files on Servers

### Remote Server (18.225.0.90)
| File | Purpose |
|------|---------|
| `/var/www/.../photoapi/upload.php` | Main upload handler |
| `/var/www/.../photoapi/sync_to_local.py` | Background local server sync |
| `/var/www/.../photoapi/generate_webp.py` | Background WebP generation |
| `/var/www/.../photoapi/logs/sync_to_local.log` | Sync log (monitor with `tail -f`) |
| `/var/www/.../photoapi/process_retry_queue.py` | Cron-driven retry processor (*/15) |
| `/var/www/.../photoapi/queue/` | Failed sync payloads (JSON, retried by cron) |
| `/var/www/.../photoapi/queue/failed/` | Expired items (>10 retries) |
| `/var/www/.../photoapi/logs/retry_queue.log` | Retry processor log |

### Local Server (upload.aeihawaii.com)
| File | Purpose |
|------|---------|
| `/var/www/html/upload/uploadlocallat_kuldeep.php` | Upload handler |
| `/var/www/html/upload/upload_thumb_generator.py` | Background thumbnail generator |
| `/var/www/html/upload/db_config.php` | DB config for unified_customers |
| `/var/opt/map_dropbox/` | Customer folder mapping database |

---

*QA created: 2026-02-05*
