# PHOTO-025: Remove S3/AWS Dependency

**Date:** 2026-02-23
**Status:** Deployed

## Problem

`phototab.php` and `loginapi.php` both have `require '/var/www/vhosts/aeihawaii.com/httpdocs/scaws/aws.phar'` at line 2 (file top level). When MAINT-013 removed the `scaws/` directory as part of dead vhosts cleanup, the require caused a fatal error — every method in both controllers returned HTTP 500.

The S3 SDK was only used in one method (`phototab.php` ~line 797, `s3_upload()`), which hasn't been called since the photo system moved to direct file storage (PHOTO-009 + PHOTO-017). The `loginapi.php` S3 code was similarly unused.

## Root Cause

- `require` (not `require_once`, not `include`) at file top level = PHP fatal error if file missing
- Fatal happens before any controller method loads, so ALL routes in the controller fail
- Apache error log didn't show the fatal (display_errors=Off, no error_log configured for this vhost)
- MAINT-013 deleted `scaws/` without checking for code references

## Impact

- **phototab.php** — All photo tab routes returned 500 (photo_index, upload, delete, download, etc.)
- **loginapi.php** — All mobile API routes returned 500 (login, photo listing, upload, etc.)

## Solution

Commented out the `require` and `use` statements in both files:

```php
// require '/var/www/vhosts/aeihawaii.com/httpdocs/scaws/aws.phar'; // MAINT-012: scaws/ removed
// use Aws\S3\S3Client; // MAINT-012: S3 no longer used
```

The S3 upload method body remains in `phototab.php` but is unreachable (no route calls it). It can be removed in a future cleanup.

## Verification

- `curl -sI http://aeihawaii.com/scheduler/phototab/photo_index/106470` returned 302 (redirect to login) instead of 500
- Both controllers functional — all photo tab and mobile API routes restored

## Files Modified

| File | Change |
|------|--------|
| `controllers/phototab.php` | Commented out `require aws.phar` (line 2) and `use Aws\S3\S3Client` (line 3) |
| `controllers/loginapi.php` | Commented out `require aws.phar` (line 2) and `use Aws\S3\S3Client` (line 3) |

## Dead Code (Future Cleanup)

- `phototab.php` `s3_upload()` method (~line 797) — S3 upload code, never called
- `loginapi.php` S3-related methods — similarly unused
- These can be removed when the controllers are next modified

## Related

- **MAINT-013** — Dead vhosts cleanup that removed `scaws/` directory
- **PHOTO-009** — Unified storage (eliminated S3 dependency for photo reads)
- **PHOTO-017** — Derivatives-only remote store (eliminated S3 dependency for photo writes)
- **PHOTO-013** — Security hardening (previously removed S3 credentials from commented code in `photoappsch/loginapi.php`)
