# PHOTO-024: Remove uploads/ Root Dependency

**Date:** 2026-02-23
**Status:** Deployed

## Problem

PHOTO-023 added archive copies (`shutil.copy2()`) from `staging/` to `uploads/` root, making the "frozen" label on `uploads/*.jpg` incorrect. The `uploads/` root was still growing with every upload. Meanwhile, `sync_to_local.py` already archives full-size originals to the local server with retry guarantees.

The archive copy was redundant. Additionally, the download ZIP fallback used `uploads/{unique_filename}` (JPEG) when WebP wasn't available, creating a dependency on `uploads/` root.

## Solution

1. **Remove archive copy** from `generate_thumbnails.py` (v6.0 -> v7.0)
2. **Remove archive copy deletion** from `delete_image.php`
3. **ZIP downloads use WebP only** — `download_all_photos()` in `phototab.php` now sources exclusively from `uploads/webp/{webpfilename}`, skipping photos without `webpfilename`
4. Full-size archival handled exclusively by `sync_to_local.py` -> local server -> Dropbox

## Verification

- All 202,479 production `uploads/` root files backed up to `/mnt/aeiserver_backup/.../photo_backup/` (0 missing)
- All meter_files photos have `webpfilename` set (0 NULL rows)
- QA tests: 55/55 passed (step 60 confirms no archive copy created)

## Files Modified

| File | Change |
|------|--------|
| `generate_thumbnails.py` | v7.0: removed `shutil.copy2()` archive block, removed `shutil` import |
| `delete_image.php` | Removed `uploads/{unique_filename}` archive deletion block |
| `phototab.php` `download_all_photos()` | WebP only: removed JPEG fallback from `uploads/` root |
| `PHOTO_SYSTEM_PROCESS_MAP.md` | Updated architecture, storage, flows, enhancement history |
| `test_upload_pipeline.py` | Updated Phase 12 tests for PHOTO-024 |

## Pending: Storage Cleanup (~200GB)

With no code paths writing to or reading from `uploads/` root for new photos, the ~202K legacy files (~200GB) are safe to delete. Prerequisites verified:
- Local backup complete (0 files missing)
- All photos have WebP derivatives (0 NULL webpfilename)
- No active code references `uploads/` root for new photos
