<?php
/**
 * delete_image.php — Delete photo files from all storage tiers
 *
 * Called by phototab.php::delete_image_ajax() after DB rows are removed.
 *
 * Accepts two formats:
 *   1. Batch (new): { auth_token, job_id, files: [{unique_filename, webpfilename, original_filename, folder_path}, ...] }
 *   2. Single (legacy): { auth_token, job_id, img: "filename" }
 *
 * Deletes from:
 *   - uploads/staging/{unique_filename}
 *   - uploads/thumbs/{webpfilename}
 *   - uploads/webp/{webpfilename}
 *   - /mnt/aeiserver/{job_id}/{unique_filename}
 *
 * Notifies local server (upload.aeihawaii.com) to delete Dropbox-synced copies.
 */

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token']) || $data['auth_token'] !== 'aei@89806849') {
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

$jobId = isset($data['job_id']) ? basename($data['job_id']) : '';
$uploadsDir = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads';
$deleted = array();
$errors = array();

// New batch format: files array
if (isset($data['files']) && is_array($data['files'])) {
    foreach ($data['files'] as $file) {
        $unique   = isset($file['unique_filename'])  ? basename($file['unique_filename']) : '';
        $webp     = isset($file['webpfilename'])     ? basename($file['webpfilename']) : '';
        $original = isset($file['original_filename'])? basename($file['original_filename']) : '';
        $folder   = isset($file['folder_path'])      ? $file['folder_path'] : '';

        // Delete staging original
        if ($unique) {
            $path = $uploadsDir . '/staging/' . $unique;
            if (is_file($path)) {
                if (unlink($path)) { $deleted[] = $path; }
                else { $errors[] = $path; }
            }
        }

        // Delete WebP thumbnail (200x200)
        if ($webp) {
            $path = $uploadsDir . '/thumbs/' . $webp;
            if (is_file($path)) {
                if (unlink($path)) { $deleted[] = $path; }
                else { $errors[] = $path; }
            }
        }

        // Delete WebP large (1024px lightbox)
        if ($webp) {
            $path = $uploadsDir . '/webp/' . $webp;
            if (is_file($path)) {
                if (unlink($path)) { $deleted[] = $path; }
                else { $errors[] = $path; }
            }
        }

        // Delete legacy /mnt/aeiserver path
        if ($unique && $jobId) {
            $path = "/mnt/aeiserver/$jobId/$unique";
            if (is_file($path)) {
                if (unlink($path)) { $deleted[] = $path; }
                else { $errors[] = $path; }
            }
        }

        // Notify local server to delete Dropbox-synced copy
        // Local server looks up folder_path from its own local_photos table
        if ($unique && $jobId) {
            $localUrl = 'https://upload.aeihawaii.com/delete_local_photo.php?'
                . http_build_query(array(
                    'auth_token'      => 'aei_local_delete_89806849',
                    'job_id'          => $jobId,
                    'unique_filename' => $unique
                ));
            $ctx = stream_context_create(array('http' => array('timeout' => 5)));
            @file_get_contents($localUrl, false, $ctx);
        }
    }
}
// Backward compat: old single-file format
elseif (isset($data['img'])) {
    $fileName = isset($data['img']) ? basename($data['img']) : '';
    if ($fileName && $jobId) {
        $path = "/mnt/aeiserver/$jobId/$fileName";
        if (is_file($path)) {
            if (unlink($path)) { $deleted[] = $path; }
            else { $errors[] = $path; }
        }
    }
}

echo json_encode(array(
    "status"  => "ok",
    "deleted" => count($deleted),
    "errors"  => count($errors)
));
