# PHOTO-023: WebP Resolution Bump + Verified Staging Cleanup

**Status:** Implemented
**Date:** 2026-02-22
**Risk:** Low
**Depends On:** PHOTO-022

---

## Summary

Two improvements to the photo system pipeline:

1. **Resolution bump** (1024 -> 1280px): The standard WebP tier (`uploads/webp/`) is now the highest-quality remote copy after hi-res removal in PHOTO-022. Bumped from 1024px to 1280px max dimension at Q80 for better full-size viewing in the scheduler lightbox and on mobile devices.

2. **Verified staging cleanup**: `cleanup_staging()` previously deleted staging files purely on age (>7 days). Now verifies each file exists on the local server via `check_photos.php` before deleting. Unverified files are left for reconciliation to re-queue. Orphans (no DB record) get a 14-day grace period.

## Files Changed

| File | Change |
|------|--------|
| `generate_thumbnails.py` | `MAX_LARGE` 1024 -> 1280, version 5.0 -> 5.1 |
| `backfill_thumbnails.py` | `MAX_LARGE` 1024 -> 1280, version 3.0 -> 3.1 |
| `process_retry_queue.py` | Rewrote `cleanup_staging()` with DB lookup + API verification |

## Change Details

### Resolution Bump
- `MAX_LARGE = 1280` (was 1024)
- Quality stays Q80 — no change
- Existing 1024px files are NOT re-generated (idempotent skip in both scripts)
- Only new uploads get 1280px; backfill can upscale existing files later if desired

### Verified Staging Cleanup

**Old flow:**
```
for each file in staging/:
    if mtime > 7 days: delete
```

**New flow:**
```
1. Collect files with mtime > 7 days
2. Query meter_files for metadata
3. Batch-POST to check_photos.php (reuses existing endpoint, 200/batch)
4. Verified-on-local: delete (safe)
5. NOT verified: log STAGING_CLEANUP_SKIPPED, leave for reconciliation
6. Orphans (no DB record, >14 days): delete as housekeeping
7. On HTTP/network error: abort cleanup this cycle (safe fallback)
```

Reuses existing constants: `CHECK_PHOTOS_URL`, `AUTH_TOKEN`, `CONNECT_TIMEOUT`, `READ_TIMEOUT`, `RECONCILE_BATCH_SIZE`, `SURVEY_JOB_TYPES`, DB credentials.

## Deployment

```bash
# SCP all 3 files to remote server
scp generate_thumbnails.py backfill_thumbnails.py process_retry_queue.py \
    Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/
```

No scheduler-side or PHP changes needed.

## Verification

1. Upload a test photo -> check `webp/` derivative is 1280px max (not 1024px)
2. Check staging cleanup logs next day: `STAGING_CLEANUP_VERIFIED` messages with counts
3. Manually verify: staging files without local sync are preserved (not deleted)

## Rollback

Replace all 3 files with copies from `ORIGINAL/`.
