# PHOTO-022: Remove Hi-Res Tier from Photo System

**Status:** Complete
**Date:** 2026-02-22
**Area:** Photo API

## Summary

Removed the hi-res (2048px) WebP derivative tier from the photo system. Since full-size originals are archived on the local server via `sync_to_local.py`, the hi-res tier was redundant — adding processing time, disk usage, and complexity for no benefit.

Simplified from 3-tier (thumbs + webp + hi-res) to **2-tier (thumbs + webp)**.

## Files Modified

| File | Change |
|------|--------|
| `generate_thumbnails.py` | Removed hi-res constants, path, Phase 2 block; version → 5.0 |
| `backfill_thumbnails.py` | Removed hi-res constants, sets, generation, verify; version → 3.0 |
| `getimagelisting.php` | `full_link` → `/webp/` (was `/hi-res/`) |
| `getimagelistingnew.php` | `full_link` → `/webp/` (was `/hi-res/`) |
| `getimagelisting1.php` | `full_link` → `/webp/` (was `/hi-res/`) |
| `upload.php` | Removed hi-res comment line |
| `lightbox.js` | Full Size link uses `/webp/` directly (removed hi-res URL rewrite) |

## Deployment

1. Python scripts → SCP to remote server `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/photoapi/`
2. PHP listing files → SCP to remote server same directory
3. lightbox.js → `aei_deploy.sh production`
4. Existing `uploads/hi-res/` directory left in place (harmless frozen data)

## Verification

1. Upload test photo via scheduler — confirm only `thumbs/` and `webp/` get derivatives
2. Confirm lightbox display works, "Full Size" link opens `/webp/` version
3. Test mobile listing API — `full_link` points to `/webp/`
4. No hi-res file created for new upload
