<?php
header('Content-Type: application/json');

// === PHOTO-017: Rewritten to use meter_files DB instead of /mnt/aeiserver/ filesystem ===
// Returns most recent photo for a job with thumb_link for mobile app thumbnails

// === CONFIGURATION ===
$staticBase = 'https://aeihawaii.com/scheduler/uploads';

// === STEP 1: Get and Validate JSON Input ===
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token'], $data['job_id'])) {
    echo json_encode(array("status" => "error", "message" => "Missing auth_token or job_id"));
    exit;
}

if ($data['auth_token'] !== 'aei@89806849') {
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// === STEP 2: Look up job_pid from jobs table ===
$jobId = intval($data['job_id']);

$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");
if (!$sdb) {
    echo json_encode(array("status" => "error", "message" => "Database connection failed"));
    exit;
}

$query = "SELECT job_pid FROM jobs WHERE id = " . $jobId;
$result = mysqli_query($sdb, $query);

if (!$result) {
    echo json_encode(array("status" => "error", "message" => "Query failed"));
    mysqli_close($sdb);
    exit;
}

$row = mysqli_fetch_assoc($result);
if (!$row) {
    echo json_encode(array("status" => "error", "message" => "Job not found"));
    mysqli_close($sdb);
    exit;
}

$jobPid = intval($row['job_pid']);

// === STEP 3: Query meter_files for most recent photo ===
$mfQuery = "SELECT webpfilename, created
    FROM meter_files
    WHERE job_id = " . $jobPid . "
    AND file_type = 99
    AND webpfilename IS NOT NULL
    AND webpfilename != ''
    ORDER BY created DESC
    LIMIT 1";
$mfResult = mysqli_query($sdb, $mfQuery);

if (!$mfResult) {
    echo json_encode(array("status" => "error", "message" => "Photo query failed"));
    mysqli_close($sdb);
    exit;
}

$mfRow = mysqli_fetch_assoc($mfResult);
mysqli_close($sdb);

if (!$mfRow) {
    echo json_encode(array("status" => "error", "message" => "No photos"));
    exit;
}

// === STEP 4: Build response with thumb_link ===
$encodedImg = rawurlencode($mfRow['webpfilename']);
$response = array(
    "link" => $staticBase . '/webp/' . $encodedImg,
    "thumb_link" => $staticBase . '/thumbs/' . $encodedImg,
    "full_link" => $staticBase . '/hi-res/' . $encodedImg,
    "created" => $mfRow['created'],
    "status" => "ok"
);

echo json_encode($response);
