<?php
header('Content-Type: application/json');

// === CONFIGURATION ===
// PHOTO-017: Direct static URLs for performance (no PHP streaming)
$staticBase = 'https://aeihawaii.com/scheduler/uploads';
// Legacy fetch endpoint kept for backwards compatibility
$fetchBaseUrl = 'https://aeihawaii.com/photoapi/fetch_image1.php?job_id=';

// === STEP 1: Get and Validate JSON Input ===
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token'], $data['job_id'])) {
    echo json_encode(array("status" => "error", "message" => "Missing auth_token or job_id"));
    exit;
}

if ($data['auth_token'] !== 'aei@89806849') {
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// === STEP 2: Get Requested Job and Customer ID ===
$jobId = intval($data['job_id']);
$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

if (!$sdb) {
    echo json_encode(array("status" => "error", "message" => "Database connection failed"));
    exit;
}

$query = "SELECT js.customer_id, js.job_pid, cs.first_name, cs.last_name, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN customers cs ON js.customer_id = cs.id
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.id = " . $jobId;
$result = mysqli_query($sdb, $query);

if (!$result) {
    echo json_encode(array("status" => "error", "message" => "Query failed"));
    exit;
}

$row = mysqli_fetch_assoc($result);

if (!$row) {
    echo json_encode(array("status" => "error", "message" => "Job not found"));
    exit;
}

$customerId = intval($row['customer_id']);

// === STEP 3: Query ALL Jobs for This Customer (to get job_pids) ===
$query2 = "SELECT js.id, js.job_pid, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.customer_id = " . $customerId . "
    ORDER BY js.job_date DESC";
$result2 = mysqli_query($sdb, $query2);

if (!$result2) {
    echo json_encode(array("status" => "error", "message" => "Jobs query failed"));
    exit;
}

// Collect job info: map job_pid -> job data (same approach as getimagelisting.php)
$jobsByPid = array();
while ($jobRow = mysqli_fetch_assoc($result2)) {
    $pid = intval($jobRow['job_pid']);
    $jobsByPid[$pid] = $jobRow;
}

$images = array();

// === STEP 4: Query meter_files directly (no JOIN to avoid cross-join duplicates) ===
$allPids = array_keys($jobsByPid);

if (!empty($allPids)) {
    $pidList = implode(',', $allPids);
    $mfQuery = "SELECT mf.webpfilename, mf.job_id, mf.unique_filename, mf.created
        FROM meter_files mf
        WHERE mf.job_id IN (" . $pidList . ")
        AND mf.file_type = 99
        AND mf.webpfilename IS NOT NULL
        AND mf.webpfilename != ''
        ORDER BY mf.created DESC";
    $mfResult = mysqli_query($sdb, $mfQuery);
    if ($mfResult) {
        while ($mfRow = mysqli_fetch_assoc($mfResult)) {
            $pid = intval($mfRow['job_id']);
            $img = $mfRow['webpfilename'];

            // Look up the job row for this pid to get job metadata
            $jobRow = isset($jobsByPid[$pid]) ? $jobsByPid[$pid] : null;
            $jt = '';
            $job_date = '';
            $photo_type = '';

            if ($jobRow) {
                $jt = $jobRow['intials'];
                $job_date = date("m-d-Y", strtotime($jobRow['job_date']));

                if ($jt == "PM" || $jt == "WM" || $jt == "AS" || $jt == "RPM" || $jt == "GCPM") {
                    $photo_type = 'Survey';
                } else {
                    $photo_type = 'Installation';
                }
            }

            // Find the corresponding jobs.id for this job_pid
            $relatedJobId = $jobRow ? intval($jobRow['id']) : $pid;

            // PHOTO-017: Direct static URLs — served by Apache, no PHP overhead
            $encodedImg = rawurlencode($img);
            $images[] = array(
                "link" => $staticBase . '/webp/' . $encodedImg,
                "thumb_link" => $staticBase . '/thumbs/' . $encodedImg,
                "full_link" => $staticBase . '/hi-res/' . $encodedImg,
                "job_id" => $relatedJobId,
                "job_type" => $jt,
                "job_date" => $job_date,
                "photo_type" => $photo_type
            );
        }
    }
}

// === STEP 5: Fetch Survey Photos from Local Server with Pre-cached Thumbnails (PHOTO-016) ===
// Single curl to local API with include_thumbs=1 — returns base64 thumbnails inline.
// We decode and write thumbs to /tmp/survey_photo_cache/ so serve_survey_photo.php
// can serve them instantly via readfile() without proxying.
$cacheDir = '/tmp/survey_photo_cache';
$serveBase = 'https://aeihawaii.com/photoapi/serve_survey_photo.php';
$surveyApiUrl = 'https://upload.aeihawaii.com/get_survey_photos.php?customer_id='
    . $customerId . '&type=survey&include_thumbs=1';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $surveyApiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
$surveyResponse = curl_exec($ch);
$surveyHttpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($surveyResponse !== false && $surveyHttpCode === 200) {
    $surveyData = json_decode($surveyResponse, true);
    if ($surveyData && isset($surveyData['success']) && $surveyData['success'] === true
        && isset($surveyData['photo_types']['survey'])) {

        // Ensure cache directory exists
        if (!is_dir($cacheDir)) {
            @mkdir($cacheDir, 0777, true);
        }

        foreach ($surveyData['photo_types']['survey'] as $year => $yearData) {
            if (!isset($yearData['folders'])) continue;
            foreach ($yearData['folders'] as $folder) {
                if (!isset($folder['photos'])) continue;
                foreach ($folder['photos'] as $photo) {
                    // Extract path from mid_url (e.g. "serve_photo.php?path=...")
                    $midUrl = isset($photo['mid_url']) ? $photo['mid_url'] : '';
                    $midPath = '';
                    if (strpos($midUrl, 'path=') !== false) {
                        $midPath = substr($midUrl, strpos($midUrl, 'path=') + 5);
                    }

                    // Extract path from original_url
                    $origUrl = isset($photo['original_url']) ? $photo['original_url'] : '';
                    $origPath = '';
                    if (strpos($origUrl, 'path=') !== false) {
                        $origPath = substr($origUrl, strpos($origUrl, 'path=') + 5);
                    }

                    // Extract path from thumbnail_url
                    $thumbUrl = isset($photo['thumbnail_url']) ? $photo['thumbnail_url'] : '';
                    $thumbPath = '';
                    if (strpos($thumbUrl, 'path=') !== false) {
                        $thumbPath = substr($thumbUrl, strpos($thumbUrl, 'path=') + 5);
                    }

                    // Use mid path for link, fall back to thumb path
                    $linkPath = ($midPath !== '') ? $midPath : $thumbPath;
                    if ($linkPath === '') continue;

                    // Build thumb_link: pre-cache base64 thumbnail to disk if available
                    $thumbLink = '';
                    if (isset($photo['thumbnail_base64']) && $photo['thumbnail_base64'] !== '') {
                        // Strip data URI prefix if present (e.g. "data:image/webp;base64,...")
                        $b64 = $photo['thumbnail_base64'];
                        $commaPos = strpos($b64, ',');
                        if ($commaPos !== false && $commaPos < 40) {
                            $b64 = substr($b64, $commaPos + 1);
                        }
                        $thumbData = base64_decode($b64);
                        if ($thumbData !== false && strlen($thumbData) > 0) {
                            $thumbKey = md5($thumbPath !== '' ? $thumbPath : $linkPath);
                            $thumbFile = $cacheDir . '/thumb_' . $thumbKey . '.webp';

                            // Write atomically
                            $tmpFile = $cacheDir . '/tmp_' . $thumbKey . '_' . getmypid();
                            if (@file_put_contents($tmpFile, $thumbData) !== false) {
                                @rename($tmpFile, $thumbFile);
                            } else {
                                @unlink($tmpFile);
                            }

                            // Include fallback_path so serve_survey_photo.php can self-heal
                            // if /tmp/ cache is cleared (reboot, tmpfs flush, etc.)
                            $fbPath = $thumbPath !== '' ? $thumbPath : $linkPath;
                            $thumbLink = $serveBase . '?key=' . $thumbKey . '&size=thumb'
                                . '&fallback_path=' . rawurlencode(urldecode($fbPath));
                        }
                    }

                    // Fallback: if no base64 thumb, use proxy URL for thumbnail
                    if ($thumbLink === '' && $thumbPath !== '') {
                        $thumbLink = $serveBase . '?path=' . rawurlencode(urldecode($thumbPath));
                    }
                    if ($thumbLink === '') {
                        $thumbLink = $serveBase . '?path=' . rawurlencode(urldecode($linkPath));
                    }

                    // link = mid-size (on-demand proxy + cache)
                    $link = $serveBase . '?path=' . rawurlencode(urldecode($linkPath));

                    // full_link = original (on-demand proxy + cache)
                    $fullPath = ($origPath !== '') ? $origPath : $linkPath;
                    $fullLink = $serveBase . '?path=' . rawurlencode(urldecode($fullPath));

                    $images[] = array(
                        "link" => $link,
                        "thumb_link" => $thumbLink,
                        "full_link" => $fullLink,
                        "job_id" => $jobId,
                        "job_type" => "SRV",
                        "job_date" => "",
                        "photo_type" => "Survey",
                        "source" => "local"
                    );
                }
            }
        }
    }
}

echo json_encode($images);
