# PHOTO-021: Photo System Resolution — Staging Direct, DB-Only Listing, API Fix

## Status: READY FOR TESTING

## Summary

Three photo system fixes addressing documented issues in PHOTO_SYSTEM_PROCESS_MAP.md §11-12:

### Fix 1: Scheduler Upload → Staging Direct
- **Problem:** Scheduler uploads go to `uploads/` first, then get copied to `staging/`. Each upload adds another JPEG to ~200GB of legacy waste.
- **Solution:** Upload directly to `uploads/staging/`. Removed redundant copy-to-staging step and CI resize (800x1027) — WebP generation from staging/ is the only derivative path now.
- **Files:** `phototab.php` (dropImageUpload), `preupload.php` (submit)

### Fix 2: Eliminate s3files (DB-Only Listing)
- **Problem:** `getimagelistingm.php` scans `/mnt/aeiserver/` filesystem instead of querying `meter_files` DB. Creates duplicates, misses mobile-uploaded photos.
- **Solution:** Set `$data['s3files'] = array()` in `photo_index()`. Removed s3files ZIP block from `download_all_photos()`. Removed s3files rendering block from view. Dead code (`getimagelisting()` method) left intact — harmless.
- **Files:** `phototab.php` (photo_index, download_all_photos), `photos_index.php` (view)

### Fix 3: getimagelisting.php full_link → hi-res/
- **Problem:** `full_link` points to `webp/` instead of `hi-res/` — inconsistent with other listing endpoints.
- **Solution:** Changed `full_link` path from `/webp/` to `/hi-res/`.
- **File:** `getimagelisting.php`

## Files Modified

| File | Location | Fixes |
|------|----------|-------|
| `phototab.php` | `controllers/` | Fix 1, Fix 2 |
| `preupload.php` | `controllers/` | Fix 1 |
| `photos_index.php` | `views/photo_tab/` | Fix 2 |
| `getimagelisting.php` | `photoapi/` | Fix 3 |

## Deployment

### Local (Scheduler)
Files are already in place at:
- `SCHEDULER/system/application/controllers/phototab.php`
- `SCHEDULER/system/application/controllers/preupload.php`
- `SCHEDULER/system/application/views/photo_tab/photos_index.php`

### Remote (Photo API)
Deploy `getimagelisting.php` to production `photoapi/` directory.

### Pre-deploy: Ensure staging/ directory exists
```bash
mkdir -p /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/staging
chmod 777 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/staging
```

## Verification Checklist

- [ ] `php -l` passes on all 4 files
- [ ] Login → Photos tab → drag-and-drop upload
- [ ] File appears in `uploads/staging/` (NOT `uploads/` root)
- [ ] WebP derivatives appear in `uploads/webp/` and `uploads/thumbs/`
- [ ] Photo renders in grid (WebP thumbnail) and lightbox (WebP standard)
- [ ] No duplicate s3files section visible
- [ ] Download All → ZIP contains WebP files
- [ ] Test preupload multi-file upload → same checks
- [ ] `getimagelisting.php` returns `full_link` with `/hi-res/`
- [ ] Monitor error log during testing
