# PHOTO-020: Photo Gallery UX Improvements

## Status: Deployed (2026-02-20)

## Problem
1. **Lightbox navigation limited:** Only 8 photos from the first date group rendered in DOM. Lightbox scans DOM for `<a data-lightbox>` elements, so users could only navigate 8 photos.
2. **Slow animations:** 500ms fade on open/close, 700ms animated resize between photos of different sizes.
3. **Oversized thumbnails:** 283x283px thumbnails in 3-column layout; actual generated thumbnails are 207x207px.

## Solution

### photos_index.php
- Removed `if($k==8){ break; }` — all photos per date group now render
- Removed outer `break;` — all date groups render, not just the first
- Removed "Show more results" button, hidden inputs, and AJAX pagination handler (dead code)
- Changed thumbnail grid from 3-column (283px) to 4-column (207px) with 15px bottom margin
- Added `object-fit: cover` CSS so all thumbnails fill containers uniformly
- Removed hardcoded `height="283" width="283"` from S3 photo `<img>` tags

### lightbox.js
- `fadeDuration`: 500ms → 0 (instant open/close)
- `resizeDuration`: 700ms → 0 (instant resize between photos)
- Replaced `.animate()` container resize with instant `.css()`
- Replaced all `.fadeIn()/.fadeOut()` calls with `.show()/.hide()`
- `fitImagesInViewport` still enabled — photos scale to fit screen
- Navigation chevrons preserved

## Files Changed
| File | Path |
|------|------|
| photos_index.php | `system/application/views/photo_tab/photos_index.php` |
| lightbox.js | `assets/new_phototab/js/lightbox.js` |

## Rollback
```bash
# photos_index.php
cd /var/www/html/AEI_REMOTE
scripts/aei_deploy.sh rollback system/application/views/photo_tab/photos_index.php

# lightbox.js
scripts/aei_deploy.sh rollback assets/new_phototab/js/lightbox.js
```
