# PHOTO-019: Local Photo Tracking Table

## Purpose

When photos sync from remote to local, metadata (job_id, customer_id, job_type, etc.) is used to find the right folder but then discarded. This enhancement adds a `local_photos` table to the local `Schedular` database that records every successful photo upload, providing a queryable record of what was synced and where it went.

## What Changed

### `uploadlocallat_kuldeep.php`

1. **Added `ensureLocalPhotosTable()`** — Creates the `local_photos` table if it doesn't exist (idempotent, runs once per request).
2. **Added `recordLocalPhoto()`** — Inserts a row after each successful `move_uploaded_file()`. Uses prepared statements. Silent failure (error_log only) — never blocks the upload.
3. **Call `ensureLocalPhotosTable()`** early in the script (after `require db_config.php`, before validation).
4. **Call `recordLocalPhoto()`** inside the success block after the existing `error_log()`.

## Table Schema

```sql
CREATE TABLE IF NOT EXISTS local_photos (
    id              INT AUTO_INCREMENT PRIMARY KEY,
    remote_job_id   INT,
    customer_id     INT,
    job_type        VARCHAR(10),
    job_date        DATE,
    photo_type      CHAR(1),
    filename        VARCHAR(255),
    folder_path     VARCHAR(500),
    file_size       INT UNSIGNED,
    lookup_method   VARCHAR(20),
    synced_at       DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_job_id (remote_job_id),
    INDEX idx_customer (customer_id),
    INDEX idx_date (job_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
```

Database: `Schedular` (via existing `getSchedularConnection()`)

## Files Modified

| File | Location | Change |
|------|----------|--------|
| `uploadlocallat_kuldeep.php` | `/var/www/html/upload/` (local server) | Added 2 functions + 2 call sites |

## Dependencies

- None. No remote server changes required.
- Uses existing `getSchedularConnection()` from `db_config.php`.

## Deployment

```bash
# 1. Backup current file on local server
cp /var/www/html/upload/uploadlocallat_kuldeep.php /var/www/html/upload/uploadlocallat_kuldeep.php.bak

# 2. Deploy new version
cp NEW/uploadlocallat_kuldeep.php /var/www/html/upload/uploadlocallat_kuldeep.php
```

## Rollback

```bash
cp /var/www/html/upload/uploadlocallat_kuldeep.php.bak /var/www/html/upload/uploadlocallat_kuldeep.php
```

Or restore from `ORIGINAL/uploadlocallat_kuldeep.php`.

## Verification

```bash
# Check table was created (auto-created on first upload, or verify manually)
mysql -u upload_user -p'P@55w02d778899' Schedular -e "DESCRIBE local_photos;"

# After a test upload, check for rows
mysql -u upload_user -p'P@55w02d778899' Schedular -e "SELECT * FROM local_photos ORDER BY id DESC LIMIT 5;"
```
