<?php
header('Content-Type: application/json');

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);

// Validate input
if (!isset($data['auth_token'], $data['file_name'], $data['image_data'],$data['job_id'])) {
    //http_response_code(400);
    echo json_encode(array("status" => "error", "message" => "Missing fields"));
    exit;
}


// Optional: Verify token
if ($data['auth_token'] !== 'aei@89806849') {
   // http_response_code(403);
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// Decode base64 image
$imageData = base64_decode($data['image_data']);
if ($imageData === false) {
   // http_response_code(400);
    echo json_encode(array("status" => "error", "message" => "Invalid base64"));
    exit;
}
$sdb=mysqli_connect("localhost","schedular","M1gif9!6","mandhdesign_schedular");
// Connect to database and get job/customer details
$query = "SELECT js.customer_id, cs.first_name, cs.last_name, js.job_date, jt.intials, js.job_pid
          FROM jobs js
          LEFT JOIN customers cs ON js.customer_id = cs.id
          LEFT JOIN job_types jt ON js.job_type_id = jt.id
          WHERE js.id = " . intval($data['job_id']);
$result = mysqli_query($sdb, $query);
$row = mysqli_fetch_assoc($result);
$customer_id = $row['customer_id'];
$job_date_t = $row['job_date'];
$job_date = date("m-d-Y", strtotime($row['job_date']));
$customer_name = $row['last_name'] . ", " . $row['first_name'];
$job_type_text = $row['intials'];
$first_name = $row['first_name'];
$last_name = $row['last_name'];

 if($job_type_text=="PM" || $job_type_text=="WM" || $job_type_text=="AS"   || $job_type_text=="RPM" || $job_type_text=="GCPM" ){
 $photo_type='S';
}else{
$photo_type='I';
}

// PHOTO-017: Save full-size JPEG to staging/ (temporary — synced to local, cleaned after 7d)
// Remote only stores WebP derivatives (webp/ + thumbs/). No JPEG in uploads/.
$filename_insert = basename($data['file_name']);
$uploadsBase = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads';
$stagingDir = $uploadsBase . '/staging';

// Ensure staging directory exists
if (!is_dir($stagingDir)) {
    @mkdir($stagingDir, 0777, true);
}

// PHOTO-018: uniqid prefix prevents concurrent overwrites when multiple
// field workers upload files with the same name (e.g. IMG_0001.jpg)
$stagingPath = $stagingDir . '/' . uniqid() . '_' . $filename_insert;

if (!file_put_contents($stagingPath, $imageData)) {
    echo json_encode(array("status" => "error", "message" => "Failed to save image"));
    exit;
}

// Validate saved file
$stagingPath = realpath($stagingPath);
if (!$stagingPath || !is_readable($stagingPath)) {
    echo json_encode(array("status" => "error", "message" => "Saved file not readable"));
    exit;
}

$job_id = $row['job_pid'];

// Generate WebP derivatives in background (PHOTO-017):
//   Source: staging/{filename} (full-size original, best quality for Pillow/LANCZOS)
//   → uploads/webp/{webpfilename}   = 1024px max WebP (Q80) — primary serving tier
//   → uploads/thumbs/{webpfilename} = 200x200 WebP (Q70) — grid thumbnails
//   → uploads/hi-res/{webpfilename} = 2048px max WebP (Q82) — future HD viewing
//   No JPEG written to uploads/ — remote is a derivatives-only store.
$customer_namewebp = $last_name . $first_name;
$randomId = substr(md5(uniqid(mt_rand(), true)), 0, 12);
$webpfilename = $customer_namewebp . "" . $job_type_text . "-" . $photo_type . $job_date . "_IMG" . $randomId . '.webp';

$thumbScript = __DIR__ . '/generate_thumbnails.py';
$thumbCmd = 'nohup /usr/local/bin/python3.6 ' . escapeshellarg($thumbScript)
     . ' ' . escapeshellarg($stagingPath)
     . ' ' . escapeshellarg($webpfilename)
     . ' ' . escapeshellarg($uploadsBase)
     . ' > /dev/null 2>&1 &';
exec($thumbCmd);

// Insert file record into database
// unique_filename stored for legacy compat; serving uses webpfilename → webp/thumbs/
$sql_insert = 'Insert into meter_files(job_id,unique_filename,original_filename,file_size,file_type,webpfilename,folder_path,created) values(' . intval($job_id) . ',"' . mysqli_real_escape_string($sdb, $filename_insert) . '","' . mysqli_real_escape_string($sdb, $filename_insert) . '","' . filesize($stagingPath) . '","99","' . mysqli_real_escape_string($sdb, $webpfilename) . '","", "' . date("Y-m-d, h:i:s") . '")';
mysqli_query($sdb, $sql_insert);

// Sync full-size original from staging/ to local server in background (non-blocking)
// Local server is the archival store for full-size originals.
$syncScript = __DIR__ . '/sync_to_local.py';
$syncCmd = 'nohup /usr/local/bin/python3.6 ' . escapeshellarg($syncScript)
    . ' ' . escapeshellarg($stagingPath)
    . ' ' . escapeshellarg(basename($stagingPath))
    . ' ' . escapeshellarg($job_id)
    . ' ' . escapeshellarg($customer_id)
    . ' ' . escapeshellarg($job_type_text)
    . ' ' . escapeshellarg($last_name)
    . ' ' . escapeshellarg($first_name)
    . ' ' . escapeshellarg($job_date_t)
    . ' ' . escapeshellarg($photo_type)
    . ' > /dev/null 2>&1 &';
exec($syncCmd);

// Send response to mobile app — this is the LAST thing before script ends
echo json_encode(array("success"=> 1,"status" => "ok", "message" => "Image uploaded", "path" => basename($stagingPath)));
?>
