# PHOTO-017: Derivatives-Only Remote Store + Staging

## Status: Deployed (2026-02-19)

## Problem
Phone cameras produce 3-5MB full-res JPEGs. The remote server doesn't need full-size originals — they waste ~204GB of disk. The scheduler's GD-based resize (800x1027, Q75) is lower quality than Pillow/LANCZOS and inconsistent with mobile. Both flows should produce identical WebP derivatives from the best available source.

## Solution
Remote becomes a **derivatives-only store** with 3 tiers of WebP derivatives. Full-size originals pass through `staging/` temporarily (synced to local for archival, cleaned after 7 days). No new JPEGs written to `uploads/` — only legacy CI resize for backward compat.

## 3-Tier Image Architecture

| Tier | Directory | Max Size | Quality | Use Case |
|------|-----------|----------|---------|----------|
| **Thumbnail** | `uploads/thumbs/` | 200x200 | Q70 | Grids, lists, mobile grid |
| **Standard** | `uploads/webp/` | 1024px max dim | Q80 | Lightbox, mobile detail, scheduler views |
| **Full-size** | `uploads/hi-res/` | 2048px max dim | Q82 | Downloads, print, HD viewing |

All three tiers share the same `webpfilename` from `meter_files`. The source for generation is always the highest quality available (staging/ = full-size original).

### Directory Layout
```
Remote (authoritative for viewing):
  uploads/thumbs/{webpfilename}.webp   (200x200, Q70 — grids, lists)
  uploads/webp/{webpfilename}.webp     (1024px max, Q80 — lightbox, mobile detail)
  uploads/hi-res/{webpfilename}.webp   (2048px max, Q82 — downloads, print, HD)

Remote legacy (kept temporarily):
  uploads/*.jpg                        (legacy scheduler originals, old photos)

Remote temporary:
  uploads/staging/*.jpg                (full-size, synced to local, cleaned after 7d)

Local archive:
  Full-size originals synced from staging/ (both mobile + scheduler)
```

### Serving Rules
| UI Context | Tier | Source |
|------------|------|--------|
| Grid / list | Thumbnail | `uploads/thumbs/{webpfilename}` |
| Lightbox / detail | Standard | `uploads/webp/{webpfilename}` |
| Mobile grid | Thumbnail | direct URL to `thumbs/` via `thumb_link` |
| Mobile detail | Standard | direct URL to `webp/` via `link` |
| Downloads, print, HD | Full-size | `uploads/hi-res/{webpfilename}` via `full_link` |
| Fallback (old records without webpfilename) | Legacy | `thumbnail()` helper + GD |

### API Response Fields
```json
{
  "thumb_link": "https://aeihawaii.com/scheduler/uploads/thumbs/{webpfilename}",
  "link":       "https://aeihawaii.com/scheduler/uploads/webp/{webpfilename}",
  "full_link":  "https://aeihawaii.com/scheduler/uploads/hi-res/{webpfilename}"
}
```

## Upload Flows

### Mobile (upload.php)
```
1. Decode base64 → save full-size JPEG to staging/{filename}
2. generate_thumbnails.py (nohup) reads staging/:
   Phase 1: → uploads/thumbs/{webpfilename} (200x200 Q70 thumbnail)
             → uploads/webp/{webpfilename}   (1024px Q80 standard)
   Phase 2: → uploads/hi-res/{webpfilename}  (2048px Q82 full-size)
3. DB INSERT meter_files (webpfilename → serving key)
4. sync_to_local.py (nohup): sends staging/{filename} to local (full-size archival)
5. Return JSON response immediately
6. staging/{filename} cleaned after 7 days by PHOTO-011
```
No JPEG written to `uploads/` root. Mobile photos exist on remote only as WebP derivatives.

### Scheduler (preupload.php, phototab.php)
```
1. CI uploads full-size JPEG to uploads/{encrypted_name}
2. Copy to staging/{encrypted_name} (preserves full-size before CI resize)
3. sync_to_local.py (nohup): sends staging/ copy to local (full-size archival)
4. generate_thumbnails.py (nohup) reads staging/ copy:
   Phase 1: → uploads/thumbs/{webpfilename} (200x200 Q70 thumbnail)
             → uploads/webp/{webpfilename}   (1024px Q80 standard)
   Phase 2: → uploads/hi-res/{webpfilename}  (2048px Q82 full-size)
5. CI image_lib->resize() overwrites uploads/ original to 800x1027 (legacy compat)
6. DB INSERT meter_files
7. staging/ cleaned after 7 days by PHOTO-011
```
Both sync and WebP generation use the staging copy (guaranteed full-size, pre-resize).
CI resize kept for legacy — nothing in the new UI reads from uploads/ root.

## Files Changed

| Action | File | Location on Server |
|--------|------|--------------------|
| Modified | `generate_thumbnails.py` | `photoapi/` — v4.0: 3-tier WebP derivatives, 1024px Q80, 3 args |
| Modified | `upload.php` | `photoapi/` — staging flow, no JPEG in uploads/ |
| Modified | `preupload.php` | `scheduler/controllers/` — copy to staging before CI resize |
| Modified | `phototab.php` | `scheduler/controllers/` — copy to staging before CI resize |
| Modified | `backfill_thumbnails.py` | `photoapi/` — v2.0: 3-tier backfill (1024px Q80) |
| Modified | `process_retry_queue.py` | `photoapi/` — staging cleanup (7d) |
| Modified | `photos_index.php` | `scheduler/views/photo_tab/` — WebP-aware initial grid |
| Rewritten | `getimagelistingnew.php` | `photoapi/` — DB-based (meter_files), returns thumb_link |
| Modified | `loginapinew.php` | `photoappsch/controllers/` — thumbUrl in customerphotostabstatenew |
| Unchanged | `fetch_image1.php` | `photoapi/` — existing routing works |
| Unchanged | `getimagelisting1.php` | `photoapi/` — already returns thumb_link+full_link |
| Unchanged | `thumbnail_helper.php` | `scheduler/helpers/` — fallback for old records |

## Changes Summary

### generate_thumbnails.py (v4.0 — 3-tier derivatives)
- **3 tiers** generated from single source in priority order:
  - Phase 1 (priority): Thumbnail 200x200 Q70 + Standard 1024px Q80 — needed for immediate viewing
  - Phase 2 (deferred): Full-size 2048px Q82 — generated after phase 1 within same nohup process
- 3 args unchanged: `<source_image> <webpfilename> <uploads_dir>`
- Creates `hi-res/` directory alongside `webp/` and `thumbs/`
- Source is always the best quality available (staging/ = full-size)

### upload.php (mobile — staging, no JPEG)
- Saves base64 to `staging/{filename}` (was `uploads/`)
- Generates WebP from staging/ (full-size source = high quality)
- **No file written to `uploads/` root** — remote is derivatives-only for mobile
- Sync sends full-size from staging/ to local (archival)

### preupload.php + phototab.php (scheduler — staging before resize)
- **New:** Copies full-size to `staging/` immediately after CI upload, before resize
- Sync from staging/ (guaranteed full-size, eliminates race condition)
- WebP generated from staging/ (Pillow/LANCZOS from full-size = consistent quality)
- CI `image_lib->resize()` still runs for legacy compat (800x1027 in uploads/)
- Both controllers follow identical pattern

### photos_index.php (scheduler view — WebP-aware initial grid)
- Initial page load now checks `webpfilename` + `is_file()` for both thumb and standard
- If `thumbs/{webpfilename}` exists → serve static WebP thumbnail (no GD)
- If `webp/{webpfilename}` exists → serve static WebP standard for lightbox
- Fallback: `thumbnail()` helper for old records without WebP derivatives
- Matches the logic already in `showmore()` (AJAX "load more" path)
- Once backfill completes, all photos serve as WebP — GD never called

### backfill_thumbnails.py (v2.0 — 3-tier)
- Generates all 3 tiers: Thumbnail (200x200 Q70), Standard (1024px Q80), Full-size (2048px Q82)
- Verify pass checks `thumbs/`, `webp/`, and `hi-res/` existence
- Creates `hi-res/` directory alongside existing output directories

### process_retry_queue.py
- `cleanup_staging()` deletes staging files > 7 days (aligned with retry window)
- Called during daily reconciliation pass

## GD Phaseout Path

1. **Now:** Backfill ensures every meter_files record has webpfilename + all 3 tiers
2. **After backfill:** Scheduler UI uses WebP exclusively (webpfilename present → webp/thumbs/)
3. **Fallback only:** Records without webpfilename use `thumbnail()` helper + GD (rare, old)
4. **Eventually:** Remove `thumbnail()` usage from photo views. GD becomes dead code.
5. **Future:** Delete legacy JPEGs from `uploads/` root (~204GB recovery)

## Dependencies
- PHOTO-009 (Unified Storage) — deployed
- PHOTO-011 (Reconciliation) — deployed (provides daily cron hook for staging cleanup)
- PHOTO-016 (Survey Photos in Mobile) — deployed

## Pre-deployment
```bash
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90
sudo mkdir -p /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/staging
sudo mkdir -p /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/thumbs
sudo mkdir -p /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/hi-res
sudo chmod 777 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/staging
sudo chmod 777 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/thumbs
sudo chmod 777 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/hi-res
sudo chmod 777 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp
```

## Deploy files
SCP all NEW/ files to /tmp/ on remote, then copy to destinations:
- `generate_thumbnails.py` → `photoapi/`
- `upload.php` → `photoapi/`
- `backfill_thumbnails.py` → `photoapi/`
- `process_retry_queue.py` → `photoapi/`
- `preupload.php` → `scheduler/system/application/controllers/`
- `phototab.php` → `scheduler/system/application/controllers/`
- `photos_index.php` → `scheduler/system/application/views/photo_tab/`

Then: `sudo chown ec2-user:ec2-user` on all, `sudo chmod 755` on Python scripts.

## Verification
1. **Mobile upload** → staging/ has full-size, thumbs/ has 200x200, webp/ has 1024px, hi-res/ has 2048px, uploads/ root has NO new JPEG
2. **Scheduler upload** → staging/ has full-size copy, all 3 tiers generated, uploads/ has CI-resized legacy JPEG
3. **File sizes** → thumbnail < standard (webp/) < full-size (hi-res/) — confirm ordering
4. **Sync** → local receives full-size from staging/ (both flows)
5. **Staging cleanup** → files > 7 days deleted by daily reconciliation
6. **API: getimagelisting1.php** → `thumb_link` → thumbs/, `link` → webp/, `full_link` → hi-res/
7. **API: getimagelistingnew.php** → same 3 fields present
8. **Scheduler lightbox** → loads from webp/ (1024px Q80 standard)
9. **Backfill** → `--limit 10 --verify` confirms all 3 tiers exist

## Mobile App Integration (2026-02-19)

The API returns `thumb_link`, `link`, and `full_link` fields mapping to the 3 tiers. The Flutter app was updated to use each tier appropriately.

### Server-Side Changes

| Action | File | Change |
|--------|------|--------|
| Rewritten | `getimagelistingnew.php` | DB-based (meter_files) instead of /mnt/aeiserver/ filesystem; returns `thumb_link` |
| Modified | `loginapinew.php` | `customerphotostabstatenew()` now passes `thumbUrl` in response JSON |

### Flutter App Changes (PR #1)

| File | Change |
|------|--------|
| `lib/models/photo_item.dart` | Added `thumbUrl` and `fullUrl` fields |
| `lib/pages/job_photos_full_view.dart` | Grid uses thumbnail tier; gallery uses full-size tier; error handling with tap-to-retry |
| `lib/pages/full_screen_gallery.dart` | Error state display for failed image loads |
| `lib/pages/customer_photos_tab.dart` | Parses `thumbUrl` from API; 60x60 preview uses thumbnail |
| `lib/pages/job_details_page.dart` | Parses `thumb_link` for grid; full-screen uses standard |

### Backward Compatibility
- All thumbnail URL fields fall back to standard `link`/`url` when absent
- Survey photos (no `thumb_link`) gracefully use standard tier
- Legacy `loginapi/getimagelisting` endpoint falls back to standard

## Rollback
Restore all files from `ORIGINAL/` directory. Remove `staging/` directory contents.

## Estimates
- Staging disk: ~500MB peak (7 days of uploads x ~3MB each)
- Backfill: ~6 hours with 4 workers for 196K existing photos
- Storage: ~15GB for all 3 tiers (637GB free)
- Future savings: ~204GB when legacy JPEGs removed from uploads/
