<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
/**
 * CodeIgniter
 *
 * An open source application development framework for PHP 5.1.6 or newer
 *
 * @package		CodeIgniter
 * @author		ExpressionEngine Dev Team
 * @copyright	Copyright (c) 2008 - 2011, EllisLab, Inc.
 * @license		http://codeigniter.com/user_guide/license.html
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
// ------------------------------------------------------------------------

/**
 * CodeIgniter Download Helpers
 *
 * @package		CodeIgniter
 * @subpackage	Helpers
 * @category	Helpers
 * @author		ExpressionEngine Dev Team
 * @link		http://codeigniter.com/user_guide/helpers/download_helper.html
 */
// ------------------------------------------------------------------------

/**
 * Force Download
 *
 * Generates headers that force a download to happen
 *
 * @access	public
 * @param	string	filename
 * @param	mixed	the data to be downloaded
 * @return	void
 */
if (!function_exists('thumbnail')) {
    function thumbnail($src, $width, $height, $option='crop', $grayscale=false) {
        require_once APPPATH.'third_party/Resize.php';

        $config = array();
        // Load the configuration
        if (defined('ENVIRONMENT') AND is_file(APPPATH . 'config/' . ENVIRONMENT . '/thumbnail.php')) {
            include(APPPATH . 'config/' . ENVIRONMENT . '/thumbnail.php');
        } elseif (is_file(APPPATH . 'config/thumbnail.php')) {
            include(APPPATH . 'config/thumbnail.php');
        }
        $i = array(
            'src' => $src,
            'config' => $config
        );
        //Clean path src
        if($src[0] == '/') $src = substr ($src, 1);
        $src = str_replace('\\', '/', $src);
        $i['src_clean'] = $src;


        $i['base_folder'] = isset($config['thumbnail_base_folder']) ? $config['thumbnail_base_folder'] : './';

        $i['src_image'] = $i['base_folder'] . $src;

        if(!file_exists($i['src_image'])) {
            
            return '<!-- File '.$i['src_image'].' does not exists -->';
        }

        $old_pinfo = pathinfo($src);
        $pinfo = pathinfo($i['src_image']);

        $i['new_name'] = $pinfo['filename'].'_'.$option[0].$width.'x'.$height.'.'.$pinfo['extension'];
        switch ($config['thumbnail_cache_type']) {
            default:
            case 'same_path':
                $i['url'] = $config['thumbnail_base_url'].$old_pinfo['dirname'].'/'.$i['new_name'];
                $i['dest_image'] = $pinfo['dirname'].'/'.$i['new_name'];
                break;
            case 'subfolder':
                $i['url'] = $config['thumbnail_base_url'].'/'.$config['thumbnail_subfolder_name'].'/'.$i['new_name'];
                $i['dest_image'] = $pinfo['dirname'].'/'.$config['thumbnail_subfolder_name'].'/'.$i['new_name'];
                break;
            case 'folder_md5':
                $i['new_name'] = md5($src).'.'.$pinfo['extension'];
            case 'folder':
                $i['url'] = $config['thumbnail_cache_url'].$i['new_name'];
                $i['dest_image'] = $config['thumbnail_cache_folder'].$i['new_name'];
                break;
        }
        //Save file if it does not allready exists
        if(@filemtime($i['dest_image']) < @filemtime($i['src_image']) || @$config['thumbnail_disable_caching']) {

            //Check target directory to see if it exists and is writable
            $i['target_directory'] = dirname($i['dest_image']);
            if(!is_dir($i['target_directory'])) {
                @mkdir($i['target_directory'], DIR_WRITE_MODE);
            }
            if(!is_writable($i['target_directory'])) {
                chmod($i['target_directory'], DIR_WRITE_MODE);
            }
            
            //Resize and save image
            $image = new Resize($i['src_image']);
            if(!$image->resizeImage($width, $height, $option)) {
                log_message('error', 'Thumbnail: Wrong option: '.$option);
                return false;
            }
            if($grayscale) {
                $image->setGrayscale();
            }
            if(!$image->saveImage($i['dest_image'])) {
                log_message('error', "Thumbnail: Unable to write file ({$i['dest_image']})");
                return false;
            }
        }
        return $i['url'];
    }

}


/* End of file download_helper.php */
/* Location: ./system/helpers/download_helper.php */