<?php
header('Content-Type: application/json');

// === CONFIGURATION ===
// Change this to your real public image base URL:
$publicBaseUrl = 'https://aeihawaii.com/photoapi/fetch_image.php?job_id='; // e.g., symlink /mnt/aeiserver to /var/www/html/uploads

// === STEP 1: Get and Validate JSON Input ===
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token'], $data['job_id'])) {
    //http_response_code(400);
    echo json_encode(array("status" => "error", "message" => "Missing auth_token or job_id"));
    exit;
}

if ($data['auth_token'] !== 'aei@89806849') {
  //  http_response_code(403);
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// === STEP 2: Sanitize and Locate Folder ===
$jobId = preg_replace('/[^A-Za-z0-9_\-]/', '', $data['job_id']);
$uploadDir = '/mnt/aeiserver/' . $jobId . '/';

if (!is_dir($uploadDir)) {
   // http_response_code(404);
    echo json_encode(array("status" => "error", "message" => "Job folder not found"));
    exit;
}

// === STEP 3: Get All Valid Image Files ===
$imageFiles = array_values(array_filter(scandir($uploadDir), function($file) use ($uploadDir) {
    $fullPath = $uploadDir . $file;
    return is_file($fullPath) && preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $file);
}));

// === STEP 4: Prepare Response Data ===
$images = array();
foreach ($imageFiles as $img) {
    $fullPath = $uploadDir . $img;
    $images= array(
        "link" => $publicBaseUrl . $jobId . '&img=' . rawurlencode($img),
		'created'  => date("Y-m-d H:i:s", filectime($fullPath)),
		"status" => "ok"
    );
	break;
}
// === STEP 5: Send Response ===
echo json_encode($images);
