<?php
header('Content-Type: application/json');

// === CONFIGURATION ===
$publicBaseUrl = 'https://aeihawaii.com/photoapi/fetch_image.php?job_id=';

// === STEP 1: Get and Validate JSON Input ===
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token'], $data['job_id'])) {
    echo json_encode(array("status" => "error", "message" => "Missing auth_token or job_id"));
    exit;
}

if ($data['auth_token'] !== 'aei@89806849') {
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// === STEP 2: Get Requested Job and Customer ID ===
$jobId = intval($data['job_id']);
$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

$query = "SELECT js.customer_id, js.job_pid, cs.first_name, cs.last_name, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN customers cs ON js.customer_id = cs.id
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.id = " . $jobId;
$result = mysqli_query($sdb, $query);
$row = mysqli_fetch_assoc($result);

if (!$row) {
    echo json_encode(array("status" => "error", "message" => "Job not found"));
    exit;
}

$customerId = intval($row['customer_id']);

// === STEP 3: Query ALL Jobs for This Customer ===
$query2 = "SELECT js.id, js.job_pid, cs.first_name, cs.last_name, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN customers cs ON js.customer_id = cs.id
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.customer_id = " . $customerId . "
    ORDER BY js.job_date DESC";
$result2 = mysqli_query($sdb, $query2);

// Collect job info: map job_pid -> job data
$jobsByPid = array();
while ($jobRow = mysqli_fetch_assoc($result2)) {
    $pid = intval($jobRow['job_pid']);
    $jobsByPid[$pid] = $jobRow;
}

// === STEP 4: Query meter_files for all customer's job_pids (DB-only) ===
$images = array();
$allPids = array_keys($jobsByPid);

if (!empty($allPids)) {
    $pidList = implode(',', $allPids);
    $mfQuery = "SELECT mf.webpfilename, mf.job_id, mf.unique_filename, mf.created
        FROM meter_files mf
        WHERE mf.job_id IN (" . $pidList . ")
        AND mf.file_type = 99
        AND mf.webpfilename IS NOT NULL
        AND mf.webpfilename != ''
        ORDER BY mf.created DESC";
    $mfResult = mysqli_query($sdb, $mfQuery);

    if ($mfResult) {
        while ($mfRow = mysqli_fetch_assoc($mfResult)) {
            $pid = intval($mfRow['job_id']);

            // Look up the job row for this pid to get job metadata
            $jobRow = isset($jobsByPid[$pid]) ? $jobsByPid[$pid] : null;
            $jt = '';
            $job_date = '';
            $photo_type = '';

            if ($jobRow) {
                $jt = $jobRow['intials'];
                $job_date = date("m-d-Y", strtotime($jobRow['job_date']));

                if ($jt == "PM" || $jt == "WM" || $jt == "AS" || $jt == "RPM" || $jt == "GCPM") {
                    $photo_type = 'Survey';
                } else {
                    $photo_type = 'Installation';
                }
            }

            // Find the corresponding jobs.id for this job_pid
            $relatedJobId = $jobRow ? intval($jobRow['id']) : $pid;

            $images[] = array(
                "link" => $publicBaseUrl . $relatedJobId . '&img=' . rawurlencode($mfRow['webpfilename']),
                "job_id" => $relatedJobId,
                "job_type" => $jt,
                "job_date" => $job_date,
                "photo_type" => $photo_type
            );
        }
    }
}

// === STEP 5: Legacy /mnt/aeiserver/ Scan (Backward Compatibility) ===
// Out of scope for PHOTO-009 — kept for legacy photos not in meter_files
$legacyDir = '/mnt/aeiserver/' . $jobId . '/';

if (is_dir($legacyDir)) {
    $legacyFiles = @scandir($legacyDir);
    if ($legacyFiles) {
        $legacyFiles = array_values(array_filter($legacyFiles, function($file) use ($legacyDir) {
            $fullPath = $legacyDir . $file;
            return is_file($fullPath) && preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $file);
        }));

        foreach ($legacyFiles as $img) {
            $images[] = array(
                "link" => $publicBaseUrl . $jobId . '&img=' . rawurlencode($img),
                "job_id" => $jobId,
                "job_type" => "",
                "job_date" => "",
                "photo_type" => "Legacy"
            );
        }
    }
}

// === STEP 6: Send Response ===
echo json_encode($images);
