<?php
// PHOTO-017: Image serving endpoint with size routing
// 302 redirect to static file for performance.
// Layout:
//   thumb → uploads/thumbs/  (200x200 WebP)
//   full  → uploads/webp/    (1024px WebP — default/primary)

// Allow only GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo "Method Not Allowed";
    exit;
}

// Sanitize and validate input
$jobId = isset($_GET['job_id']) ? intval($_GET['job_id']) : 0;
$fileName = isset($_GET['img']) ? basename($_GET['img']) : '';

if (!$jobId || !$fileName) {
    echo "Missing job_id or file parameter";
    exit;
}

// Size parameter: thumb or full (default)
$size = isset($_GET['size']) ? $_GET['size'] : 'full';
$uploadsBase = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads';

// Determine file path and static URL subdir
if ($size === 'thumb') {
    $filePath = $uploadsBase . '/thumbs/' . $fileName;
    $subdir = 'thumbs';
    // Fallback to large WebP if thumb not yet generated
    if (!file_exists($filePath) || !is_file($filePath)) {
        $filePath = $uploadsBase . '/webp/' . $fileName;
        $subdir = 'webp';
    }
} else {
    // Default: large WebP (1024px) — backwards compatible
    $filePath = $uploadsBase . '/webp/' . $fileName;
    $subdir = 'webp';
}

if (!file_exists($filePath) || !is_file($filePath)) {
    echo "File not found";
    exit;
}

// 302 redirect to static file — lets Apache serve it directly (fast, cacheable)
$staticUrl = '/scheduler/uploads/' . $subdir . '/' . rawurlencode($fileName);
header('Location: ' . $staticUrl, true, 302);
header('Cache-Control: public, max-age=86400');
exit;
?>
