<?php
header('Content-Type: application/json');

// === CONFIGURATION ===
// PHOTO-017: Direct static URLs for performance (no PHP streaming)
$staticBase = 'https://aeihawaii.com/scheduler/uploads';
// Legacy fetch endpoint kept for backwards compatibility
$fetchBaseUrl = 'https://aeihawaii.com/photoapi/fetch_image1.php?job_id=';

// === STEP 1: Get and Validate JSON Input ===
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token'], $data['job_id'])) {
    echo json_encode(array("status" => "error", "message" => "Missing auth_token or job_id"));
    exit;
}

if ($data['auth_token'] !== 'aei@89806849') {
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// === STEP 2: Get Requested Job and Customer ID ===
$jobId = intval($data['job_id']);
$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

if (!$sdb) {
    echo json_encode(array("status" => "error", "message" => "Database connection failed"));
    exit;
}

$query = "SELECT js.customer_id, js.job_pid, cs.first_name, cs.last_name, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN customers cs ON js.customer_id = cs.id
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.id = " . $jobId;
$result = mysqli_query($sdb, $query);

if (!$result) {
    echo json_encode(array("status" => "error", "message" => "Query failed"));
    exit;
}

$row = mysqli_fetch_assoc($result);

if (!$row) {
    echo json_encode(array("status" => "error", "message" => "Job not found"));
    exit;
}

$customerId = intval($row['customer_id']);

// === STEP 3: Query ALL Jobs for This Customer (to get job_pids) ===
$query2 = "SELECT js.id, js.job_pid, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.customer_id = " . $customerId . "
    ORDER BY js.job_date DESC";
$result2 = mysqli_query($sdb, $query2);

if (!$result2) {
    echo json_encode(array("status" => "error", "message" => "Jobs query failed"));
    exit;
}

// Collect job info: map job_pid -> job data (same approach as getimagelisting.php)
$jobsByPid = array();
while ($jobRow = mysqli_fetch_assoc($result2)) {
    $pid = intval($jobRow['job_pid']);
    $jobsByPid[$pid] = $jobRow;
}

$images = array();

// === STEP 4: Query meter_files directly (no JOIN to avoid cross-join duplicates) ===
$allPids = array_keys($jobsByPid);

if (!empty($allPids)) {
    $pidList = implode(',', $allPids);
    $mfQuery = "SELECT mf.webpfilename, mf.job_id, mf.unique_filename, mf.created
        FROM meter_files mf
        WHERE mf.job_id IN (" . $pidList . ")
        AND mf.file_type = 99
        AND mf.webpfilename IS NOT NULL
        AND mf.webpfilename != ''
        ORDER BY mf.created DESC";
    $mfResult = mysqli_query($sdb, $mfQuery);
    if ($mfResult) {
        while ($mfRow = mysqli_fetch_assoc($mfResult)) {
            $pid = intval($mfRow['job_id']);
            $img = $mfRow['webpfilename'];

            // Look up the job row for this pid to get job metadata
            $jobRow = isset($jobsByPid[$pid]) ? $jobsByPid[$pid] : null;
            $jt = '';
            $job_date = '';
            $photo_type = '';

            if ($jobRow) {
                $jt = $jobRow['intials'];
                $job_date = date("m-d-Y", strtotime($jobRow['job_date']));

                if ($jt == "PM" || $jt == "WM" || $jt == "AS" || $jt == "RPM" || $jt == "GCPM") {
                    $photo_type = 'Survey';
                } else {
                    $photo_type = 'Installation';
                }
            }

            // Find the corresponding jobs.id for this job_pid
            $relatedJobId = $jobRow ? intval($jobRow['id']) : $pid;

            // PHOTO-017: Direct static URLs — served by Apache, no PHP overhead
            $encodedImg = rawurlencode($img);
            $images[] = array(
                "link" => $staticBase . '/webp/' . $encodedImg,
                "thumb_link" => $staticBase . '/thumbs/' . $encodedImg,
                "full_link" => $staticBase . '/webp/' . $encodedImg,
                "job_id" => $relatedJobId,
                "job_type" => $jt,
                "job_date" => $job_date,
                "photo_type" => $photo_type
            );
        }
    }
}

echo json_encode($images);
