# PHOTO-014: Login API Bug Fixes

**Status:** Deployed
**Date:** 2026-02-18
**Priority:** HIGH
**Risk:** Low
**Effort:** Small
**Depends On:** None (independent)

---

## Architecture Discovery

During deployment, we discovered that `loginapi.php` exists in **two separate CodeIgniter apps**:

| App | Path | Version |
|-----|------|---------|
| `scheduler/` | `scheduler/system/application/controllers/loginapi.php` | Simpler (333 lines) — fewer endpoints, S3-based getimagelisting, hardcoded token validation |
| `photoappsch/` | `photoappsch/system/application/controllers/loginapi.php` | Larger (584 lines) — more endpoints, cURL-based getimagelisting, DB token validation |

Additionally, `photoappsch/loginapinew.php` contains the same bugs as `photoappsch/loginapi.php` (the mobile app primarily uses `loginapinew`).

---

## Bugs Fixed

### In `scheduler/loginapi.php` (2 fixes):

| Line | Bug | Fix |
|------|-----|-----|
| 155 | `time($job['job_date'])` returns current timestamp | `strtotime($job['job_date'])` |
| 124 | `$data` not initialized before foreach | Added `$data = array();` |

### In `photoappsch/loginapi.php` (5 fixes):

| Line | Bug | Fix |
|------|-----|-----|
| 177 | `$endDate = $getdate` overwrites +2 days calculation | Removed line |
| 235 | `$data` not initialized in `getjmyjobtoday()` | Added `$data = array();` |
| 268 | `time($job['job_date'])` returns current timestamp | `strtotime($job['job_date'])` |
| 298 | `time($job['last_name'])` useless call (overwritten on 299) | Removed line |
| 190-192 | Date params unescaped in SQL | `$this->db->escape_str()` |

### In `photoappsch/loginapinew.php` (3 fixes via sed):

| Line | Bug | Fix |
|------|-----|-----|
| 155 | `$endDate = $getdate` overwrites +2 days in `getmysearchjob()` | Blanked line |
| 216 | `$endDate = $getdate` overwrites +12 days in `getmysearchjobtech()` | Blanked line |
| 346 | `time($job['job_date'])` in `getjmyjobdetails()` | `strtotime($job['job_date'])` |

---

## Files in This Enhancement

### ORIGINAL/
- `loginapi.php` — pre-fix `photoappsch/` version (584 lines)
- `loginapi_scheduler.php` — pre-fix `scheduler/` version (333 lines)

### NEW/
- `loginapi.php` — fixed `photoappsch/` version
- `loginapi_scheduler.php` — fixed `scheduler/` version
- `loginapinew.php` — fixed via in-place sed (backup at `.bak.pre_enh014.20260218`)

---

## Deployment (Completed 2026-02-18)

All three files deployed with backups:
- `scheduler/.../loginapi.php.bak.pre_enh014.20260218`
- `photoappsch/.../loginapi.php.bak.pre_enh014.20260218`
- `photoappsch/.../loginapinew.php.bak.pre_enh014.20260218`

## Rollback

```bash
# scheduler/loginapi.php
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapi.php.bak.pre_enh014.20260218 \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapi.php"

# photoappsch/loginapi.php
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapi.php.bak.pre_enh014.20260218 \
      /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapi.php"

# photoappsch/loginapinew.php
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php.bak.pre_enh014.20260218 \
      /var/www/vhosts/aeihawaii.com/httpdocs/photoappsch/system/application/controllers/loginapinew.php"
```
