# PHOTO-013: Security Hardening

**Status:** Proposed
**Date:** 2026-02-18
**Priority:** HIGH
**Risk:** Medium
**Effort:** Medium
**Depends On:** None (independent)

---

## Problems Addressed

### C2: AWS S3 Credentials in Commented-Out Code (loginapi.php)
Lines 423-428 contain hardcoded AWS access key and secret key in a commented-out function. Even though commented out, the credentials are visible in the source file.

### H8: `display_errors=1` in Production (loginapinew.php)
Lines 11-12 enable PHP error display, leaking file paths, query details, and internal structure to end users.

### H9: Token Values in Error Messages (loginapi.php + loginapinew.php)
Multiple error responses append the actual token value: `'Invalid or expired token.'.$token`. An attacker can harvest tokens from error responses.

### M1: CORS Header Conflicts (loginapi.php + loginapinew.php)
Multiple `Access-Control-Allow-Origin` headers sent (yislms.com, localhost:3000, localhost:58651, then `*`). Only the last wins. Development origins are artifacts.

### M8: Orphaned S3 Cache Functions (loginapi.php)
`getCachedUrl()`, `cacheUrl()`, `isExpired()` (lines 480-526) were only used by the deleted S3 code.

---

## Files Modified

### 1. `loginapi.php` (photoappsch controller)

Full fixed file in `NEW/loginapi.php`. Changes:

| Original Lines | Change |
|----------------|--------|
| 1-3 | Removed `require aws.phar` and `use Aws\S3\S3Client` (S3 no longer used) |
| 9-13, 21 | Replaced 4 CORS origin headers with single `Access-Control-Allow-Origin: *` |
| 113-114 | Changed status `4011` → `401`, removed `.$token` from error message |
| 145-146 | Changed status `4011` → `401`, removed `.$token` from error message |
| 182-183 | Changed status `4011` → `401`, removed `.$token` from error message |
| 399-478 | **DELETED** entire commented-out S3 `getimagelisting()` block with credentials |
| 480-526 | **DELETED** orphaned `getCachedUrl()`, `cacheUrl()`, `isExpired()` functions |

### 2. `loginapinew.php` (photoappsch controller)

**Apply these changes manually** (file too large for full copy):

| Line(s) | Original | Fixed |
|---------|----------|-------|
| 9 | `header("Access-Control-Allow-Origin:https://yislms.com");` | **DELETE** |
| 11-12 | `error_reporting(1);` / `ini_set("display_errors",1);` | `error_reporting(0);` / `ini_set("display_errors",0);` |
| 13-14 | localhost CORS headers | **DELETE** |
| Token errors | `'message' => 'Invalid or expired token.'.$token` | `'message' => 'Invalid or expired token.'` |

Search for `.$token` in loginapinew.php and remove all instances from error messages.

### 3. `fetch_image1.php` (photoapi)

**No changes needed** — current deployed version already has `basename()` on line 10. Auth token check deferred to ENH-F02 (API Unification) to avoid breaking mobile app without a coordinated Flutter update.

---

## Deployment

```bash
# === loginapi.php ===
# 1. Backup
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapi.php \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapi.php.bak.pre_enh013.$(date +%Y%m%d)"

# 2. Upload
scp -i /root/.ssh/aei_remote.pem \
  NEW/loginapi.php \
  Julian@18.225.0.90:/tmp/loginapi.php

# 3. Move + chown
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /tmp/loginapi.php /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapi.php && \
   sudo chown ec2-user:ec2-user /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapi.php"

# === loginapinew.php (manual edit or sed) ===
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapinew.php \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/loginapinew.php.bak.pre_enh013.$(date +%Y%m%d)"
# Then apply the line changes listed above
```

## Rollback

Restore from `.bak.pre_enh013.*` backups or from `ORIGINAL/` directory.

## Note: Overlap with PHOTO-014

Both PHOTO-013 and PHOTO-014 modify `loginapi.php`. PHOTO-013 addresses **security** issues (credentials, token leak, CORS, display_errors). PHOTO-014 addresses **bug** fixes (time(), $endDate, $data init). When deploying both, apply PHOTO-014's bug fixes on top of PHOTO-013's security-hardened version.
