<?php
// Allow only GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo "Method Not Allowed";
    exit;
}

// Sanitize and validate input
$jobId = isset($_GET['job_id']) ? intval($_GET['job_id']) : 0;
$fileName = isset($_GET['img']) ? basename($_GET['img']) : '';

if (!$jobId || !$fileName) {
    echo "Missing job_id or file parameter";
    exit;
}

 $filePath="/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp/".$fileName;
if (!file_exists($filePath) || !is_file($filePath)) {
    echo "File not found";
    exit;
}

// Get MIME type based on file extension
$ext = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
$mimeTypes = array(
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'png' => 'image/png',
    'gif' => 'image/gif',
    'webp' => 'image/webp'
);

$contentType = isset($mimeTypes[$ext]) ? $mimeTypes[$ext] : 'application/octet-stream';

header("Content-Type: $contentType");
header("Content-Length: " . filesize($filePath));

readfile($filePath);
exit;
?>
