# PHOTO-012: Mobile Photo Listing Metadata Fix

**Status:** Proposed
**Date:** 2026-02-18
**Priority:** HIGH
**Risk:** Low
**Effort:** Small
**Depends On:** PHOTO-009 (Unified Storage)

---

## Problem

`getimagelisting1.php` (used by the mobile app via `loginapinew.php`) has a critical bug at lines 115-117: it references `$info['job_type']`, `$info['job_date']`, and `$info['photo_type']` — but `$info` is never populated. The `getJobPhotoInfo()` helper exists but is only called in the commented-out code block.

**Result:** Every mobile photo listing returns `null` for job_type, job_date, and photo_type.

This was discovered during the post-PHOTO-009 audit. PHOTO-009 rewrote the base `getimagelisting.php` to use DB-only queries, but the mobile app uses the "1" variant which was not updated.

## Fix

Instead of calling `getJobPhotoInfo()` per row (which reconstructs filesystem paths), JOIN the metadata directly into the SQL query:

```sql
SELECT mf.webpfilename, mf.job_id, js.job_date, jt.intials
FROM meter_files mf
LEFT JOIN jobs js ON mf.job_id = js.job_pid
LEFT JOIN job_types jt ON js.job_type_id = jt.id
WHERE mf.job_id IN (...) AND mf.webpfilename IS NOT NULL
```

Then derive `photo_type` from `jt.intials` using the same PM/WM/AS/RPM/GCPM = Survey logic.

### Additional fixes in this enhancement:
- **DB connection error handling** — check `mysqli_connect()` return value
- **NULL checks after queries** — handle failed `mysqli_query()` gracefully
- **Removed 90 lines of dead commented-out code** (lines 124-214)
- **Removed unused helper functions** (`getJobPhotoInfo`, `scanWebpDir`) and dead variables (`$scannedDirs`, `$folderPathsByPid`, `$jobsByPid`)

## Files Modified

| File | Location | Change |
|------|----------|--------|
| `getimagelisting1.php` | `photoapi/` | Fixed SQL with JOINs, removed dead code |

## Deployment

```bash
# 1. Backup current file on remote
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "cp /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting1.php \
      /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting1.php.bak.pre_enh012.$(date +%Y%m%d)"

# 2. Upload new file
scp -i /root/.ssh/aei_remote.pem \
  NEW/getimagelisting1.php \
  Julian@18.225.0.90:/tmp/getimagelisting1.php

# 3. Move into place
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /tmp/getimagelisting1.php /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting1.php && \
   sudo chown ec2-user:ec2-user /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting1.php"

# 4. Verify
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "ls -la /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting1.php"
```

## Rollback

```bash
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 \
  "sudo cp /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting1.php.bak.pre_enh012.* \
      /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting1.php"
```

Or restore from `ORIGINAL/getimagelisting1.php`.

## Testing

1. Call the mobile photo listing endpoint with a known job_id
2. Verify `job_type`, `job_date`, and `photo_type` are populated (not null)
3. Verify Survey jobs return `photo_type: "Survey"` and Installation jobs return `photo_type: "Installation"`
4. Verify the response matches `getimagelisting.php` (PHOTO-009 version) for the same job
