<?php
header('Content-Type: application/json');

// === CONFIGURATION ===
$publicBaseUrl = 'https://aeihawaii.com/photoapi/fetch_image1.php?job_id=';

// === STEP 1: Get and Validate JSON Input ===
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token'], $data['job_id'])) {
    echo json_encode(array("status" => "error", "message" => "Missing auth_token or job_id"));
    exit;
}

if ($data['auth_token'] !== 'aei@89806849') {
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// === STEP 2: Get Requested Job and Customer ID ===
$jobId = intval($data['job_id']);
$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

if (!$sdb) {
    echo json_encode(array("status" => "error", "message" => "Database connection failed"));
    exit;
}

$query = "SELECT js.customer_id, js.job_pid, cs.first_name, cs.last_name, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN customers cs ON js.customer_id = cs.id
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.id = " . $jobId;
$result = mysqli_query($sdb, $query);

if (!$result) {
    echo json_encode(array("status" => "error", "message" => "Query failed"));
    exit;
}

$row = mysqli_fetch_assoc($result);

if (!$row) {
    echo json_encode(array("status" => "error", "message" => "Job not found"));
    exit;
}

$customerId = intval($row['customer_id']);

// === STEP 3: Query ALL Jobs for This Customer (to get job_pids) ===
$query2 = "SELECT js.id, js.job_pid, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.customer_id = " . $customerId . "
    ORDER BY js.job_date DESC";
$result2 = mysqli_query($sdb, $query2);

if (!$result2) {
    echo json_encode(array("status" => "error", "message" => "Jobs query failed"));
    exit;
}

// Collect job_pids
$allPids = array();
while ($jobRow = mysqli_fetch_assoc($result2)) {
    $pid = intval($jobRow['job_pid']);
    $allPids[$pid] = true;
}

$images = array();

// === STEP 4: Get photos from meter_files with metadata via JOIN ===
if (!empty($allPids)) {
    $pidList = implode(',', array_keys($allPids));
    $mfQuery = "SELECT mf.webpfilename, mf.job_id, js.job_date, jt.intials
        FROM meter_files mf
        LEFT JOIN jobs js ON mf.job_id = js.job_pid
        LEFT JOIN job_types jt ON js.job_type_id = jt.id
        WHERE mf.job_id IN (" . $pidList . ") AND mf.webpfilename IS NOT NULL";
    $mfResult = mysqli_query($sdb, $mfQuery);
    if ($mfResult) {
        while ($mfRow = mysqli_fetch_assoc($mfResult)) {
            $relatedJobId = intval($mfRow['job_id']);
            $img = $mfRow['webpfilename'];

            // Derive photo_type from job type initials (same logic as getJobPhotoInfo)
            $jt = isset($mfRow['intials']) ? $mfRow['intials'] : '';
            if ($jt == "PM" || $jt == "WM" || $jt == "AS" || $jt == "RPM" || $jt == "GCPM") {
                $photo_type = 'Survey';
            } else {
                $photo_type = 'Installation';
            }

            $job_date = '';
            if (!empty($mfRow['job_date'])) {
                $job_date = date("m-d-Y", strtotime($mfRow['job_date']));
            }

            $images[] = array(
                "link" => $publicBaseUrl . $relatedJobId . '&img=' . rawurlencode($img),
                "job_id" => $relatedJobId,
                "job_type" => $jt,
                "job_date" => $job_date,
                "photo_type" => $photo_type
            );
        }
    }
}

echo json_encode($images);
