# PHOTO-011: Reconciliation Check

## Description

Daily reconciliation that cross-references `meter_files` on the remote server against actual files on the local server, and automatically re-queues anything missing. Catches false-positive syncs where the local server responded HTTP 200 but the file was silently dropped (disk full, permission error, etc.).

## How It Works

1. **Remote** (`process_retry_queue.py`): Once per day (marker file guard), queries `meter_files` for the last 7 days, builds batches of 100 filenames, POSTs each batch to the local `check_photos.php` endpoint.
2. **Local** (`check_photos.php`): Receives a batch of filenames + metadata, checks each against the expected filesystem path (customer folder → Survey/Installation subfolder, or Uploads fallback). Returns the list of missing filenames.
3. **Remote**: For each missing filename, verifies the source file still exists on remote disk. If so, creates a `reconcile_*.json` entry in `queue/` for the existing retry processor to pick up.

No new cron entry — piggybacks on the existing 15-minute cron with a daily guard via `logs/.reconcile_last_run`.

## Files Created

| File | Deploys To | Server |
|------|-----------|--------|
| `NEW/check_photos.php` | `/var/www/html/upload/check_photos.php` | Local |

## Files Modified

| File | Deploys To | Server |
|------|-----------|--------|
| `NEW/upload.php` | `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/upload.php` | Remote |
| `NEW/process_retry_queue.py` | `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/process_retry_queue.py` | Remote |

## Change History

### 2026-02-09: Switch sync source to scheduler/uploads/ (flat copy)

All sync operations now read from `scheduler/uploads/{unique_filename}` instead of `/mnt/dropbox/` hierarchical paths. Part of PHOTO-009 (Unified Storage) preparation.

**upload.php**: Changed `$filePath` → `$filePath_u` in sync_to_local.py command (line 142-143). The file at `scheduler/uploads/` is guaranteed to exist (copy happens at line 115).

**process_retry_queue.py**: Added `SCHEDULER_UPLOADS` constant. Changed `detect_stuck_items()` and `reconcile_local_sync()` to build `file_path` from `SCHEDULER_UPLOADS + filename` instead of `folder_path + filename`.

### 2026-02-09: Initial reconciliation feature

Daily reconciliation cross-referencing `meter_files` against local server files, with `check_photos.php` batch endpoint.

## Dependencies

- PHOTO-003 (Async Sync) — relies on retry queue infrastructure
- PHOTO-009 (Unified Storage) — this change prepares for dropping `/mnt/dropbox/` hierarchy

## Deployment

1. Deploy `check_photos.php` to local:
   ```bash
   scp NEW/check_photos.php root@upload.aeihawaii.com:/var/www/html/upload/check_photos.php
   ```

2. Deploy `upload.php` to remote:
   ```bash
   scp -i /root/.ssh/aei_remote.pem NEW/upload.php Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/upload.php
   ```

3. Deploy `process_retry_queue.py` to remote:
   ```bash
   scp -i /root/.ssh/aei_remote.pem NEW/process_retry_queue.py Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/process_retry_queue.py
   ```

## Rollback

1. Restore original `upload.php` from `ORIGINAL/`:
   ```bash
   scp -i /root/.ssh/aei_remote.pem ORIGINAL/upload.php Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/upload.php
   ```

2. Restore original `process_retry_queue.py` from `ORIGINAL/`:
   ```bash
   scp -i /root/.ssh/aei_remote.pem ORIGINAL/process_retry_queue.py Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/process_retry_queue.py
   ```

3. Remove `check_photos.php` from local (new file, no original to restore):
   ```bash
   ssh root@upload.aeihawaii.com "rm /var/www/html/upload/check_photos.php"
   ```

4. Clean up marker file:
   ```bash
   ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 "rm -f /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/logs/.reconcile_last_run"
   ```

## Verification

```bash
# Test check_photos endpoint
curl -sk -X POST https://upload.aeihawaii.com/check_photos.php \
  -H 'Content-Type: application/json' \
  -d '{"auth_token":"remote_token","photos":[{"filename":"nonexistent.jpg","customer_id":1,"first_name":"Test","last_name":"User","job_date":"2026-01-01","photo_type":"I","job_type":"WS"}]}'

# Run reconciliation manually
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 "/usr/local/bin/python3.6 /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/process_retry_queue.py"

# Check log
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 "grep RECONCILE /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/logs/retry_queue.log | tail -20"

# Verify marker file
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 "cat /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/logs/.reconcile_last_run"
```
