<?php
header('Content-Type: application/json');

// === CONFIGURATION ===
$publicBaseUrl = 'https://aeihawaii.com/photoapi/fetch_image.php?job_id=';

// === STEP 1: Get and Validate JSON Input ===
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['auth_token'], $data['job_id'])) {
    echo json_encode(array("status" => "error", "message" => "Missing auth_token or job_id"));
    exit;
}

if ($data['auth_token'] !== 'aei@89806849') {
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// === STEP 2: Get Requested Job and Customer ID ===
$jobId = intval($data['job_id']);
$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

$query = "SELECT js.customer_id, js.job_pid, cs.first_name, cs.last_name, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN customers cs ON js.customer_id = cs.id
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.id = " . $jobId;
$result = mysqli_query($sdb, $query);
$row = mysqli_fetch_assoc($result);

if (!$row) {
    echo json_encode(array("status" => "error", "message" => "Job not found"));
    exit;
}

$customerId = intval($row['customer_id']);
$customername = $row['last_name'] . ", " . $row['first_name'];

// === Helper: derive photo info from a job row (path reconstruction fallback) ===
function getJobPhotoInfo($job_row) {
    $jt = $job_row['intials'];
    $job_date = date("m-d-Y", strtotime($job_row['job_date']));
    $job_year = date('Y', strtotime($job_row['job_date']));
    $customer_name = $job_row['last_name'] . ", " . $job_row['first_name'];
    $indexname = substr($customer_name, 0, 1);

    if ($jt == "PM" || $jt == "WM" || $jt == "AS" || $jt == "RPM" || $jt == "GCPM") {
        $photo_type = 'Survey';
        $photo_s = 'S';
    } else {
        $photo_type = 'Installation';
        $photo_s = 'I';
    }

    $uploadDir = '/mnt/dropbox/' . $job_year . ' Customers/' . $indexname . '/' . $customer_name . '/' . $photo_type . "/" . $customer_name . ", " . $jt . "-" . $photo_s . ', ' . $job_date . "/webp/";

    return array(
        'photo_type' => $photo_type,
        'photo_s' => $photo_s,
        'job_type' => $jt,
        'job_date' => $job_date,
        'job_year' => $job_year,
        'uploadDir' => $uploadDir
    );
}

// === Helper: scan a webp directory for image files ===
function scanWebpDir($webpDir) {
    if (!is_dir($webpDir)) {
        return array();
    }
    return array_values(array_filter(scandir($webpDir), function($file) use ($webpDir) {
        $fullPath = $webpDir . $file;
        return is_file($fullPath) && preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $file);
    }));
}

// === STEP 3: Query ALL Jobs for This Customer ===
$query2 = "SELECT js.id, js.job_pid, cs.first_name, cs.last_name, js.job_date, jt.intials
    FROM jobs js
    LEFT JOIN customers cs ON js.customer_id = cs.id
    LEFT JOIN job_types jt ON js.job_type_id = jt.id
    WHERE js.customer_id = " . $customerId . "
    ORDER BY js.job_date DESC";
$result2 = mysqli_query($sdb, $query2);

$images = array();
$scannedDirs = array(); // Track scanned directories to avoid duplicates

// Collect job info: map job_pid -> job data
$jobsByPid = array();
while ($jobRow = mysqli_fetch_assoc($result2)) {
    $pid = intval($jobRow['job_pid']);
    $jobsByPid[$pid] = $jobRow;
}

// === STEP 4: Get folder_path from meter_files for all customer's job_pids ===
$allPids = array_keys($jobsByPid);
$folderPathsByPid = array(); // job_pid -> array of distinct folder_paths

if (!empty($allPids)) {
    $pidList = implode(',', $allPids);
    $mfQuery = "SELECT job_id, folder_path FROM meter_files WHERE job_id IN (" . $pidList . ") AND folder_path IS NOT NULL GROUP BY job_id, folder_path";
    $mfResult = mysqli_query($sdb, $mfQuery);
    if ($mfResult) {
        while ($mfRow = mysqli_fetch_assoc($mfResult)) {
            $pid = intval($mfRow['job_id']);
            if (!isset($folderPathsByPid[$pid])) {
                $folderPathsByPid[$pid] = array();
            }
            $fp = $mfRow['folder_path'];
            if (!in_array($fp, $folderPathsByPid[$pid])) {
                $folderPathsByPid[$pid][] = $fp;
            }
        }
    }
}

// === STEP 5: Scan folders — prefer folder_path, fall back to reconstruction ===
foreach ($jobsByPid as $pid => $jobRow) {
    $relatedJobId = intval($jobRow['id']);
    $info = getJobPhotoInfo($jobRow);

    // 5a: Use folder_path from meter_files if available
    if (isset($folderPathsByPid[$pid])) {
        foreach ($folderPathsByPid[$pid] as $fp) {
            $webpDir = rtrim($fp, '/') . '/webp/';
            if (isset($scannedDirs[$webpDir])) {
                continue;
            }
            $scannedDirs[$webpDir] = true;

            $imageFiles = scanWebpDir($webpDir);
            foreach ($imageFiles as $img) {
                $images[] = array(
                    "link" => $publicBaseUrl . $relatedJobId . '&img=' . rawurlencode($img),
                    "job_id" => $relatedJobId,
                    "job_type" => $info['job_type'],
                    "job_date" => $info['job_date'],
                    "photo_type" => $info['photo_type']
                );
            }
        }
    }

    // 5b: Fall back to path reconstruction (for legacy rows with NULL folder_path)
    $reconstructedDir = $info['uploadDir'];
    if (!isset($scannedDirs[$reconstructedDir])) {
        $scannedDirs[$reconstructedDir] = true;

        $imageFiles = scanWebpDir($reconstructedDir);
        foreach ($imageFiles as $img) {
            $images[] = array(
                "link" => $publicBaseUrl . $relatedJobId . '&img=' . rawurlencode($img),
                "job_id" => $relatedJobId,
                "job_type" => $info['job_type'],
                "job_date" => $info['job_date'],
                "photo_type" => $info['photo_type']
            );
        }
    }
}

// === STEP 6: Legacy /mnt/aeiserver/ Scan (Backward Compatibility) ===
$legacyDir = '/mnt/aeiserver/' . $jobId . '/';

if (is_dir($legacyDir)) {
    $legacyFiles = @scandir($legacyDir);
    if ($legacyFiles) {
        $legacyFiles = array_values(array_filter($legacyFiles, function($file) use ($legacyDir) {
            $fullPath = $legacyDir . $file;
            return is_file($fullPath) && preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $file);
        }));

        foreach ($legacyFiles as $img) {
            $images[] = array(
                "link" => $publicBaseUrl . $jobId . '&img=' . rawurlencode($img),
                "job_id" => $jobId,
                "job_type" => "",
                "job_date" => "",
                "photo_type" => "Legacy"
            );
        }
    }
}

// === STEP 7: Send Response ===
echo json_encode($images);
