<?php
// Allow only GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo "Method Not Allowed";
    exit;
}

// Sanitize and validate input
$jobId = isset($_GET['job_id']) ? intval($_GET['job_id']) : 0;
$fileName = isset($_GET['img']) ? basename($_GET['img']) : '';

if (!$jobId || !$fileName) {
    echo "Missing job_id or file parameter";
    exit;
}

$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

$filePath = '';

// === Primary: Look up webpfilename in meter_files, serve from scheduler/uploads/webp/ ===
$mfQuery = "SELECT mf.webpfilename, mf.unique_filename FROM meter_files mf
    INNER JOIN jobs js ON js.job_pid = mf.job_id
    WHERE js.id = " . $jobId . "
    AND mf.webpfilename = '" . mysqli_real_escape_string($sdb, $fileName) . "'
    LIMIT 1";
$mfResult = mysqli_query($sdb, $mfQuery);
if ($mfResult && $mfRow = mysqli_fetch_assoc($mfResult)) {
    // Try WebP in flat storage
    $candidatePath = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp/' . $mfRow['webpfilename'];
    if (file_exists($candidatePath) && is_file($candidatePath)) {
        $filePath = $candidatePath;
    }

    // Fallback 1: Try original file in scheduler/uploads/
    if (!$filePath && !empty($mfRow['unique_filename'])) {
        $candidatePath = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/' . $mfRow['unique_filename'];
        if (file_exists($candidatePath) && is_file($candidatePath)) {
            $filePath = $candidatePath;
        }
    }
}

// === Fallback 2: Legacy /mnt/aeiserver/ (for truly old photos) ===
if (!$filePath) {
    $legacyPath = '/mnt/aeiserver/' . $jobId . '/' . $fileName;
    if (file_exists($legacyPath) && is_file($legacyPath)) {
        $filePath = $legacyPath;
    }
}

if (!$filePath) {
    echo "File not found";
    exit;
}

// Get MIME type based on file extension
$ext = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
$mimeTypes = array(
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'png' => 'image/png',
    'gif' => 'image/gif',
    'webp' => 'image/webp'
);

$contentType = isset($mimeTypes[$ext]) ? $mimeTypes[$ext] : 'application/octet-stream';

header("Content-Type: $contentType");
header("Content-Length: " . filesize($filePath));

readfile($filePath);
exit;
?>
