<?php  
class Preupload extends  Controller {
    public function Preupload(){
      
	   parent::Controller();
        //error_reporting(E_ALL);
        $this->load->helper(array('url','form','file','text','security'));
        $this->load->library(array('session','form_validation','upload'));
        $this->load->model('preupload_model');
    }

    public function index(){
        // optional: require login
        // if (!$this->session->userdata('user_id')) redirect('login');
		 // die("Sdfsdfsd");
        $data = array(
            'title' => 'Premeasure Upload'
        );
       $this->load->view('preupload/form', $data);
    }

  public function submit(){
        // CSRF protection is handled by CI if enabled
        $this->form_validation->set_rules('customer_name','Customer Name','trim|required|min_length[2]|max_length[120]');
        $this->form_validation->set_rules('job_type','Job Type','trim|required|max_length[50]');
        $this->form_validation->set_rules('photo_type','Photo Type','trim|required|max_length[50]');
        $this->form_validation->set_rules('job_date','Job Date','trim|required|max_length[20]');
        $this->form_validation->set_rules('notes','Notes','trim|max_length[2000]');

        if (!$this->form_validation->run()){
            $this->session->set_flashdata('error', validation_errors(' ',' '));
            redirect('preupload');
        }

        $customer_id = $this->input->post('customer_name', TRUE);
        $job_type_id      = $this->input->post('job_type', TRUE);
     $job_date      = $this->input->post('job_date', TRUE); 
        $notes         = $this->input->post('notes', TRUE);
        $photo_type         = $this->input->post('photo_type', TRUE);
		$cust_info=$this->db->query("select * from customers where id=".$customer_id)->row_array();
        $job_type=$this->db->query("select * from job_types where id=".$job_type_id)->row_array();
        $job_id_row=$this->db->query("select job_pid from jobs where job_type_id=".$job_type_id." AND customer_id=".$customer_id)->row_array();
        $job_id=$job_id_row["job_pid"];
		$customer_name=$cust_info["last_name"].", ".$cust_info["first_name"];
        $first_name=$cust_info["first_name"];
        $last_name=$cust_info["last_name"];

		$indexname = substr($cust_info["last_name"], 0, 1);
        $job_type_text=$job_type["intials"];
		$job_date = $this->input->post('job_date', TRUE);
	    $this->load->helper("thumbnail_helper");
        $config['max_size'] = 10485760;
        $config['upload_path'] = FCPATH . 'uploads/';
        $config['encrypt_name'] = true;
        $config['allowed_types'] = 'jpg|jpeg|png|gif';
        $this->load->library('upload', $config);

// Normalize to YYYY-MM-DD for DB
$norm_date = $job_date;
// dd-mm-yyyy -> yyyy-mm-dd
if (preg_match('~^(\d{2})-(\d{2})-(\d{4})$~', $job_date, $m)) {
    $norm_date = $m[3].'-'.$m[2].'-'.$m[1];
// yyyy-mm-dd (native <input type="date">)
} elseif (preg_match('~^(\d{4})-(\d{2})-(\d{2})$~', $job_date, $m)) {
    $norm_date = $m[1].'-'.$m[2].'-'.$m[3];
}
 $job_date=date("m-d-Y",strtotime($norm_date)); 
        // create "header" record
        $upload_id = $this->preupload_model->create_header(array(
            'customer_name' => $customer_id,
            'job_type' => $job_type_id,
            'job_date' => $norm_date,
            'notes' => $notes
        ));

        // Prepare destination dir
        //$slug = strtolower(preg_replace('~[^a-z0-9]+~i', '-', $customer_name));
        //$dir = FCPATH . 'public/uploads/premeasure/'.date('Ymd').'/'.$upload_id.'-'.$slug;
        //if (!is_dir($dir)) @mkdir($dir, 0775, TRUE);

        $saved = array();
        $errors = array();

        if (!empty($_FILES['files']['name'][0])) {
            $count = count($_FILES['files']['name']);
            for ($i=0; $i<$count; $i++){
                $_FILES['file']['name']     = $_FILES['files']['name'][$i];
                $_FILES['file']['type']     = $_FILES['files']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
                $_FILES['file']['error']    = $_FILES['files']['error'][$i];
                $_FILES['file']['size']     = $_FILES['files']['size'][$i];
                
                $config = array();
                 $config['upload_path'] = FCPATH . 'uploads/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif|webp|pdf';
                $config['encrypt_name']  = TRUE;
                $config['max_size']      = 50 * 1024; // 50MB per file
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('file')){
                    $errors[] = $this->upload->display_errors('','');
                } else {
                      $data = $this->upload->data();
					 $new_base_url = explode("/dev", base_url());
					 if (count($new_base_url) > 1) {

                $srcpath = '/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/uploads/' . $data['file_name'];
                $despath = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/' . $data['file_name'];
                $filePath = $srcpath;
              
                if (!copy($srcpath, $despath)) {
                    die("image problem");
                }
            } else {
			$filePath = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/' .  $data['file_name'];
            }             
         $uploadDir='/mnt/dropbox/2025 Customers/'.$indexname;
           $saved[] = $filePath;
		   if (!is_dir($uploadDir)) {
              mkdir($uploadDir, 0777, true);
           }

		   $uploadDir_customer=$uploadDir.'/'.$customer_name;
		    if (!is_dir($uploadDir_customer)) {
              mkdir($uploadDir_customer, 0777, true);
           }

		   $uploadDir_customer_survey=$uploadDir.'/'.$customer_name."/Survey";
		    if (!is_dir($uploadDir_customer_survey)) {
              mkdir($uploadDir_customer_survey, 0777, true);
           }

		    $uploadDir_customer_install=$uploadDir.'/'.$customer_name."/Installation";
		    if (!is_dir($uploadDir_customer_install)) {
              mkdir($uploadDir_customer_install, 0777, true);
           }
		   
		   if($photo_type=="I"){
              $final_folder=$uploadDir_customer_install."/".$customer_name.", ".$job_type_text."-I, ".$job_date;	
			  if (!is_dir($final_folder)) {
                mkdir($final_folder, 0777, true);
           }
		   } else {
				  $final_folder=$uploadDir_customer_survey."/".$customer_name.", ".$job_type_text."-S, ".$job_date;	
			  if (!is_dir($final_folder)) {
                mkdir($final_folder, 0777, true);
           }
              
		   }
           
		   $final_folder_webp=$final_folder."/webp/";
		   if(!is_dir($final_folder_webp)){
              mkdir($final_folder_webp, 0777, true);
		   }

		   $final_folder=$final_folder."/". $data['file_name'];
		   copy($filePath , $final_folder) ;
             $config['source_image'] =  '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/' . $data['file_name'];
             $config['maintain_ratio'] = TRUE;

	$remoteUploadUrl = 'https://upload.aeihawaii.com/uploadlocallat_kuldeep.php';
	                    
$remoteAuthToken = 'remote_token';

$filePath = realpath($filePath);
if (!$filePath || !is_readable($filePath)) {
    die("Local file not found/readable");
}


$postFields = array(
    'auth_token' => $remoteAuthToken,
    'file'       => '@' . $filePath, // classic style for PHP 5.3
    'file_name'  => basename($filePath),
    'job_id'     => $job_id,
    'job_type'   => $job_type_text,
    'first_name' => $first_name,
    'last_name'  => $last_name,
	'job_date'  => $norm_date,
	'photo_type' => $photo_type,
);

$ch = curl_init($remoteUploadUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
// Helpful: follow redirects and show headers for debugging
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_HEADER, true);

// Reduce WAF false positives
$headers = array(
    'Expect:',                           // disable 100-continue
    'X-Requested-With: XMLHttpRequest',  // often whitelisted by WAFs
    // 'Content-Type: multipart/form-data' // usually let cURL set this
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Set a friendly UA
curl_setopt($ch, CURLOPT_USERAGENT, 'AEI-Uploader/1.0');

// (Diagnostics only  remove once verified)
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

$responseWithHeaders = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$err = curl_error($ch);
curl_close($ch);
$customer_namewebp=$last_name.$first_name;
// Split headers/body for inspection
list($respHeaders, $respBody) = explode("\r\n\r\n", $responseWithHeaders, 2);

 $randomId = rand(100000, 999999);
$final_folder_webp= $final_folder_webp.$customer_namewebp."".$job_type_text."-".$photo_type.$job_date."_IMG".$randomId.'.webp';

file_put_contents($final_folder_webp,$respBody);
//$final_folder_webp." ,/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp/".$customer_namewebp."".$job_type_text."-S".$job_date."_IMG".$randomId.'.webp';
 copy($final_folder_webp , "/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp/".$customer_namewebp."".$job_type_text."-S".$job_date."_IMG".$randomId.'.webp') ;

@curl_close($ch);

             $config['height']	=1027;
             $config['width']	= 800;
             $this->load->library('image_lib');
             $this->image_lib->initialize($config); 
             $this->image_lib->resize();
              $file_size = filesize($config['source_image']); // Get file size in bytes
            $file_size = $file_size / 1024;
            $row['original_filename'] = $data['orig_name'];
            $row['unique_filename'] = $data['file_name'];
			$row['webpfilename']=$customer_namewebp."".$job_type_text."-S".$job_date."_IMG".$randomId.'.webp';
            $row['mime'] = $data['file_type'];
            $row['created'] = date("Y-m-d h:i:s");
           // $pid_job = $this->getparentjobid($job_id);
            $row['job_id'] = $job_id;
            $row['file_size'] =  $file_size ;
            $row['file_type'] = 99;
            $row['title'] = $data['orig_name'];
            $row['desc'] = $data['orig_name'];
            $this->db->insert("meter_files", $row);
            $this->load->helper('text');
           $file_id = $this->db->insert_id();
           
                }
            }
        }

        if (!empty($errors)){
            $this->session->set_flashdata('error', implode("; ", $errors));
        } else {
           $this->session->set_flashdata(
    'success',
    sprintf(
        'Uploaded %d file(s). You can review them here: <a href="%s">Here</a>',
        count($saved),
         site_url('preupload/gallery/' . $job_id)
    )
);

        }
		
        redirect('preupload');
    }

	 // GET /api/jobtypes?date=YYYY-MM-DD
    public function jobtypes(){
        $date = $this->input->get('date', TRUE);
        if (!$date || !preg_match('~^\d{4}-\d{2}-\d{2}$~', $date)) {
           // http_response_code(400);
            echo json_encode(array('status'=>'error','message'=>'Invalid or missing date'));
            return;
        }
        $out = $this->job_types_for_date($date);
        echo json_encode(array('status'=>'ok','items'=>$out));
    }

    // GET /api/customers?date=YYYY-MM-DD&job_type=premeasure
    public function customers(){
        $date = $this->input->get('date', TRUE);
        $type = $this->input->get('job_type', TRUE);
        if (!$date || !preg_match('~^\d{4}-\d{2}-\d{2}$~', $date) || !$type) {
          //  http_response_code(400);
           echo json_encode(array('status'=>'error','message'=>'Invalid or missing parameters'));
            return;
        }
        $out = $this->customers_for_date_and_type($date, $type);
        echo json_encode(array('status'=>'ok','items'=>$out));
    }

	public function job_types_for_date($ymd) {
      $rows =$this->db->query("select distinct jb.job_type_id,jt.intials from jobs jb left join job_types jt on jb.job_type_id=jt.id where jb.job_date='$ymd' and job_type_id>0 ")->result_array();
	  $row_array=array();
	  $row_json=array();
	  foreach($rows as $row){
        $row_array['value']=$row['job_type_id'];
        $row_array['label']=$row['intials'];
	    $row_json[]=$row_array;
	  }
	  return $row_json;
	}

public function customers_for_date_and_type($ymd, $job_type) {
	$rows =$this->db->query("select cs.id,cs.first_name,cs.last_name from jobs jb left join customers cs on cs.id=jb.customer_id where jb.job_date='$ymd' and job_type_id=$job_type ")->result_array();
	  $row_array=array();
	  $row_json=array();
	  foreach($rows as $row){
       $row_array['value']=$row['id'];
        $row_array['label']=ucfirst($row['first_name'])." ".ucfirst($row['last_name']);
	    $row_json[]=$row_array;
	  }
	  return $row_json;
    }

	public function gallery($job_id)
{
    $job_id = (int)$job_id;
    if ($job_id <= 0) show_404();

    // Fetch files for this job
    $rows = $this->db->query("SELECT id, unique_filename, original_filename, mime, file_size,webpfilename
                              FROM meter_files
                              WHERE job_id = ".$job_id."
                              ORDER BY id DESC")->result_array();

    // Base paths (adjust if different)
     $uploadRel = 'uploads/webp/'; // relative to web root
    $uploadFs  = FCPATH . $uploadRel; // filesystem dir
     $uploadUrl = base_url($uploadRel); // public url  die;

    $this->load->helper('webp'); // our helper above

    $items = array();
    foreach ($rows as $r) {
        $origName = $r['webpfilename'];
       $srcFs = $uploadFs . $origName;
    $srcUrl = $uploadUrl."uploads/webp/". $origName;

        if (!is_file($srcFs)) { continue;}

        // Make a thumb (400x400) and a large (1600x1600) WEBP
        $thumbUrl = pcos_make_webp($srcFs, $srcUrl, '.thumb', 400, 400, 78);
        $fullUrl  = pcos_make_webp($srcFs, $srcUrl, '',      1600,1600,82);

        $items[] = array(
            'id'    => (int)$r['id'],
            'thumb' => $thumbUrl,
            'full'  => $fullUrl,
            'title' => $r['original_filename']
        );
    }

    $data = array(
        'job_id' => $job_id,
        'items'  => $items
    );

    $this->load->view('preupload/gallery_view', $data);
}
public function download_all($job_id)
{
    $job_id = (int)$job_id;
    if ($job_id <= 0) show_404();

    // Collect files
    $rows = $this->db->query(
        "SELECT id, unique_filename, original_filename
         FROM meter_files
         WHERE job_id = ".$job_id."
         ORDER BY id ASC"
    )->result_array();

    if (!$rows) {
        show_error('No files found for this job.', 404);
        return;
    }

    $uploadFs = FCPATH . 'uploads/';
    $zipName  = 'job-'.$job_id.'-photos-'.date('Ymd_His').'.zip';

    // Prefer ZipArchive to avoid CI Zip in-memory size limits
    if (class_exists('ZipArchive')) {
        $tmpZip = tempnam(sys_get_temp_dir(), 'zip');
        $zip = new ZipArchive();
        if ($zip->open($tmpZip, ZIPARCHIVE::OVERWRITE) !== TRUE) {
            show_error('Unable to create zip.', 500);
            return;
        }

        $i = 1;
        foreach ($rows as $r) {
            $fs = $uploadFs . $r['unique_filename'];
            if (!is_file($fs) || !is_readable($fs)) continue;

            // Nice inside-zip name: 001-OriginalName.ext (fallback to unique_filename)
            $basename = $r['original_filename'] ? $r['original_filename'] : $r['unique_filename'];
            $safeName = $this->_pcos_sanitize_zip_path(sprintf('%03d-%s', $i, $basename));
            $zip->addFile($fs, $safeName);
            $i++;
        }
        $zip->close();

        // Stream it
        header('Content-Type: application/zip');
        header('Content-Length: ' . filesize($tmpZip));
        header('Content-Disposition: attachment; filename="'.$zipName.'"');
        header('Pragma: public');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        readfile($tmpZip);
        @unlink($tmpZip);
        exit;
    }

    // Fallback: CI Zip library (may use more memory for many files)
    $this->load->library('zip');
    $i = 1;
    foreach ($rows as $r) {
        $fs = $uploadFs . $r['unique_filename'];
        if (!is_file($fs) || !is_readable($fs)) continue;

        $basename = $r['original_filename'] ? $r['original_filename'] : $r['unique_filename'];
        $safeName = $this->_pcos_sanitize_zip_path(sprintf('%03d-%s', $i, $basename));
        $this->zip->read_file($fs, $safeName);
        $i++;
    }
    $this->zip->download($zipName); // exits
}

/**
 * Optional: POST /preupload/download_selected
 * ids[] = meter_files.id values
 */
public function download_selected()
{
    $ids = $this->input->post('ids');
    if (!$ids || !is_array($ids)) {
        show_error('No file IDs provided.', 400);
        return;
    }

    // sanitize to integers
    $clean = array();
    foreach ($ids as $id) {
        $id = (int)$id;
        if ($id > 0) $clean[] = $id;
    }
    if (!$clean) {
        show_error('No valid file IDs.', 400);
        return;
    }

    $in = implode(',', $clean);
    $rows = $this->db->query(
        "SELECT id, unique_filename, original_filename, job_id
         FROM meter_files WHERE id IN ($in)
         ORDER BY id ASC"
    )->result_array();

    if (!$rows) {
        show_error('No matching files.', 404);
        return;
    }

    $job_id = isset($rows[0]['job_id']) ? (int)$rows[0]['job_id'] : 0;
    $uploadFs = FCPATH . 'uploads/';
    $zipName  = 'job-'.$job_id.'-selected-'.date('Ymd_His').'.zip';

    if (class_exists('ZipArchive')) {
        $tmpZip = tempnam(sys_get_temp_dir(), 'zip');
        $zip = new ZipArchive();
        if ($zip->open($tmpZip, ZIPARCHIVE::OVERWRITE) !== TRUE) {
            show_error('Unable to create zip.', 500);
            return;
        }
        $i = 1;
        foreach ($rows as $r) {
            $fs = $uploadFs . $r['unique_filename'];
            if (!is_file($fs) || !is_readable($fs)) continue;
            $basename = $r['original_filename'] ? $r['original_filename'] : $r['unique_filename'];
            $safeName = $this->_pcos_sanitize_zip_path(sprintf('%03d-%s', $i, $basename));
            $zip->addFile($fs, $safeName);
            $i++;
        }
        $zip->close();
        header('Content-Type: application/zip');
        header('Content-Length: ' . filesize($tmpZip));
        header('Content-Disposition: attachment; filename="'.$zipName.'"');
        header('Pragma: public');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        readfile($tmpZip);
        @unlink($tmpZip);
        exit;
    }

    $this->load->library('zip');
    $i = 1;
    foreach ($rows as $r) {
        $fs = $uploadFs . $r['unique_filename'];
        if (!is_file($fs) || !is_readable($fs)) continue;
        $basename = $r['original_filename'] ? $r['original_filename'] : $r['unique_filename'];
        $safeName = $this->_pcos_sanitize_zip_path(sprintf('%03d-%s', $i, $basename));
        $this->zip->read_file($fs, $safeName);
        $i++;
    }
    $this->zip->download($zipName); // exits
}

/**
 * Sanitize the file path used inside the zip.
 * Keep it flat (no directories), ASCII-safe.
 */
private function _pcos_sanitize_zip_path($name)
{
    // Remove any path parts
    $name = basename($name);
    // Replace disallowed chars
    $name = preg_replace('~[^A-Za-z0-9._-]+~', '_', $name);
    // Avoid empty
    if ($name === '' || $name === '.' || $name === '..') {
        $name = 'file';
    }
    return $name;
}


}
