# Enhancement: Persist Photo Folder Path in meter_files

## Purpose
Store the absolute folder path in `meter_files.folder_path` at upload time so photos remain accessible even if jobs are unscheduled, rescheduled, or deleted.

## Files Changed

| File | Server | Change |
|------|--------|--------|
| `upload.php` | Remote | Add `folder_path` to INSERT |
| `getimagelisting.php` | Remote | Use `folder_path` when available, fallback to reconstruction |
| `fetch_image.php` | Remote | Use `folder_path` when available, fallback to reconstruction |
| `uploadlocallat_kuldeep.php` | Local | Fix Survey spacing bug (`-S,` -> `-S, `) |

## Schema Change
```sql
ALTER TABLE meter_files ADD COLUMN folder_path VARCHAR(512) DEFAULT NULL AFTER webpfilename;
```

## Rollback

### Quick Rollback (restore original files)
```bash
# Remote server
scp -i /root/.ssh/aei_remote.pem ORIGINAL/upload.php Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/upload.php
scp -i /root/.ssh/aei_remote.pem ORIGINAL/getimagelisting.php Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting.php
scp -i /root/.ssh/aei_remote.pem ORIGINAL/fetch_image.php Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/fetch_image.php

# Local server
cp ORIGINAL/uploadlocallat_kuldeep.php /var/www/html/upload/uploadlocallat_kuldeep.php
```

### Schema Rollback (optional — NULL column is harmless)
```sql
ALTER TABLE meter_files DROP COLUMN folder_path;
```
