# Photo Folder Path Enhancement

## Problem

Photo folder paths are reconstructed at read time from `jobs` table metadata (`job_date`, `job_type`, customer name). If a job is unscheduled, rescheduled, or deleted, the reconstructed path no longer matches the physical folder where photos were originally stored. Photos become inaccessible.

**Root cause:** `meter_files` stores filenames but not the folder path where photos were saved.

## Solution

Add a `folder_path` column to `meter_files` that stores the absolute path at upload time.

### Schema Change

```sql
ALTER TABLE meter_files ADD COLUMN folder_path VARCHAR(512) DEFAULT NULL AFTER webpfilename;
```

- `NULL` for existing rows (pre-enhancement) — these use path reconstruction as fallback
- New uploads always populate this column

### Code Changes

#### upload.php (Remote)
- After `$final_folder` is constructed, include it in the `meter_files` INSERT statement

#### getimagelisting.php (Remote)
- Query `meter_files` for `folder_path` values associated with the customer's jobs
- If `folder_path` is populated: scan that directory directly
- If `folder_path` is NULL: fall back to existing path reconstruction
- If `jobs` record is missing: still find photos via `meter_files.folder_path`

#### fetch_image.php (Remote)
- Query `meter_files` by filename to get `folder_path`
- If populated: construct full file path directly
- If NULL: fall back to existing `jobs`-based path reconstruction

### Bug Fix: Survey Path Spacing

#### uploadlocallat_kuldeep.php (Local)
Pre-existing bug: Local server wrote `-S,{date}` (no space after comma) while remote writes `-S, {date}` (with space). Fixed all 4 instances to include the space.

## Backward Compatibility

- Existing rows with `folder_path = NULL` continue to work via path reconstruction
- New rows get `folder_path` populated automatically
- No migration of existing data required (optional future enhancement)

## Deployment

1. ALTER TABLE on remote server
2. Deploy `upload.php` to remote
3. Deploy `getimagelisting.php` to remote
4. Deploy `fetch_image.php` to remote
5. Deploy `uploadlocallat_kuldeep.php` to local

## Rollback

Restore files from `ENHANCEMENTS/PHOTO_FOLDER_PATH/ORIGINAL/` and optionally drop the column.
