<?php
// Allow only GET requests
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo "Method Not Allowed";
    exit;
}

// Sanitize and validate input
$jobId = isset($_GET['job_id']) ? intval($_GET['job_id']) : 0;
$fileName = isset($_GET['img']) ? basename($_GET['img']) : '';

if (!$jobId || !$fileName) {
    echo "Missing job_id or file parameter";
    exit;
}

$sdb = mysqli_connect("localhost", "schedular", "M1gif9!6", "mandhdesign_schedular");

// === Try folder_path from meter_files first ===
$filePath = '';
$mfQuery = "SELECT mf.folder_path FROM meter_files mf
    INNER JOIN jobs js ON js.job_pid = mf.job_id
    WHERE js.id = " . $jobId . "
    AND mf.webpfilename = '" . mysqli_real_escape_string($sdb, $fileName) . "'
    AND mf.folder_path IS NOT NULL
    LIMIT 1";
$mfResult = mysqli_query($sdb, $mfQuery);
if ($mfResult && $mfRow = mysqli_fetch_assoc($mfResult)) {
    $candidatePath = rtrim($mfRow['folder_path'], '/') . '/webp/' . $fileName;
    if (file_exists($candidatePath) && is_file($candidatePath)) {
        $filePath = $candidatePath;
    }
}

// === Fallback: reconstruct path from jobs table ===
if (!$filePath) {
    $query = "SELECT cs.first_name, cs.last_name, js.job_date, jt.intials
        FROM jobs js
        LEFT JOIN customers cs ON js.customer_id = cs.id
        LEFT JOIN job_types jt ON js.job_type_id = jt.id
        WHERE js.id = " . $jobId;
    $result = mysqli_query($sdb, $query);
    $row = mysqli_fetch_assoc($result);

    if (!$row) {
        echo "Job not found";
        exit;
    }

    $job_date = date("m-d-Y", strtotime($row['job_date']));
    $job_type_text = $row['intials'];
    $customername = $row['last_name'] . ", " . $row['first_name'];
    $customer_name = $customername;
    $indexname = substr($customer_name, 0, 1);

    if ($job_type_text == "PM" || $job_type_text == "WM" || $job_type_text == "AS" || $job_type_text == "RPM" || $job_type_text == "GCPM") {
        $photo_type = 'Survey';
        $photo_s = 'S';
    } else {
        $photo_type = 'Installation';
        $photo_s = 'I';
    }

    $job_year = date('Y', strtotime($row['job_date']));
    $uploadDir = '/mnt/dropbox/' . $job_year . ' Customers/' . $indexname . '/' . $customername . '/' . $photo_type . "/" . $customer_name . ", " . $job_type_text . "-" . $photo_s . ', ' . $job_date . '/webp/';

    $filePath = "$uploadDir/$fileName";
}

if (!file_exists($filePath) || !is_file($filePath)) {
    echo "File not found";
    exit;
}

// Get MIME type based on file extension
$ext = strtolower(pathinfo($filePath, PATHINFO_EXTENSION));
$mimeTypes = array(
    'jpg' => 'image/jpeg',
    'jpeg' => 'image/jpeg',
    'png' => 'image/png',
    'gif' => 'image/gif',
    'webp' => 'image/webp'
);

$contentType = isset($mimeTypes[$ext]) ? $mimeTypes[$ext] : 'application/octet-stream';

header("Content-Type: $contentType");
header("Content-Length: " . filesize($filePath));

readfile($filePath);
exit;
?>
