<?php
header('Content-Type: application/json');

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);
	
// Validate input
if (!isset($data['auth_token'], $data['file_name'], $data['image_data'],$data['job_id'])) {
    //http_response_code(400);
    echo json_encode(array("status" => "error", "message" => "Missing fields"));
    exit;
}


// Optional: Verify token
if ($data['auth_token'] !== 'aei@89806849') {
   // http_response_code(403);
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// Decode base64 image
$imageData = base64_decode($data['image_data']);
if ($imageData === false) {
   // http_response_code(400);
    echo json_encode(array("status" => "error", "message" => "Invalid base64"));
    exit;
}
$sdb=mysqli_connect("localhost","schedular","M1gif9!6","mandhdesign_schedular");
// Connect to database and get job/customer details
$query = "SELECT js.customer_id, cs.first_name, cs.last_name, js.job_date, jt.intials, js.job_pid
          FROM jobs js
          LEFT JOIN customers cs ON js.customer_id = cs.id
          LEFT JOIN job_types jt ON js.job_type_id = jt.id
          WHERE js.id = " . intval($data['job_id']);
$result = mysqli_query($sdb, $query);
$row = mysqli_fetch_assoc($result);
$customer_id = $row['customer_id'];
$job_date_t = $row['job_date'];
$job_date = date("m-d-Y", strtotime($row['job_date']));
$folder_location = $row['last_name'] . $row['first_name'] . "-" . $row['intials'] . "-" . $job_date;
$customer_name = $row['last_name'] . ", " . $row['first_name'];
$job_type_text = $row['intials'];
$first_name = $row['first_name'];
$last_name = $row['last_name'];
$indexname = substr($customer_name, 0, 1);
// Save image

 if($job_type_text=="PM" || $job_type_text=="WM" || $job_type_text=="AS"   || $job_type_text=="RPM" || $job_type_text=="GCPM" ){
 $photo_type='S';
}else{
$photo_type='I';
}
$uploadDir = __DIR__ . '/uploads/';
  $job_year = date("Y", strtotime($job_date_t));
  $uploadDir='/mnt/dropbox/'.$job_year.' Customers/'.$indexname;
 
if (!is_dir($uploadDir)) {
              mkdir($uploadDir, 0777, true);
           }

		   $uploadDir_customer=$uploadDir.'/'.$customer_name;
		    if (!is_dir($uploadDir_customer)) {
              mkdir($uploadDir_customer, 0777, true);
           }

		   $uploadDir_customer_survey=$uploadDir.'/'.$customer_name."/Survey";
		    if (!is_dir($uploadDir_customer_survey)) {
              mkdir($uploadDir_customer_survey, 0777, true);
           }

		    $uploadDir_customer_install=$uploadDir.'/'.$customer_name."/Installation";
		    if (!is_dir($uploadDir_customer_install)) {
              mkdir($uploadDir_customer_install, 0777, true);
           }
		   
		   if($photo_type=="I"){
              $final_folder=$uploadDir_customer_install."/".$customer_name.", ".$job_type_text."-I, ".$job_date.'/';	
			  if (!is_dir($final_folder)) {
                mkdir($final_folder, 0777, true);
           }
              copy($filePath , $final_folder) ;
		   } else {
				  $final_folder=$uploadDir_customer_survey."/".$customer_name.", ".$job_type_text."-S, ".$job_date.'/';	
			  if (!is_dir($final_folder)) {
                mkdir($final_folder, 0777, true);
           }
		   }

		   // Create webp/ folder for mobile app image listing
		   $final_folder_webp=$final_folder."/webp/";
		   if(!is_dir($final_folder_webp)){
              mkdir($final_folder_webp, 0777, true);
		   }

$filePath = $final_folder . basename($data['file_name']);

if (!file_put_contents($filePath, $imageData)) {
    echo json_encode(array("status" => "error", "message" => "Failed to save image"));
    exit;
}

// Validate saved file
$filePath = realpath($filePath);
if (!$filePath || !is_readable($filePath)) {
    echo json_encode(array("status" => "error", "message" => "Saved file not readable"));
    exit;
}

$job_id = $row['job_pid'];

// Copy original to scheduler uploads
$filename_insert = basename($data['file_name']);
$filePath_u = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/' . $filename_insert;
copy($filePath, $filePath_u);

// Generate WebP in background (non-blocking) for mobile app image listing
// Uses Python/Pillow since PHP 5.3 has no WebP GD support
$customer_namewebp = $last_name . $first_name;
$randomId = rand(100000, 999999);
$webpfilename = $customer_namewebp . "" . $job_type_text . "-" . $photo_type . $job_date . "_IMG" . $randomId . '.webp';
$webp_dest = $final_folder_webp . $webpfilename;
$scheduler_webp_dest = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp/' . $webpfilename;

$generateScript = __DIR__ . '/generate_webp.py';
$cmd = 'nohup /usr/local/bin/python3.6 ' . escapeshellarg($generateScript)
     . ' ' . escapeshellarg($filePath)
     . ' ' . escapeshellarg($webp_dest)
     . ' 80'
     . ' && cp ' . escapeshellarg($webp_dest) . ' ' . escapeshellarg($scheduler_webp_dest)
     . ' > /dev/null 2>&1 &';
exec($cmd);

// Insert file record into database
$sql_insert = 'Insert into meter_files(job_id,unique_filename,original_filename,file_size,file_type,webpfilename,created) values(' . intval($job_id) . ',"' . mysqli_real_escape_string($sdb, $filename_insert) . '","' . mysqli_real_escape_string($sdb, $filename_insert) . '","' . filesize($filePath) . '","99","' . mysqli_real_escape_string($sdb, $webpfilename) . '", "' . date("Y-m-d, h:i:s") . '")';
mysqli_query($sdb, $sql_insert);

// Sync to local server in background (non-blocking)
// Replaces synchronous cURL — mobile app no longer waits for local server round-trip
$syncScript = __DIR__ . '/sync_to_local.py';
$syncCmd = 'nohup /usr/local/bin/python3.6 ' . escapeshellarg($syncScript)
    . ' ' . escapeshellarg($filePath)
    . ' ' . escapeshellarg(basename($filePath))
    . ' ' . escapeshellarg($job_id)
    . ' ' . escapeshellarg($customer_id)
    . ' ' . escapeshellarg($job_type_text)
    . ' ' . escapeshellarg($last_name)
    . ' ' . escapeshellarg($first_name)
    . ' ' . escapeshellarg($job_date_t)
    . ' ' . escapeshellarg($photo_type)
    . ' > /dev/null 2>&1 &';
exec($syncCmd);

// Send response to mobile app — this is the LAST thing before script ends
echo json_encode(array("success"=> 1,"status" => "ok", "message" => "Image uploaded", "path" => basename($filePath)));
?>
