# Enhancement: Background WebP Generation

**Date:** 2026-02-04
**Status:** Deployed
**Reconstruction:** Retroactive (created 2026-02-05 from available backups)

## Purpose

Replaced synchronous WebP generation with asynchronous background processing via `generate_webp.py` (nohup &). Also fixed hardcoded "2025" year references, added cURL connect timeout, corrected photo_type in WebP filenames, and added dynamic filesize to DB inserts. On the local server, replaced inline WebP/thumbnail generation with a background Python thumbnail generator.

## Context

This enhancement went through ~5 iterations on Feb 4 (WebP removal, synchronous Python, hybrid restore, async background) before arriving at the final async approach. The backups capture intermediate states from this iterative process.

## Files Changed

| File | Server | Change |
|------|--------|--------|
| `upload.php` | Remote | Async `generate_webp.py` via `nohup &`, dynamic year from `job_date`, cURL connect timeout (5s), dynamic photo_type, dynamic filesize |
| `phototab.php` | Remote | Async `generate_webp.py` via `nohup &`, dynamic year (scheduler web upload path) |
| `generate_webp.py` | Remote | **New file** - Python/Pillow WebP converter for background execution |
| `upload_thumb_generator.py` | Local | **New file** - Background Python thumbnail generator (200x200 + 800px mid) |
| `uploadlocallat_kuldeep.php` | Local | Returns JSON immediately, triggers background Python thumbnails instead of inline WebP |

## Folder Structure

```
ENHANCEMENTS/BACKGROUND_WEBP/
+-- README.md          <- This file
+-- NEW/               <- Post-enhancement files
|   +-- upload.php
|   +-- phototab.php
|   +-- generate_webp.py          (new file - no ORIGINAL)
|   +-- upload_thumb_generator.py (new file - no ORIGINAL)
|   +-- uploadlocallat_kuldeep.php
+-- ORIGINAL/          <- Pre-enhancement files
    +-- upload.php
    +-- phototab.php
    +-- uploadlocallat_kuldeep.php
```

## Reconstruction Quality

| File | ORIGINAL | NEW |
|------|----------|-----|
| `upload.php` | **Exact** - `upload.php.bak.pre_webp_removal.20260204` (backup taken right before WebP changes started) | **Approximate** - `upload.php.bak.pre_async_webp.20260204` (state before final async WebP iteration; includes earlier iterations but not the final async nohup approach) |
| `phototab.php` | **Exact** - `phototab.php.bak.pre_webp_removal.20260204` | **Approximate** - current `phototab.php` (may include minor subsequent changes from Feb 5) |
| `generate_webp.py` | N/A (new file) | **Exact** - current version, unchanged since creation |
| `upload_thumb_generator.py` | N/A (new file) | **Exact** - current version, unchanged since creation |
| `uploadlocallat_kuldeep.php` | **Exact** - `before_async_thumb.20260204` (pre-async-thumbnail backup) | **Approximate** - `async_remote.20260204` (final Feb 4 state after WebP/thumb refactoring) |

**Note on upload.php NEW:** The exact post-async-WebP state of upload.php is not preserved as a standalone backup. It was superseded the next day (Feb 5) by the Async Sync enhancement. The file in NEW/ represents the state just before the final async approach was applied, not after.

## Architecture Change

```
BEFORE:
  Mobile App -> POST base64 image
    1. Decode + save image              (fast)
    2. echo JSON response               (BUFFERED)
    3. cURL to local server             (2-10s BLOCKING - local server generated WebP)
    4. Copy to scheduler/uploads        (fast)
    5. Script ends -> JSON sent          (DELAYED 2-10s)

AFTER:
  Mobile App -> POST base64 image
    1. Decode + save image              (fast)
    2. echo JSON response               (BUFFERED)
    3. cURL to local server             (local returns JSON immediately)
    4. Copy to scheduler/uploads        (fast)
    5. generate_webp.py in BACKGROUND   (non-blocking - nohup &)
    6. Insert meter_files               (fast)
    7. Script ends -> JSON sent          (FAST)
       ... WebP appears 1-3s later      (background)
```

## Key Fixes Included

| Fix | Before | After |
|-----|--------|-------|
| Year references | Hardcoded "2025" | Dynamic from `job_date` |
| Photo type in filename | Hardcoded "-S" | Dynamic `$photo_type` |
| File size in DB | Hardcoded "121" | Dynamic `filesize()` |
| cURL timeout | None (hangs if local server down) | `CURLOPT_CONNECTTIMEOUT` = 5s |
| SQL protection | Unprotected | `intval()` + `mysqli_real_escape_string()` |

## Rollback

```bash
# Remote upload.php (restores synchronous cURL with inline processing)
scp -i /root/.ssh/aei_remote.pem ORIGINAL/upload.php \
   Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/upload.php

# Remote phototab.php
scp -i /root/.ssh/aei_remote.pem ORIGINAL/phototab.php \
   Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/controllers/phototab.php

# Local uploadlocallat_kuldeep.php (restores inline WebP generation)
cp ORIGINAL/uploadlocallat_kuldeep.php /var/www/html/upload/uploadlocallat_kuldeep.php

# Note: generate_webp.py and upload_thumb_generator.py can remain on disk - they're
# only invoked if the calling scripts reference them via nohup
```

## Full Documentation

See `../CUSTOMER_ID_LOOKUP/REMOTE_UPLOAD_CHANGES.md` for complete change timeline, all iterations, and backup locations.
