<?php
header('Content-Type: application/json');

// Get JSON input
$data = json_decode(file_get_contents("php://input"), true);
	
// Validate input
if (!isset($data['auth_token'], $data['file_name'], $data['image_data'],$data['job_id'])) {
    //http_response_code(400);
    echo json_encode(array("status" => "error", "message" => "Missing fields"));
    exit;
}


// Optional: Verify token
if ($data['auth_token'] !== 'aei@89806849') {
   // http_response_code(403);
    echo json_encode(array("status" => "error", "message" => "Invalid token"));
    exit;
}

// Decode base64 image
$imageData = base64_decode($data['image_data']);
if ($imageData === false) {
   // http_response_code(400);
    echo json_encode(array("status" => "error", "message" => "Invalid base64"));
    exit;
}
$sdb=mysqli_connect("localhost","schedular","M1gif9!6","mandhdesign_schedular");
// Connect to database and get job/customer details
$query = "SELECT js.customer_id, cs.first_name, cs.last_name, js.job_date, jt.intials, js.job_pid
          FROM jobs js
          LEFT JOIN customers cs ON js.customer_id = cs.id
          LEFT JOIN job_types jt ON js.job_type_id = jt.id
          WHERE js.id = " . intval($data['job_id']);
$result = mysqli_query($sdb, $query);
$row = mysqli_fetch_assoc($result);
$customer_id = $row['customer_id'];
$job_date_t = $row['job_date'];
$job_date = date("m-d-Y", strtotime($row['job_date']));
$folder_location = $row['last_name'] . $row['first_name'] . "-" . $row['intials'] . "-" . $job_date;
$customer_name = $row['last_name'] . ", " . $row['first_name'];
$job_type_text = $row['intials'];
$first_name = $row['first_name'];
$last_name = $row['last_name'];
$indexname = substr($customer_name, 0, 1);
// Save image

 if($job_type_text=="PM" || $job_type_text=="WM" || $job_type_text=="AS"   || $job_type_text=="RPM" || $job_type_text=="GCPM" ){
 $photo_type='S';
}else{
$photo_type='I';
}
$uploadDir = __DIR__ . '/uploads/';
  $uploadDir='/mnt/dropbox/2025 Customers/'.$indexname;
 
if (!is_dir($uploadDir)) {
              mkdir($uploadDir, 0777, true);
           }

		   $uploadDir_customer=$uploadDir.'/'.$customer_name;
		    if (!is_dir($uploadDir_customer)) {
              mkdir($uploadDir_customer, 0777, true);
           }

		   $uploadDir_customer_survey=$uploadDir.'/'.$customer_name."/Survey";
		    if (!is_dir($uploadDir_customer_survey)) {
              mkdir($uploadDir_customer_survey, 0777, true);
           }

		    $uploadDir_customer_install=$uploadDir.'/'.$customer_name."/Installation";
		    if (!is_dir($uploadDir_customer_install)) {
              mkdir($uploadDir_customer_install, 0777, true);
           }
		   
		   if($photo_type=="I"){
              $final_folder=$uploadDir_customer_install."/".$customer_name.", ".$job_type_text."-I, ".$job_date.'/';	
			  if (!is_dir($final_folder)) {
                mkdir($final_folder, 0777, true);
           }
              copy($filePath , $final_folder) ;
		   } else {
				  $final_folder=$uploadDir_customer_survey."/".$customer_name.", ".$job_type_text."-S, ".$job_date.'/';	
			  if (!is_dir($final_folder)) {
                mkdir($final_folder, 0777, true);
           }
		   }

$filePath = $final_folder . basename($data['file_name']);

if (file_put_contents($filePath, $imageData)) {
    echo json_encode(array("success"=> 1,"status" => "ok", "message" => "Image uploaded", "path" => basename($filePath)));
} else {
    //http_response_code(500);
    echo json_encode(array("status" => "error", "message" => "Failed to save image"));
}

$remoteUploadUrl = 'https://upload.aeihawaii.com/uploadlocallat_kuldeep.php';
$remoteAuthToken = 'remote_token';

$filePath = realpath($filePath);
if (!$filePath || !is_readable($filePath)) {
    die("Local file not found/readable");
}
$job_id = $row['job_pid'];
// Build fields (PHP 5.3 style upload)
$postFields = array(
    'auth_token'  => $remoteAuthToken,
    'file'        => '@' . $filePath, // classic style for PHP 5.3
    'file_name'   => basename($filePath),
    'job_id'      => $job_id,
    'customer_id' => $customer_id,    // Added: enables direct customer lookup on local server
    'job_type'    => $job_type_text,
    'last_name'   => $last_name,
    'first_name'  => $first_name,
    'job_date'    => $job_date_t,
    'photo_type'  => $photo_type,
);

$ch = curl_init($remoteUploadUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
// Helpful: follow redirects and show headers for debugging
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_HEADER, true);

// Reduce WAF false positives
$headers = array(
    'Expect:',                           // disable 100-continue
    'X-Requested-With: XMLHttpRequest',  // often whitelisted by WAFs
    // 'Content-Type: multipart/form-data' // usually let cURL set this
);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

// Set a friendly UA
curl_setopt($ch, CURLOPT_USERAGENT, 'AEI-Uploader/1.0');

// (Diagnostics only � remove once verified)
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

$responseWithHeaders = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$err = curl_error($ch);
curl_close($ch);

// Copy original to scheduler uploads
$filename_insert = basename($data['file_name']);
$filePath_u = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/' . $filename_insert;
copy($filePath, $filePath_u);

// Generate WebP locally using Python/Pillow (PHP 5.3 has no WebP GD support)
$customer_namewebp = $last_name . $first_name;
$randomId = rand(100000, 999999);
$webpfilename = $customer_namewebp . "" . $job_type_text . "-S" . $job_date . "_IMG" . $randomId . '.webp';
$webp_dest = $final_folder_webp . $customer_namewebp . "" . $job_type_text . "-" . $photo_type . $job_date . "_IMG" . $randomId . '.webp';

$generateScript = __DIR__ . '/generate_webp.py';
$cmd = 'python3 ' . escapeshellarg($generateScript) . ' ' . escapeshellarg($filePath) . ' ' . escapeshellarg($webp_dest) . ' 80 2>&1';
exec($cmd, $webp_output, $webp_return);

if ($webp_return === 0 && file_exists($webp_dest)) {
    // Copy to scheduler/uploads/webp/ for scheduler UI
    $scheduler_webp_dir = '/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/webp/';
    if (!is_dir($scheduler_webp_dir)) {
        mkdir($scheduler_webp_dir, 0777, true);
    }
    copy($webp_dest, $scheduler_webp_dir . $webpfilename);
} else {
    error_log("WebP generation failed for: " . $filePath . " - " . implode("\n", $webp_output));
    $webpfilename = '';
}

// Insert file record into database
$sql_insert = 'Insert into meter_files(job_id,unique_filename,original_filename,file_size,file_type,webpfilename,created) values(' . intval($job_id) . ',"' . mysqli_real_escape_string($sdb, $filename_insert) . '","' . mysqli_real_escape_string($sdb, $filename_insert) . '","' . filesize($filePath) . '","99","' . mysqli_real_escape_string($sdb, $webpfilename) . '", "' . date("Y-m-d, h:i:s") . '")';
mysqli_query($sdb, $sql_insert);
?>
