# Enhancement: Customer ID Lookup

**Date:** 2026-01-30
**Status:** Deployed
**Reconstruction:** Retroactive (created 2026-02-05 from available backups)

## Purpose

Added `customer_id` to the remote-to-local photo sync payload, enabling the local server to use database-driven customer folder lookups instead of unreliable name matching. Also added SQL injection protection (`intval()`) to the remote upload query.

## Files Changed

| File | Server | Change |
|------|--------|--------|
| `upload.php` | Remote | Added `js.customer_id` to SELECT, added `intval()`, added `customer_id` to POST fields |
| `uploadlocallat_kuldeep.php` | Local | Added `customer_id` acceptance, `unified_customers` DB lookup, year-aware folder selection, name fallback |

## Folder Structure

```
ENHANCEMENTS/CUSTOMER_ID_LOOKUP/
+-- README.md          <- This file
+-- NEW/               <- Post-enhancement files
|   +-- upload.php
|   +-- uploadlocallat_kuldeep.php
+-- ORIGINAL/          <- Pre-enhancement files
    +-- upload.php
    +-- uploadlocallat_kuldeep.php
```

## Reconstruction Quality

| File | ORIGINAL | NEW |
|------|----------|-----|
| `upload.php` | **Exact** - `upload.php.original.20260130` (pre-any-changes) | **Approximate** - `upload.php.pre_webp_fix.20260204` (post-customer-id, may include minor fixes made between Jan 30 and Feb 4) |
| `uploadlocallat_kuldeep.php` | **Exact** - `uploadlocallat_kuldeep.php.bak.20260130` (Jan 30 baseline) | **Approximate** - `uploadlocallat_kuldeep.php.backup.20260204` (Feb 4 09:19 — earliest post-customer-id backup, may include additional changes) |

## Key Changes

### Remote upload.php

**Query (before):**
```php
$query = "SELECT cs.first_name,cs.last_name,js.job_date,jt.intials,js.job_pid FROM jobs js ...
WHERE js.id=".$data['job_id'];
```

**Query (after):**
```php
$query = "SELECT js.customer_id, cs.first_name, cs.last_name, js.job_date, jt.intials, js.job_pid
          FROM jobs js ...
          WHERE js.id = " . intval($data['job_id']);
```

### Local uploadlocallat_kuldeep.php

- Accepts new `customer_id` POST field
- Looks up `unified_customers.remote_customer_id` to find local folder path
- Uses `job_date` year for year-aware folder selection (e.g., `2026 Customers/`)
- Falls back to name matching if customer_id lookup fails
- Auto-creates customer folders + DB records when not found

## Rollback

```bash
# Remote server
scp -i /root/.ssh/aei_remote.pem ORIGINAL/upload.php \
   Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/upload.php

# Local server
cp ORIGINAL/uploadlocallat_kuldeep.php /var/www/html/upload/uploadlocallat_kuldeep.php
```

## Full Documentation

See `REMOTE_UPLOAD_CHANGES.md` (in this folder) for complete change details and deployment history.
