<?php
header('Content-Type: application/json');

// Read JSON body (assoc array)
$raw = file_get_contents('php://input');
$input = json_decode($raw, true);

if (!$input) {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid JSON body'));
    exit;
}

if (!isset($input['auth_token']) || !isset($input['job_id'])) {
    echo json_encode(array('status' => 'error', 'message' => 'Missing fields: auth_token, job_id'));
    exit;
}

// Same token as upload.php
if ($input['auth_token'] !== 'aei@89806849') {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid token'));
    exit;
}

// Collect input file references from multiple possible keys
$files = array();
if (isset($input['paths']) && is_array($input['paths'])) {
    $files = $input['paths']; // array of URLs (or strings)
} else if (isset($input['files']) && is_array($input['files'])) {
    $files = $input['files']; // array of names
} else if (isset($input['file_name']) && is_string($input['file_name']) && $input['file_name'] !== '') {
    $files = array($input['file_name']); // single string
} else {
    echo json_encode(array('status' => 'error', 'message' => 'Provide paths[], files[] or file_name'));
    exit;
}

// Sanitize job_id (folder name)
$jobId = trim((string)$input['job_id']);
if ($jobId === '' || preg_match('/[^\w\-]/', $jobId)) {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid job_id'));
    exit;
}


// Sanitize and validate input
//$jobId = isset($_GET['job_id']) ? basename($_GET['job_id']) : '';

$sdb=mysqli_connect("localhost","schedular","M1gif9!6","mandhdesign_schedular");
$query = "SELECT cs.first_name,cs.last_name,js.job_date,jt.intials FROM jobs js LEFT JOIN customers cs ON js.customer_id=cs.id LEFT JOIN job_types jt ON js.job_type_id=jt.id
WHERE js.id=".$jobId;
$result = mysqli_query($sdb, $query);
$row = mysqli_fetch_assoc($result);
$job_date=date("m-d-Y",strtotime($row['job_date']));
$folder_location=$row['last_name'].$row['first_name']."-".$row['intials']."-".$job_date;
$job_type_text=$row['intials'];
$images = array();
$customername=$row['last_name'].", ".$row['first_name'];

$customer_name=$customername;
$indexname = substr($customer_name, 0, 1);
if($job_type_text=="PM" || $job_type_text=="WM" || $job_type_text=="AS"   || $job_type_text=="RPM" || $job_type_text=="GCPM" ){
 $photo_type='Survey';
 $photo_s='S';
}else{
$photo_type='Installation';
$photo_s='I';
}
  $baseDir = '/mnt/dropbox/2025 Customers/'.$indexname.'/'.$customername.'/'.$photo_type."/".$customer_name.", ".$job_type_text."-".$photo_s.', '.$job_date.'/webp/';

//$baseDir = '/mnt/aeiserver/' . $jobId . '/';
if (!is_dir($baseDir)) {
    echo json_encode(array('status' => 'error', 'message' => 'Job folder not found', 'job_id' => $jobId));
    exit;
}

// --- optional logging with fwrite() ---
$logFile = __DIR__ . '/delete_log.txt';
$logHandle = fopen($logFile, 'a');
if (!$logHandle) {
    $logHandle = false; // continue silently if logging fails
}

// Helper: extract a safe filename from a URL or raw string
function get_safe_name_from_path($p) {
    if (!is_string($p) || $p === '') return '';

    // Try to parse as URL
    $u = @parse_url($p);
    if (is_array($u)) {
        // 1) Prefer ?img=... if present
        if (isset($u['query'])) {
            $qs = array();
            parse_str($u['query'], $qs);
            if (isset($qs['img']) && is_string($qs['img']) && $qs['img'] !== '') {
                $candidate = urldecode($qs['img']);
                return basename($candidate); // strip any path
            }
        }
        // 2) Fallback to URL path's basename
        if (isset($u['path'])) {
            $candidate = urldecode($u['path']);
            $name = basename($candidate);
            if ($name !== '' && $name !== '/' && $name !== '.' && $name !== '..') {
                return $name;
            }
        }
    }

    // Not a URL or parse failed; treat input as a filename
    return basename(urldecode($p));
}

$deleted = array();
$errors  = array();

foreach ($files as $ref) {
    $safeName = get_safe_name_from_path($ref);

    // Validate extracted filename
    if ($safeName === '' || preg_match('/[\/\\\\]/', $safeName)) {
        $errors[] = array('input' => $ref, 'error' => 'Invalid or empty filename');
        continue;
    }

    $fullPath = $baseDir . $safeName;

    if (!file_exists($fullPath)) {
        $errors[] = array('file' => $safeName, 'error' => 'Not found');
        continue;
    }

    if (@unlink($fullPath)) {
        $deleted[] = $safeName;

        // Optional: also delete a matching .webp thumbnail (uncomment if needed)
        // $thumb = $baseDir . pathinfo($safeName, PATHINFO_FILENAME) . '.webp';
        // if (file_exists($thumb)) { @unlink($thumb); }

        // Log success
        if ($logHandle) {
            $line = date('Y-m-d H:i:s') . " | Deleted: " . $safeName . " | JobID: " . $jobId . "\n";
            fwrite($logHandle, $line);
        }
    } else {
        $errors[] = array('file' => $safeName, 'error' => 'Failed to delete');
    }
}

if ($logHandle) fclose($logHandle);

$status = 'ok';
if (!empty($errors) && !empty($deleted)) $status = 'partial';
if (!empty($errors) && empty($deleted))  $status = 'error';

echo json_encode(array(
    'status'  => $status,
    'job_id'  => $jobId,
    'deleted' => $deleted,
    'errors'  => $errors
));
