# Original Baseline — Pre-Enhancement State

**Date Captured:** 2026-01-30 (project inception)
**Reconstruction:** Retroactive (created 2026-02-05 from backups and unchanged files)

## Purpose

Preserves the original state of all project files as they existed before any enhancements were applied. This is the starting point from which all subsequent enhancements built.

## Directory Structure

```
ENHANCEMENTS/ORIGINAL_BASELINE/
+-- README.md
+-- remote_photoapi/           <- /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/
|   +-- upload.php                 (mobile app upload handler)
|   +-- getimagelisting.php        (mobile app image listing)
|   +-- fetch_image.php            (mobile app image viewer)
|   +-- delete.php                 (photo deletion)
|   +-- delete_image.php           (single image deletion)
|   +-- getimagelistingcnt.php     (image count endpoint)
|   +-- getimagelistingm.php       (legacy listing variant)
|   +-- getimagelistingnew.php     (legacy listing variant)
+-- remote_controllers/        <- /var/www/vhosts/aeihawaii.com/httpdocs/controllers/
|   +-- phototab.php               (scheduler web photo tab)
|   +-- loginapi.php               (mobile app login API)
|   +-- preupload.php              (premeasure photo upload)
+-- local/                     <- /var/www/html/upload/ (upload.aeihawaii.com)
    +-- uploadlocallat_kuldeep.php (local server file receiver)
```

## File Provenance

### Exact Originals (verified pre-enhancement state)

| File | Source Backup | Notes |
|------|--------------|-------|
| `remote_photoapi/upload.php` | `upload.php.original.20260130` | The remote upload.php before ANY changes. Has synchronous cURL to local server, no customer_id, hardcoded values, no SQL injection protection. |
| `local/uploadlocallat_kuldeep.php` | `uploadlocallat_kuldeep.php.bak.20260130` | The local receiver before customer_id lookup was added. Name-matching only, inline WebP generation. |
| `remote_controllers/phototab.php` | `phototab.php.bak.pre_webp_removal.20260204` | Not modified by CUSTOMER_ID_LOOKUP (first enhancement), so this is the original state. Has original S3-based WebP generation. |

### Unchanged Files (never modified by any enhancement)

| File | Date | Notes |
|------|------|-------|
| `remote_photoapi/delete.php` | Jan 30, 2026 | Still in original state |
| `remote_photoapi/delete_image.php` | Jan 30, 2026 | Still in original state |
| `remote_photoapi/getimagelistingcnt.php` | Jan 30, 2026 | Still in original state |
| `remote_photoapi/getimagelistingm.php` | Jan 30, 2026 | Legacy variant, still in original state |
| `remote_photoapi/getimagelistingnew.php` | Jan 30, 2026 | Legacy variant, still in original state |
| `remote_controllers/loginapi.php` | Jan 30, 2026 | Still in original state |
| `remote_controllers/preupload.php` | Jan 30, 2026 | Still in original state |

### Approximate Originals (true original not preserved)

| File | Source Used | What's Different |
|------|------------|-----------------|
| `remote_photoapi/getimagelisting.php` | PHOTO_FOLDER_PATH ORIGINAL (4,386B) | Has dynamic year from BACKGROUND_WEBP enhancement; true original had hardcoded "2025". Original backup (`getimagelisting.php.bak.pre_year_fix.20260204`) exists only on the remote server, not in the project. |
| `remote_photoapi/fetch_image.php` | PHOTO_FOLDER_PATH ORIGINAL (2,140B) | Same — has dynamic year; true original had hardcoded "2025". Original backup exists only on the remote server. |

## Files NOT Included

These project files are not in the baseline because they either haven't changed or are supporting infrastructure:

| Location | Files | Reason |
|----------|-------|--------|
| `REMOTE/models/` | `preupload_model.php` | Unchanged, supporting file |
| `REMOTE/views/` | `photos_index.php`, `Confirm_delete_pic.php`, `job_photos.php`, `job_photos_installer.php`, `download_photo.php`, `form.php`, `gallery_view.php` | Unchanged view templates |
| `REMOTE/scaws/` | `aws.phar` (12MB), `test.php` | AWS SDK binary + test file, unchanged |

## Files That Did Not Exist Yet

These files were created by subsequent enhancements and have no original baseline:

| File | Created By | Enhancement |
|------|-----------|-------------|
| `generate_webp.py` | BACKGROUND_WEBP | Python/Pillow WebP converter (remote) |
| `upload_thumb_generator.py` | BACKGROUND_WEBP | Background thumbnail generator (local) |
| `sync_to_local.py` | ASYNC_SYNC | Background Python sync script (remote) |
| `process_retry_queue.py` | ASYNC_SYNC | Cron-driven retry processor (remote) |

## Enhancement Chronology

```
ORIGINAL_BASELINE (Jan 30)
  |
  +-- CUSTOMER_ID_LOOKUP (Jan 30) -- customer_id in sync, SQL protection, DB lookup
  |
  +-- BACKGROUND_WEBP (Feb 4) -- async WebP, dynamic year, cURL timeout, background thumbs
  |
  +-- ASYNC_SYNC (Feb 5 AM) -- background sync_to_local.py, retry queue, inline retry
  |
  +-- CHUNKED_UPLOAD (Feb 5) -- ARCHIVED (reverted, moved to ARCHIVE/CHUNKED_UPLOAD/)
  |
  +-- PHOTO_FOLDER_PATH (Feb 5 PM) -- persist folder path in meter_files for job resilience
```

## Recovering Missing Originals

The true originals of `getimagelisting.php` and `fetch_image.php` (with hardcoded "2025") may still exist on the remote server as `.bak.pre_year_fix.20260204` backups:

```bash
# Check if originals exist on remote server
ssh -i /root/.ssh/aei_remote.pem Julian@18.225.0.90 "
  ls -la /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting.php.bak.pre_year_fix.20260204
  ls -la /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/fetch_image.php.bak.pre_year_fix.20260204
"

# If they exist, copy them to this baseline
scp -i /root/.ssh/aei_remote.pem \
  Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting.php.bak.pre_year_fix.20260204 \
  remote_photoapi/getimagelisting.php

scp -i /root/.ssh/aei_remote.pem \
  Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/fetch_image.php.bak.pre_year_fix.20260204 \
  remote_photoapi/fetch_image.php
```
