# Enhancement Log — AEI Photo System

> Master tracking document for all enhancements to the AEI Photo Upload & Sync pipeline.
> Enhancements are numbered chronologically: `ENH-XXX_NAME`. Future/unscheduled items use `ENH-FXX_NAME` inside `FUTURE/`.

---

## Status Definitions

| Status | Meaning |
|--------|---------|
| **Reference** | Baseline snapshot, not a code change |
| **Deployed** | Live on both remote (18.225.0.90) and local (upload.aeihawaii.com) servers |
| **Implemented** | Code written and tested but not yet fully deployed or activated |
| **Proposed** | Design documented, code changes identified, not yet implemented |
| **Undeployed** | Was deployed but reverted; code preserved in NEW/ for re-deployment |
| **Planning** | Research/analysis in progress, design not finalized |
| **Planned** | Scheduled for future implementation, design outlined |

---

## Summary Table

| # | Name | Status | Date | Risk | Depends On |
|---|------|--------|------|------|------------|
| PHOTO-000 | Original Baseline | Reference | 2026-01-30 | — | — |
| PHOTO-001 | Customer ID Lookup | Deployed | 2026-01-30 | Low | — |
| PHOTO-002 | Background WebP | Deployed | 2026-02-04 | Low | PHOTO-001 |
| PHOTO-003 | Async Sync | rev1 Deployed, rev2 Pending | 2026-02-05/09 | Medium | PHOTO-002 |
| PHOTO-004 | Stuck Process Detection | Implemented | 2026-02-05 | Low | PHOTO-003 |
| PHOTO-005 | Photo Folder Path | Deployed | 2026-02-05 | Low | PHOTO-001, PHOTO-002 |
| PHOTO-006 | Survey Photos | Deployed | 2026-02-05 | Low | — |
| PHOTO-007 | Photo Listing Fixes | Proposed | 2026-02-06 | Medium | PHOTO-005 |
| PHOTO-008 | Cross-Year Photo Listing | Proposed | 2026-02-05 | Medium | PHOTO-001, PHOTO-005 |
| PHOTO-009 | Unified Storage | **Deployed** | 2026-02-17 | **High** | PHOTO-001–005, PHOTO-008 |
| PHOTO-010 | Customer Feedback Fix | **Moved** → `dev_scheduler/ENHANCEMENTS/PHOTO-019_customer_feedback_fix` | 2026-02-07 | Medium | — |
| PHOTO-011 | Reconciliation + Sync Source Switch | Deployed | 2026-02-09 | Low | PHOTO-003, PHOTO-009 (partial) |
| PHOTO-012 | Mobile Photo Listing Metadata Fix | **Deployed** | 2026-02-18 | Low | PHOTO-009 |
| PHOTO-013 | Security Hardening | Proposed | 2026-02-18 | Medium | — |
| PHOTO-014 | Login API Bug Fixes | **Deployed** | 2026-02-18 | Low | — |
| PHOTO-015 | Docs Tab Expansion | **Deployed** | 2026-02-19 | Low | PHOTO-014 |
| PHOTO-016 | Survey Photos in Mobile (Optimized) | **Deployed** | 2026-02-19 | Low | PHOTO-006, PHOTO-017 |
| PHOTO-017 | Derivatives-Only Remote + Staging | **Deployed** | 2026-02-19 | Medium | PHOTO-009, PHOTO-011 |
| PHOTO-018 | Background Upload Queue | **Planning** | 2026-02-19 | Medium | PHOTO-017 |
| PHOTO-019 | Local Photo Tracking Table | **Implemented** | 2026-02-19 | Low | — |
| PHOTO-020 | Gallery UX Improvements | **Deployed** | 2026-02-20 | Low | PHOTO-017 |
| PHOTO-021 | Photo Resolution: Staging Direct, DB-Only, API Fix | **Deployed** | 2026-02-21 | Low | PHOTO-017, PHOTO-009 |
| PHOTO-022 | Remove Hi-Res Tier | **Implemented** | 2026-02-22 | Low | PHOTO-017, PHOTO-021 |
| PHOTO-023 | WebP Resolution Bump + Verified Staging Cleanup | **Implemented** | 2026-02-22 | Low | PHOTO-022 |
| PHOTO-024 | Remove uploads/ Root Dependency | **Deployed** | 2026-02-23 | Low | PHOTO-023 |
| PHOTO-025 | Remove S3/AWS Dependency | **Deployed** | 2026-02-23 | Low | PHOTO-009, PHOTO-017 |
| PHOTO-026 | Chunked Resumable Uploads | **Planning** | 2026-02-23 | Medium | PHOTO-018, PHOTO-017 |
| ENH-F01 | Folder Year Sync | Planned (deprioritized) | — | Low | PHOTO-005 |
| ENH-F02 | API Unification | Planned | 2026-02-18 | Medium | PHOTO-012, PHOTO-013 |

---

## Dependency Graph

```
PHOTO-000 (Baseline)
  │
  ├── PHOTO-001 (Customer ID Lookup)
  │     ├── PHOTO-002 (Background WebP)
  │     │     ├── PHOTO-003 (Async Sync)
  │     │     │     ├── PHOTO-004 (Stuck Process Detection)
  │     │     │     └── PHOTO-011 (Reconciliation)
  │     │     └── PHOTO-005 (Photo Folder Path)
  │     │           ├── PHOTO-007 (Photo Listing Fixes) [partially superseded by PHOTO-009]
  │     │           │     └── PHOTO-008 (Cross-Year Listing) [resolved for scheduler by PHOTO-009]
  │     │           │           └── PHOTO-009 (Unified Storage)
  │     │           │                 └── PHOTO-012 (Mobile Listing Fix)
  │     │           │                       └── ENH-F02 (API Unification) [also depends on PHOTO-013]
  │     │           └── ENH-F01 (Folder Year Sync) [deprioritized — folder_path deprecated by PHOTO-009]
  │     └── PHOTO-008 (Cross-Year Listing) [also depends on PHOTO-005]
  │
  ├── PHOTO-006 (Survey Photos) [independent — local only]
  │     └── PHOTO-016 (Survey Photos in Mobile — Optimized) [DEPLOYED — pre-cached thumbs + proxy with disk cache]
  │
  ├── PHOTO-017 (Remote Thumbnails) [depends on PHOTO-009, PHOTO-011]
  │     ├── PHOTO-018 (Background Upload Queue) [Phase 2 modifies upload.php]
  │     ├── PHOTO-020 (Gallery UX) [photos_index.php + lightbox.js]
  │     ├── PHOTO-021 (Photo Resolution) [staging direct, DB-only listing, API fix] ← DEPLOYED
  │     │     └── PHOTO-022 (Remove Hi-Res Tier) [2-tier derivatives, simplified pipeline]
  │     │           └── PHOTO-023 (WebP Bump + Verified Staging Cleanup)
  │     │                 └── PHOTO-024 (Remove uploads/ Root Dependency) ← DEPLOYED
  │     └── PHOTO-025 (Remove S3/AWS Dependency) [also depends on PHOTO-009] ← DEPLOYED
  │
  ├── PHOTO-010 (Customer Feedback Fix) [MOVED to dev_scheduler/ENHANCEMENTS/SCH-019]
  │
  ├── PHOTO-013 (Security Hardening) [independent — loginapi, loginapinew, fetch_image1]
  │     └── ENH-F02 (API Unification) [also depends on PHOTO-012]
  │
  ├── PHOTO-014 (loginapi Bug Fixes) [independent — loginapi only]
  │     └── PHOTO-015 (Docs Tab Expansion) [loginapinew — multi-table docs]
  │
  └── PHOTO-015 also fixes bugs in PHOTO-014's loginapinew.php
```

---

## Per-Enhancement Details

### PHOTO-000: Original Baseline
- **Directory:** `PHOTO-000_ORIGINAL_BASELINE/`
- **Description:** Preserves pre-enhancement state of all project files as of 2026-01-30.
- **Files:** Snapshots of upload.php, getimagelisting.php, fetch_image.php, delete.php, delete_image.php, getimagelistingcnt.php, getimagelistingm.php, getimagelistingnew.php, phototab.php, loginapi.php, preupload.php, uploadlocallat_kuldeep.php
- **Notes:** Reference only. True originals may also exist on remote as `.bak.pre_year_fix.20260204` backups.

---

### PHOTO-001: Customer ID Lookup
- **Directory:** `PHOTO-001_CUSTOMER_ID_LOOKUP/`
- **Description:** Added `customer_id` to remote-to-local sync payload. Local server uses DB-driven folder lookup (unified_customers table) instead of unreliable name matching. Added SQL injection protection via `intval()`.
- **Files Modified:**
  - `REMOTE/photoapi/upload.php` — Added customer_id to SELECT + POST fields, intval() on job_id
  - `LOCAL/uploadlocallat_kuldeep.php` — DB lookup with year-aware fallback
- **Dependencies:** Requires `unified_customers` table on local server
- **Rollback:** SCP from `ORIGINAL/` directory

---

### PHOTO-002: Background WebP Generation
- **Directory:** `PHOTO-002_BACKGROUND_WEBP/`
- **Description:** Replaced synchronous WebP generation with async `generate_webp.py` via nohup. Fixed hardcoded "2025" year, added cURL timeout (5s), corrected photo_type in filenames, added dynamic filesize to DB.
- **Files Modified:**
  - `REMOTE/photoapi/upload.php` — Async generate_webp.py, dynamic year, cURL timeout
  - `REMOTE/controllers/phototab.php` — Async generate_webp.py, dynamic year
  - `REMOTE/photoapi/generate_webp.py` — **NEW** Python/Pillow WebP converter
  - `LOCAL/upload_thumb_generator.py` — **NEW** Background thumbnail generator (200x200 + 800px mid)
  - `LOCAL/uploadlocallat_kuldeep.php` — Returns JSON immediately, triggers background thumbnails
- **Dependencies:** PHOTO-001
- **Notes:** Went through 5 iterations on Feb 4. Mobile app response time significantly improved.

---

### PHOTO-003: Async Local Server Sync
- **Directory:** `PHOTO-003_ASYNC_SYNC/`
- **Description:** Replaced synchronous cURL calls to local server with background `sync_to_local.py` via nohup. Added store-and-forward retry queue with exponential backoff. Covers **all** upload paths.
- **Rev1 (Deployed 2026-02-05):**
  - `REMOTE/photoapi/upload.php` — Removed sync cURL, added nohup sync_to_local.py
  - `REMOTE/photoapi/sync_to_local.py` — **NEW** Background sync with inline retry (3 attempts, 2/4/8s backoff)
  - `REMOTE/photoapi/process_retry_queue.py` — **NEW** Cron retry processor (15min interval, max 10 retries)
- **Rev2 (Pending 2026-02-09):**
  - `REMOTE/controllers/phototab.php` — Removed sync cURL, added nohup sync_to_local.py
  - `REMOTE/controllers/preupload.php` — Removed sync cURL + broken response-body WebP, added nohup sync_to_local.py + nohup generate_webp.py
- **Dependencies:** PHOTO-002
- **Notes:** Rev1: Mobile response time dropped from 2–10s to ~0.5s. Rev2: Closes critical gap where scheduler uploads had no retry on local server failure. Also fixes preupload WebP hardcoded "-S" bug.

---

### PHOTO-004: Stuck Process Detection
- **Directory:** `PHOTO-004_STUCK_PROCESS_DETECTION/`
- **Description:** Monitoring enhancement for hung background processes (sync_to_local.py, generate_webp.py). Proposes lockfile and wall-clock timeout mechanisms.
- **Files to Modify:**
  - `REMOTE/photoapi/upload.php` — Log PID from exec()
  - `REMOTE/photoapi/sync_to_local.py` — PID/lockfile tracking
  - `REMOTE/photoapi/generate_webp.py` — 120s wall-clock timeout via signal.alarm()
  - `REMOTE/photoapi/process_retry_queue.py` — Stuck item detection, lockfile for cron overlap
- **Dependencies:** PHOTO-003
- **Notes:** Long-term recommendation: managed job queue (Redis+rq, Supervisor, or systemd).

---

### PHOTO-005: Photo Folder Path Persistence
- **Directory:** `PHOTO-005_PHOTO_FOLDER_PATH/`
- **Description:** Stores absolute folder path in `meter_files.folder_path` at upload time. Photos survive job reschedule/unschedule/delete. Also fixes Survey spacing bug.
- **Files Modified:**
  - `REMOTE/photoapi/upload.php` — Add folder_path to INSERT
  - `REMOTE/photoapi/getimagelisting.php` — Use folder_path with fallback to reconstruction
  - `REMOTE/photoapi/fetch_image.php` — Use folder_path with fallback to reconstruction
  - `LOCAL/uploadlocallat_kuldeep.php` — Fix "-S," → "-S, " spacing
- **Database Change:** `ALTER TABLE meter_files ADD COLUMN folder_path VARCHAR(512) DEFAULT NULL AFTER webpfilename;`
- **Dependencies:** PHOTO-001, PHOTO-002

---

### PHOTO-006: Survey Photos API
- **Directory:** `PHOTO-006_SURVEY_PHOTOS/`
- **Description:** New local-server API endpoints for retrieving Survey and Installation photos by customer_id or name search.
- **Files Created:**
  - `LOCAL/get_survey_photos.php` — JSON listing API
  - `LOCAL/serve_photo.php` — Image serving with caching
  - `LOCAL/photo_browser_search.php` — Autocomplete search
  - `LOCAL/test_photo_browser.php` — Visual test page
- **Dependencies:** None (local-only, uses unified_customers + /mnt/dropbox/)
- **API Endpoints:**
  - `GET /get_survey_photos.php?customer_id={id}`
  - `GET /serve_photo.php?path=...`
  - `GET /photo_browser_search.php?term=...`

---

### PHOTO-007: Photo Listing Fixes
- **Directory:** `PHOTO-007_PHOTO_LISTING_FIXES/`
- **Description:** Fixes three root causes of missing photos: hardcoded 2025 year in premeasure upload, WebP filename collisions from weak random IDs, missing folder_path on scheduler-uploaded photos.
- **Files to Modify:**
  - `REMOTE/photoapi/preupload.php` — Dynamic $job_year instead of hardcoded 2025
  - `REMOTE/photoapi/upload.php` — md5(uniqid()) instead of rand() for WebP names
  - `REMOTE/controllers/phototab.php` — Populate folder_path in meter_files INSERT
- **Dependencies:** PHOTO-005
- **Notes:** Customer 7729 case study — 10 photos uploaded, only 7 unique WebP files (3 overwritten by collisions).
- **Update (2026-02-18):** Partially superseded by PHOTO-009 for **scheduler** (getimagelisting.php rewritten). Still relevant for **mobile** via PHOTO-012 (getimagelisting1.php). The preupload.php year fix and WebP collision fix are independent of PHOTO-009.

---

### PHOTO-008: Cross-Year Photo Listing
- **Directory:** `PHOTO-008_CROSS_YEAR_PHOTO_LISTING/`
- **Description:** Enables mobile app to list photos across all related customer jobs spanning multiple years (e.g., premeasure 2025 + installation 2026).
- **Files to Modify:**
  - `REMOTE/photoapi/getimagelisting.php` — Query ALL customer jobs, scan each year folder
  - `REMOTE/photoapi/fetch_image.php` — SQL injection protection, serve images from any related job
- **Dependencies:** PHOTO-001, PHOTO-005
- **Notes:** Backward-compatible — adds job_id, job_type, job_date, photo_type fields to response.
- **Update (2026-02-18):** Resolved for **scheduler** by PHOTO-009 (DB-only query spans all years). Mobile also OK — `getimagelisting1.php` meter_files query uses `job_id IN (...)` across all customer jobs regardless of year.

---

### PHOTO-009: Unified Storage
- **Directory:** `PHOTO-009_UNIFIED_STORAGE/`
- **Status:** **Deployed** (2026-02-17) — Phase 1 + Phase 2 live on remote server
- **Description:** Unifies dual storage (hierarchy `/mnt/dropbox/` + flat `scheduler/uploads/`) onto single DB-driven flat storage. Both mobile and scheduler use `meter_files` table.
- **Files Rewritten:**
  - `photoapi/getimagelisting.php` — DB-only query on `meter_files` instead of `scandir()`
  - `photoapi/fetch_image.php` — Serves from `scheduler/uploads/webp/` via DB lookup
  - `photoapi/delete.php` — Deletes from flat storage + `meter_files` DB row (fixes hardcoded 2025 bug)
- **Files Modified:**
  - `photoapi/upload.php` — Removed /mnt/dropbox/ hierarchy writes, WebP direct to flat, fixed undefined vars
  - `controllers/phototab.php` `dropImageUpload()` — Removed hierarchy writes, WebP direct to flat
  - `controllers/preupload.php` `submit()` — Removed hierarchy writes, WebP direct to flat, fixed hardcoded -S
- **Previously Deployed (PHOTO-011):** sync_to_local.py source switch, process_retry_queue.py flat paths
- **Dependencies:** PHOTO-001 through PHOTO-005, PHOTO-008
- **Risk:** **HIGH** — affects all photo operations
- **Deployment Plan:**
  1. Phase 1 (Zero Downtime): Rewrite reads to DB-only — **Implemented**
  2. Phase 2 (Reduces Redundancy): Stop hierarchy writes — **Implemented**
  3. Phase 3 (Cleanup): Delete `/mnt/dropbox/` hierarchy after soak period — Future

---

### PHOTO-010: Customer Feedback Fix — MOVED
- **Moved to:** `dev_scheduler/ENHANCEMENTS/SCH-019_customer_feedback_fix/`
- **Reason:** Not photo-related. Only photo pipeline enhancements belong in AEI_PHOTO_API_PROJECT.

---

### PHOTO-011: Reconciliation + Sync Source Switch
- **Directory:** `PHOTO-011_RECONCILIATION/`
- **Description:** (1) Daily reconciliation that cross-references `meter_files` (last 7 days) on remote against actual files on local server. Sends batch check requests to new `check_photos.php` endpoint, re-queues any missing photos via existing retry queue. (2) Switched all sync operations to read from `scheduler/uploads/` flat storage instead of `/mnt/dropbox/` hierarchy (PHOTO-009 Phase 2 steps 4-5).
- **Files Created:**
  - `LOCAL/check_photos.php` — Batch file existence check endpoint (POST, JSON, max 200/batch)
- **Files Modified:**
  - `REMOTE/photoapi/upload.php` — `$filePath` → `$filePath_u` in sync_to_local.py call (line 142)
  - `REMOTE/photoapi/process_retry_queue.py` — Added reconciliation functions + `SCHEDULER_UPLOADS` constant; `detect_stuck_items()` and `reconcile_local_sync()` use flat paths
- **Dependencies:** PHOTO-003 (Async Sync — retry queue infrastructure), PHOTO-009 (partial — implements Phase 2 steps 4-5)
- **Notes:** Piggybacks on existing 15-min cron with daily marker file guard. ~4-14 HTTP requests per day, well under fail2ban thresholds. No new cron entry needed. QA 33/33 passed after deployment.

---

### PHOTO-017: Derivatives-Only Remote Store + Staging + Mobile Thumb Integration
- **Directory:** `PHOTO-017_REMOTE_THUMBNAILS/`
- **Status:** **Deployed** (2026-02-19)
- **Description:** Remote becomes a derivatives-only store. Both mobile and scheduler save full-size originals to `staging/` (temporary), generate WebP derivatives from that full-size source (1024px Q80 standard + 200x200 Q70 thumb + 2048px Q82 hi-res), sync full-size to local for archival, clean staging after 7 days. No new JPEGs written to `uploads/` root (mobile) or WebP derived from post-resize source (scheduler). CI resize kept for legacy compat. Consistent Pillow/LANCZOS quality across both flows. Path to deleting 204GB of legacy JPEGs once backfill + verification complete.
- **Mobile App Integration (2026-02-19):** Rewrote `getimagelistingnew.php` to DB-based (meter_files), added `thumbUrl` to `loginapinew.php customerphotostabstatenew()`, and updated 4 Flutter files to use thumb URLs for grids (~5-15KB) and full-size for viewers (~50-150KB). ~10x bandwidth reduction on grid views.
- **Files Created (v1):**
  - `photoapi/generate_thumbnails.py` — v4.0: WebP-only 3-tier (thumbs 200x200 Q70, webp 1024px Q80, hi-res 2048px Q82), 3 args, source = staging/
  - `photoapi/generate_thumb_ondemand.py` — On-demand thumbs called by thumbnail_helper.php
  - `photoapi/backfill_thumbnails.py` — 3-tier WebP (1024px Q80 + 2048px Q82 + 200x200 Q70) for existing photos
  - `scheduler/uploads/.htaccess` — WebP MIME type + immutable caching
- **Files Modified (v2 — derivatives-only + staging):**
  - `photoapi/upload.php` — staging flow, no JPEG in uploads/, WebP-only derivatives
  - `photoapi/process_retry_queue.py` — `cleanup_staging()`: deletes staging files > 7 days
  - `controllers/preupload.php` — Copy to staging before CI resize; sync + WebP from staging
  - `controllers/phototab.php` — Same staging pattern as preupload
  - `views/photo_tab/photos_index.php` — WebP-aware initial grid (checks webpfilename + is_file, fallback to thumbnail())
- **Files Modified (v3 — mobile app integration):**
  - `photoapi/getimagelistingnew.php` — Rewritten: DB-based (meter_files) instead of /mnt/aeiserver/ filesystem; returns thumb_link
  - `photoappsch/.../loginapinew.php` — Added thumbUrl to customerphotostabstatenew() response
  - Flutter: `photo_item.dart`, `job_photos_full_view.dart`, `customer_photos_tab.dart`, `job_details_page.dart`
- **Files Unchanged (from v1):**
  - `helpers/thumbnail_helper.php`, `photoapi/fetch_image1.php`, `photoapi/getimagelisting1.php`
- **New Directories Required:** `scheduler/uploads/staging/` (chmod 777), `scheduler/uploads/thumbs/` (chmod 777)
- **Dependencies:** PHOTO-009 (Unified Storage), PHOTO-011 (Reconciliation — staging cleanup hook)
- **GD Phaseout:** After backfill, scheduler UI uses WebP exclusively. `thumbnail()` helper becomes fallback-only for old records without webpfilename. Eventually removable.
- **Estimates:** Backfill ~7h with 4 workers; staging ~500MB peak; future ~204GB recoverable from legacy JPEGs

---

### PHOTO-018: Background Upload Queue
- **Directory:** `PHOTO-018_BACKGROUND_UPLOAD_QUEUE/`
- **Status:** **Planning** (2026-02-19)
- **Description:** Two-phase enhancement to eliminate blocking UI during mobile photo uploads. Phase 1: foreground upload queue (persistent SQLite, sequential processing, retry/backoff, dedup, network-aware pause/resume). Phase 2: true background uploads via multipart/form-data + `background_downloader` package (OS-level transfers survive app backgrounding). Phase 1 requires no server changes; Phase 2 adds multipart support to `upload.php` alongside existing JSON/base64.
- **Phase 1 Files (App Only):**
  - `lib/services/upload_queue_service.dart` — **NEW** — singleton queue manager
  - `lib/models/upload_queue_item.dart` — **NEW** — queue item model + SQLite schema
  - `lib/widgets/upload_status_widget.dart` — **NEW** — queue progress indicator
  - `lib/pages/job_photos_full_view.dart` — Modified — enqueue instead of blocking upload
  - `lib/pages/job_details_page.dart` — Modified — enqueue instead of blocking upload
  - `lib/main.dart` — Modified — init queue service + lifecycle observer
  - `pubspec.yaml` — Modified — add `sqflite`
- **Phase 2 Files (App + Server):**
  - `photoapi/upload.php` — Modified — accept multipart/form-data + legacy JSON
  - `lib/services/upload_queue_service.dart` — Modified — switch to `background_downloader`
  - `pubspec.yaml` — Modified — add `background_downloader`
- **Dependencies:** PHOTO-017 (defines staging pipeline that upload feeds into)
- **Notes:** Phase 1 alone solves ~90% of user frustration. WebP at 1024px Q80. No compression before upload — server receives full-res originals for archival.

---

### PHOTO-021: Photo Resolution — Staging Direct, DB-Only Listing, API Fix
- **Directory:** `PHOTO-021_PHOTO_RESOLUTION_PLAN/`
- **Status:** **Deployed** (2026-02-21)
- **Description:** Three fixes that resolve photo system inconsistencies documented in PHOTO_SYSTEM_PROCESS_MAP.md §11-12:
  1. **Staging Direct Upload** — Scheduler uploads (phototab.php, preupload.php) go directly to `uploads/staging/` instead of `uploads/` root. CI resize (800x1027) removed entirely. No new JPEG ever written to uploads/ root. Eliminates ~200GB of growing waste.
  2. **DB-Only Photo Listing** — `photo_index()` sets `$s3files = array()` instead of calling `getimagelisting()`. s3files rendering block removed from `photos_index.php`. Download All uses meter_files only, prefers WebP files.
  3. **API full_link Fix** — `getimagelisting.php` `full_link` changed from `/webp/` to `/hi-res/`, aligning with `getimagelisting1.php` and `getimagelistingnew.php`.
- **Files Modified:**
  - `controllers/phototab.php` — Upload path → staging/, remove CI resize, `$s3files = array()`, download prefers WebP
  - `controllers/preupload.php` — Upload path → staging/, remove CI resize
  - `views/photo_tab/photos_index.php` — Removed s3files rendering block (lines 202-247)
  - `photoapi/getimagelisting.php` — `full_link: webp/ → hi-res/`
- **Dead Code Retained:**
  - `getimagelisting()` method (phototab.php ~930-1040) — no longer called
  - `getimagelistings3()` method (phototab.php ~820-930) — already unused
  - `getimagelistingm.php` (photoapi/) — no callers remain
- **Dependencies:** PHOTO-017 (staging pipeline), PHOTO-009 (unified storage)
- **QA:** 42/44 PASS (`test_upload_pipeline.py` — 52 steps, 10 phases). Failures: Phase 9 only (missing test_photos/ dir).
- **Canonical Reference:** `DOCS/PHOTO_SYSTEM_PROCESS_MAP.md` — created as part of PHOTO-021, documents the complete unified post-fix system.

---

### PHOTO-022: Remove Hi-Res Tier
- **Directory:** `PHOTO-022_REMOVE_HIRES/`
- **Status:** **Implemented** (2026-02-22)
- **Description:** Removes the hi-res (2048px Q82 WebP) derivative tier from the photo system. Since full-size originals are archived on the local server via `sync_to_local.py`, the hi-res tier was redundant — adding processing time, disk usage, and complexity for no benefit. Simplifies from 3-tier (thumbs + webp + hi-res) to 2-tier (thumbs + webp). Mobile `full_link` and scheduler lightbox "Full Size" both point to `/webp/` (best available remote copy).
- **Files Modified:**
  - `photoapi/generate_thumbnails.py` — Removed hi-res constants, Phase 2 block; version → 5.0
  - `photoapi/backfill_thumbnails.py` — Removed hi-res constants, sets, generation, verify; version → 3.0
  - `photoapi/getimagelisting.php` — `full_link: hi-res/ → webp/`
  - `photoapi/getimagelistingnew.php` — `full_link: hi-res/ → webp/`
  - `photoapi/getimagelisting1.php` — `full_link: hi-res/ → webp/`
  - `photoapi/upload.php` — Removed hi-res comment line
  - `scheduler/assets/new_phototab/js/lightbox.js` — Full Size link uses `/webp/` directly
- **Dependencies:** PHOTO-017 (3-tier pipeline), PHOTO-021 (full_link set to hi-res/)
- **Deployment:** Python scripts + PHP files SCP to remote; lightbox.js via aei_deploy.sh
- **Notes:** Existing `uploads/hi-res/` directory left in place (harmless frozen data, no new files written).

---

### PHOTO-023: WebP Resolution Bump + Verified Staging Cleanup
- **Directory:** `PHOTO-023_WEBP_BUMP_VERIFIED_CLEANUP/`
- **Status:** **Implemented** (2026-02-22)
- **Description:** Error logging for `generate_thumbnails.py` exec calls (redirect `> /dev/null` to log files), cron fallback script `fix_missing_webp.py` to catch silent failures, and archive copy from staging to `uploads/` root.
- **Dependencies:** PHOTO-022
- **Notes:** Precursor to PHOTO-024 which removed the archive copy added here.

---

### PHOTO-024: Remove uploads/ Root Dependency
- **Directory:** `PHOTO-024_remove_uploads_root_dependency/`
- **Status:** **Deployed** (2026-02-23)
- **Description:** Removes the archive copy (`shutil.copy2()`) from `generate_thumbnails.py` that was added in PHOTO-023, and removes the JPEG fallback from ZIP downloads in `phototab.php`. The `uploads/` root is no longer written to or read from by any active code path. Full-size archival handled exclusively by `sync_to_local.py`. After verification that all 202,479 files were backed up locally, ~170GB of legacy images were deleted from production (tracked in MAINT-012).
- **Files Modified:**
  - `photoapi/generate_thumbnails.py` — v7.0: removed `shutil.copy2()` archive block
  - `photoapi/delete_image.php` — Removed `uploads/{unique_filename}` deletion block
  - `controllers/phototab.php` `download_all_photos()` — WebP only, removed JPEG fallback
  - `PHOTO_SYSTEM_PROCESS_MAP.md` — Updated architecture docs
  - `test_upload_pipeline.py` — Updated Phase 12 tests
- **Dependencies:** PHOTO-023

---

### PHOTO-025: Remove S3/AWS Dependency
- **Directory:** `PHOTO-025_remove_s3_dependency/`
- **Status:** **Deployed** (2026-02-23)
- **Description:** Removes `require aws.phar` and `use Aws\S3\S3Client` from the top of `phototab.php` and `loginapi.php`. The `scaws/` directory (containing the AWS SDK) was deleted in MAINT-013, causing a PHP fatal error (HTTP 500) on every route in both controllers. S3 was only used in one dead method (`s3_upload()`) — all photo storage moved to direct file storage in PHOTO-009/PHOTO-017.
- **Files Modified:**
  - `controllers/phototab.php` — Commented out `require aws.phar` (line 2) and `use Aws\S3\S3Client` (line 3)
  - `controllers/loginapi.php` — Commented out `require aws.phar` (line 2) and `use Aws\S3\S3Client` (line 3)
- **Dependencies:** PHOTO-009, PHOTO-017
- **Related:** MAINT-013 (deleted scaws/ directory), PHOTO-013 (removed S3 credentials from photoappsch/loginapi.php)
- **Dead Code:** `phototab.php s3_upload()` method still exists but is unreachable — candidate for future cleanup

---

### ENH-F01: Folder Year Sync (FUTURE — Deprioritized)
- **Directory:** `FUTURE/ENH-F01_FOLDER_YEAR_SYNC/`
- **Description:** Synchronizes folder year logic between remote and local servers. When local falls back to a different year, creates new year folder instead of reusing old one.
- **Files to Modify:**
  - `LOCAL/uploadlocallat_kuldeep.php` — Create new year folder + unified_customers record on year mismatch
- **Dependencies:** PHOTO-005
- **Notes:** Only affects new uploads; existing files stay put.
- **Update (2026-02-18):** Deprioritized. `folder_path` is deprecated by PHOTO-009 (no longer written to /mnt/dropbox/). Local sync still uses folder paths but the year-mismatch issue is less impactful now that remote doesn't create hierarchy folders.

---

### PHOTO-012: Mobile Photo Listing Metadata Fix
- **Directory:** `PHOTO-012_MOBILE_LISTING_FIX/`
- **Status:** **Deployed** (2026-02-18)
- **Description:** Fixes critical `$info` undefined variable bug in `getimagelisting1.php` — the mobile app's photo listing endpoint. Every mobile photo listing returned null for job_type, job_date, and photo_type. Fix uses SQL JOINs to fetch metadata directly instead of calling the unused `getJobPhotoInfo()` helper. Also adds DB connection error handling and removes 90 lines of dead code.
- **Files Modified:**
  - `photoapi/getimagelisting1.php` — SQL JOIN for metadata, error handling, dead code removal
- **Dependencies:** PHOTO-009 (conceptual — mirrors PHOTO-009's DB-only approach for the "1" variant)
- **Notes:** Discovered during post-PHOTO-009 system audit (DOCS/SYSTEM_AUDIT_2026_02_18.md). The mobile app uses `getimagelisting1.php` (via loginapinew.php), not the PHOTO-009-fixed `getimagelisting.php`.

---

### PHOTO-013: Security Hardening
- **Directory:** `PHOTO-013_SECURITY_HARDENING/`
- **Description:** Addresses multiple security issues found during the 2026-02-18 system audit: AWS S3 credentials in commented code, display_errors enabled in production, auth tokens leaked in error messages, CORS header conflicts, and orphaned S3 cache functions.
- **Files Modified:**
  - `photoappsch/loginapi.php` — Removed S3 credentials + dead code, fixed CORS, removed token from errors
  - `photoappsch/loginapinew.php` — Set display_errors=0, fixed CORS, removed token from errors
- **Dependencies:** None (independent)
- **Notes:** Also modifies loginapi.php (overlaps with PHOTO-014 — different changes, no conflicts). `fetch_image1.php` already has `basename()` — auth check deferred to ENH-F02.

---

### PHOTO-014: Login API Bug Fixes
- **Directory:** `PHOTO-014_LOGINAPI_FIXES/`
- **Status:** **Deployed** (2026-02-18)
- **Description:** Fixes `time()` misuse (returns current timestamp instead of job date), `$endDate` overwrite (search returns 1 day instead of 2-day range), and uninitialized `$data` array across **three files** in **two apps**.
- **Architecture Note:** `loginapi.php` exists in both `scheduler/` (simpler, 333 lines) and `photoappsch/` (larger, 584 lines). `loginapinew.php` (in `photoappsch/`) duplicates the same bugs.
- **Files Modified:**
  - `scheduler/.../loginapi.php` — 2 fixes (`time()` → `strtotime()`, `$data` init)
  - `photoappsch/.../loginapi.php` — 5 fixes (`time()` x2, `$endDate`, `$data`, SQL escaping)
  - `photoappsch/.../loginapinew.php` — 3 fixes (`$endDate` x2, `time()` → `strtotime()`)
- **Dependencies:** None (independent)
- **Notes:** `loginapinew.php` fixed via in-place sed. Also overlaps with PHOTO-013 on `photoappsch/loginapi.php` (different changes, no conflicts).

---

### PHOTO-015: Docs Tab Expansion
- **Directory:** `PHOTO-015_DOCS_TAB_EXPANSION/`
- **Status:** **Deployed** (2026-02-19)
- **Description:** Expands the mobile app's Documents tab from showing only one permit type to all 5 document tables (permit_files, sketch_files, genral_files, presale_files, predesignsketch_files). Also fixes 3 bugs: upload typo (`newtr_swhdocumnets` → `newtr_swhdocuments`), pfid bug (`$job['jfid']` → `$job['pfid']`), and re-enables auth on `uploaddoc()`.
- **Files Modified:**
  - `photoappsch/.../loginapinew.php` — 5 changes (UNION query, prefix routing, typo fix, pfid fix, auth re-enable)
- **Dependencies:** PHOTO-014 (same file, builds on previous fixes)
- **No App Changes Required:** Flutter app treats pfid as String?, ignores unknown JSON fields

---

### PHOTO-016: Survey Photos in Mobile (Optimized)
- **Directory:** `PHOTO-016_SURVEY_PHOTOS_MOBILE/`
- **Status:** **Deployed** (2026-02-19)
- **Description:** Merges local survey photos into the mobile app's photo grid. Optimized architecture: single listing call pre-caches thumbnails to `/tmp/survey_photo_cache/` on the remote server, then serves them via `readfile()`. Mid/full images are proxied on-demand with 7-day disk caching. Grid loads in ~0.7s instead of ~50s (original PHOTO-016 proxied each image individually).
- **Files:**
  - `get_survey_photos.php` (LOCAL) — **Modified** — added `include_thumbs=1` param; returns `thumbnail_base64` per photo (20KB cap)
  - `photoapi/getimagelisting1.php` — **Modified** — Step 5 calls local API with `include_thumbs=1`, decodes base64, writes thumbs to disk cache. Returns `thumb_link` (pre-cached key URL with fallback_path), `link` (proxy), `full_link` (proxy), `source: "local"`
  - `photoapi/serve_survey_photo.php` — **Rewritten** — two modes: `?key=&size=thumb` (serve from cache), `?path=` (proxy + cache-on-write). Probabilistic GC (1% chance, 7-day TTL). Atomic writes. `X-Cache` header for debugging. Fallback proxy on cache miss (handles /tmp/ volatility).
- **Dependencies:** PHOTO-006 (local survey photo API), PHOTO-017 (static URLs in listing)
- **Error Handling:** All survey logic silently fails — uploaded photos always returned. Thumb cache miss falls back to on-demand proxy or 1x1 placeholder. Image proxy returns 502 on local server failure.
- **Performance:** 83 survey photos served: listing ~0.7s, grid instant (thumbs pre-cached), detail view ~0.65s first / <10ms repeat.

---

### PHOTO-020: Gallery UX Improvements
- **Directory:** `PHOTO-020_GALLERY_UX/`
- **Description:** Three UX fixes to the scheduler photo gallery (photos_index.php + lightbox.js): (1) Load all photos at once instead of 8 with "Show more" pagination — fixes lightbox only navigating visible photos. (2) 4-column thumbnail grid (207px) with uniform `object-fit: cover`. (3) All lightbox animations removed (instant open/close/resize).
- **Files:**
  - `views/photo_tab/photos_index.php` — Removed 8-photo limit, date-group break, "Show more" button/AJAX, 4-col CSS, uniform thumbnails
  - `assets/new_phototab/js/lightbox.js` — fadeDuration/resizeDuration → 0, `.animate()` → `.css()`, all fadeIn/fadeOut → show/hide
- **Dependencies:** PHOTO-017 (WebP thumbnail serving in photos_index.php)
- **Also tracked as:** `dev_scheduler/ENHANCEMENTS/PHOTO-015_photo_nav_fix/`

---

### ENH-F02: API Unification (FUTURE)
- **Directory:** `FUTURE/ENH-F02_API_UNIFICATION/`
- **Description:** Eliminates parallel "1" variant files (getimagelisting1.php, fetch_image1.php) by redirecting to the PHOTO-009-improved base files. Phased approach: (1) server-side redirect wrappers, (2) update loginapinew.php URLs, (3) Flutter app update, (4) delete "1" files.
- **Dependencies:** PHOTO-012 (metadata fix), PHOTO-013 (security hardening)
- **Notes:** Also investigates `getimagelistingnew.php` usage (third variant, called from one loginapinew.php path).

---

## Adding a New Enhancement

1. Determine the next number: `ls ENHANCEMENTS/ | grep '^ENH-' | tail -1` → increment
2. Create directory: `mkdir ENHANCEMENTS/ENH-XXX_NAME`
3. Create subdirectories: `mkdir ORIGINAL/ NEW/`
4. Add `README.md` with: description, files modified, dependencies, rollback instructions
5. Copy pre-modification files to `ORIGINAL/`
6. Place modified files in `NEW/`
7. Add an entry to the **Summary Table** and **Per-Enhancement Details** above
8. Update the **Dependency Graph** if applicable

For future/unscheduled items, use `FUTURE/ENH-FXX_NAME` with the next F-number.

---

*Last updated: 2026-02-23 (PHOTO-024 deployed — removed uploads/ root dependency; PHOTO-025 deployed — removed S3/AWS dependency)*
