# AEI Photo System — Complete Process Map

**Date:** 2026-02-21
**Status:** Authoritative — reflects actual deployed production code
**Supersedes:** PHOTO_SYSTEM_DOCUMENTATION.md (v2.2, 2026-02-05, pre-PHOTO-009/017)

---

## Table of Contents

1. [Architecture Overview](#1-architecture-overview)
2. [WebP Derivative Tiers](#2-webp-derivative-tiers)
3. [Upload Flows](#3-upload-flows)
   - [Mobile App Upload](#31-mobile-app-upload-uploadphp)
   - [Scheduler Web Upload](#32-scheduler-web-upload-phototabphp--preuploadphp)
4. [WebP Generation Script](#4-webp-generation-script)
5. [Local Sync & Archival](#5-local-sync--archival)
6. [Photo Display Flows](#6-photo-display-flows)
   - [Scheduler Web UI](#61-scheduler-web-ui)
   - [Mobile App](#62-mobile-app)
7. [Download Flow](#7-download-flow)
8. [API Endpoints Reference](#8-api-endpoints-reference)
9. [Storage Layout](#9-storage-layout)
10. [Database Schema](#10-database-schema)
11. [Known Issues](#11-known-issues)
12. [Resolution Plan](#12-resolution-plan)

---

## 1. Architecture Overview

Three environments participate in the photo system:

```
┌──────────────────────────────────────────────────────────────┐
│                  REMOTE SERVER (18.225.0.90)                  │
│                                                              │
│  UPLOAD SOURCES                                              │
│    Mobile App ──────► photoapi/upload.php                     │
│    Scheduler Web ───► controllers/phototab.php                │
│    Pre-Upload ──────► controllers/preupload.php               │
│              │                                               │
│              ▼                                               │
│    uploads/staging/{filename}   (full-size original, temp)    │
│              │                                               │
│              ├──► generate_thumbnails.py (nohup &)           │
│              │      ├─► uploads/thumbs/{webpfilename}        │
│              │      ├─► uploads/webp/{webpfilename}          │
│              │      └─► uploads/hi-res/{webpfilename}        │
│              │                                               │
│              └──► sync_to_local.py (nohup &)                 │
│                     └─► HTTPS POST to local server           │
│                                                              │
│  SERVING (scheduler + mobile both read from here)            │
│    uploads/thumbs/   Grid thumbnails (200x200 Q70)           │
│    uploads/webp/     Standard viewing (1024px Q80)  ◄ ACTIVE │
│    uploads/hi-res/   High-res (2048px Q82)          ◄ FUTURE │
│                                                              │
│  LEGACY (to be cleaned up)                                   │
│    uploads/*.jpg     ~200GB of old JPEGs             ◄ WASTE │
│    /mnt/aeiserver/   Old filesystem-organized photos         │
└──────────────────────┬───────────────────────────────────────┘
                       │ sync_to_local.py
                       ▼
┌──────────────────────────────────────────────────────────────┐
│                LOCAL SERVER (upload.aeihawaii.com)             │
│                                                              │
│  uploadlocallat_kuldeep.php                                  │
│    → Receives full-size original from staging/               │
│    → Saves to /mnt/dropbox/{Year} Customers/.../             │
│    → Background: upload_thumb_generator.py                   │
│       → thumbs/{name}.webp (200x200 Q70)                    │
│       → thumbs/mid/{name}.webp (800px Q80)                  │
│    → Tracks in local_photos table                            │
│                                                              │
│  This is the ARCHIVAL store for full-size originals.         │
└──────────────────────────────────────────────────────────────┘

┌──────────────────────────────────────────────────────────────┐
│                    MOBILE APP (Flutter)                        │
│                                                              │
│  Upload: base64 JSON POST → upload.php → staging/            │
│  Display: uploads/thumbs/ (grid) + uploads/webp/ (detail)    │
│  Future: uploads/hi-res/ for HD viewing & downloads          │
└──────────────────────────────────────────────────────────────┘
```

---

## 2. WebP Derivative Tiers

All three tiers are generated by `generate_thumbnails.py` (v4.0) from the full-size original in `staging/`. The script uses Pillow with LANCZOS resampling for consistent high-quality output.

| Tier | Directory | Max Size | Quality | Status | Used By |
|------|-----------|----------|---------|--------|---------|
| **Thumbnail** | `uploads/thumbs/` | 200x200 | Q70 | **Active** | Grid views (scheduler + mobile) |
| **Standard** | `uploads/webp/` | 1024px max dim | Q80 | **Active** | Lightbox, mobile detail, all current viewing |
| **Hi-Res** | `uploads/hi-res/` | 2048px max dim | Q82 | **Generated, future use** | Will be used for HD viewing & downloads |

**Note:** Hi-res is only generated when the source image is larger than 1024px (no point duplicating the standard tier). EXIF data is preserved in all tiers.

### File Counts (Remote, 2026-02-21)

| Directory | Files | Notes |
|-----------|------:|-------|
| `uploads/thumbs/` | 196,377 | Active |
| `uploads/webp/` | 196,539 | Active |
| `uploads/hi-res/` | 84,835 | Generated, not yet utilized (fewer because small-source images skip this tier) |
| `uploads/*.jpg` | ~200,000+ | **Legacy waste — ~200GB** of old CI-resized 800x1027 JPEGs |

---

## 3. Upload Flows

### 3.1 Mobile App Upload (upload.php)

**File:** `photoapi/upload.php` on remote server
**Trigger:** Flutter app POST with base64-encoded image
**Status:** Correct — follows the intended staging-first flow

```
Mobile App sends JSON POST:
  { auth_token, job_id, file_name, image_data (base64) }
         │
         ▼
1. Validate auth token
         │
         ▼
2. Decode base64 → raw image bytes
         │
         ▼
3. Save to uploads/staging/{uniqid}_{filename}     ◄── STAGING ONLY (correct)
   Full-size original. No JPEG in uploads/ root.
         │
         ▼
4. DB lookup: jobs → customer info, job_date, job_type
         │
         ▼
5. Generate webpfilename:
   {LastName}{FirstName}{JobType}-{PhotoType}{Date}_IMG{12-char-random}.webp
   Example: SmithJohnAC-I02-18-2026_IMG0ec2c8b5682e.webp
   PhotoType: S (Survey) for PM/WM/AS/RPM/GCPM, else I (Installation)
         │
         ▼
6. DB INSERT meter_files:
   job_id=job_pid, unique_filename, webpfilename, file_size, file_type=99
         │
         ▼
7. Background (nohup &): generate_thumbnails.py
   Source: staging/{filename}
   Output: thumbs/{webpfilename}  (200x200 Q70)
           webp/{webpfilename}    (1024px Q80)
           hi-res/{webpfilename}  (2048px Q82, if source > 1024px)
         │
         ▼
8. Background (nohup &): sync_to_local.py
   Sends staging/ copy to local server for archival
         │
         ▼
9. Return JSON: {"success":1, "status":"ok"}
   Response is immediate — no wait for WebP generation or sync.
```

---

### 3.2 Scheduler Web Upload (phototab.php / preupload.php)

**File:** `controllers/phototab.php` method `dropImageUpload()`
**File:** `controllers/preupload.php` method `submit()`
**Trigger:** Drag-and-drop or file picker in scheduler web UI
**Status:** NEEDS FIX — should go to staging/ directly like mobile

#### Current Flow (What Actually Happens)

```
User selects file in browser
         │
         ▼
1. CI upload library saves to uploads/{encrypted_name}.jpg     ◄── ISSUE
   Full-size original lands in uploads/ root as JPEG first.
   (CI requires upload_path config — currently set to uploads/)
         │
         ▼
2. COPY uploads/{encrypted}.jpg → uploads/staging/{encrypted}.jpg
   Full-size copy preserved before CI resize.
         │
         ▼
3. Background (nohup &): sync_to_local.py
   Sends staging/ copy to local server.
         │
         ▼
4. Background (nohup &): generate_thumbnails.py
   Source: staging/{encrypted}.jpg (full-size, pre-resize)
   Output: thumbs/, webp/, hi-res/ (same as mobile)
         │
         ▼
5. CI image_lib->resize() OVERWRITES uploads/{encrypted}.jpg   ◄── ISSUE
   Now 800x1027 JPEG, lower quality. This file is never read
   for new photos (WebP is served instead).
         │
         ▼
6. DB INSERT meter_files
   unique_filename = {encrypted}.jpg, webpfilename = {generated}.webp
```

#### Intended Flow (What Should Happen)

```
User selects file in browser
         │
         ▼
1. CI upload library saves to uploads/staging/{encrypted_name}  ◄── FIX
   (Change upload_path config to uploads/staging/)
         │
         ▼
2. Background (nohup &): generate_thumbnails.py
   Source: staging/{encrypted}
   Output: thumbs/, webp/, hi-res/
         │
         ▼
3. Background (nohup &): sync_to_local.py
   Sends staging/ copy to local server.
         │
         ▼
4. DB INSERT meter_files
         │
         ▼
5. No CI resize. No JPEG in uploads/ root.
```

See [§12 Resolution Plan](#12-resolution-plan) for the fix.

---

## 4. WebP Generation Script

**Deployed file:** `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/generate_thumbnails.py`
**Version:** 4.0 (PHOTO-017 3-tier derivatives)
**Runtime:** Python 3.6 + Pillow (LANCZOS resampling)
**Execution:** Background via `nohup /usr/local/bin/python3.6 ... &`

### Configuration (Actual Deployed Values)

```python
THUMBNAIL_SIZE = (200, 200)    # thumbs/ tier
MAX_LARGE      = 1024          # webp/ tier max dimension
MAX_HIRES      = 2048          # hi-res/ tier max dimension
WEBP_THUMB_QUALITY  = 70       # thumbs/ quality
WEBP_LARGE_QUALITY  = 80       # webp/ quality
WEBP_HIRES_QUALITY  = 82       # hi-res/ quality
TIMEOUT_SECONDS     = 120      # per-image timeout
```

### Processing Flow

1. Load image with EXIF extraction and rotation correction
2. Convert RGBA/P/LA to RGB (white background)
3. **Phase 1 (priority — needed for immediate viewing):**
   - Generate thumbnail: `img.thumbnail((200,200), LANCZOS)` → Q70 → `thumbs/`
   - Generate standard: `resize_max_dimension(img, 1024)` → Q80 → `webp/`
4. **Phase 2 (deferred — generated but not yet utilized):**
   - Generate hi-res: `resize_max_dimension(img, 2048)` → Q82 → `hi-res/`
   - Only if source is larger than 1024px (skip for small images)
5. All saves are atomic (temp file + rename) to prevent serving partial images
6. EXIF data preserved in all output tiers
7. Idempotent: skips any output file that already exists

### Backfill Script

**Deployed file:** `backfill_thumbnails.py` — uses identical settings (MAX_LARGE=1024, Q80, MAX_HIRES=2048, Q82). Processes existing meter_files records that lack WebP derivatives. Sources from `uploads/{unique_filename}` (the only copy available for pre-staging-era photos).

---

## 5. Local Sync & Archival

### Remote → Local (sync_to_local.py)

**Target:** `https://upload.aeihawaii.com/uploadlocallat_kuldeep.php`
**Method:** Multipart POST (file + metadata fields)
**Source:** `staging/{filename}` (full-size original)

```
Retry policy:
  3 inline attempts with exponential backoff (2s, 4s, 8s)
  If all fail: save to queue/{timestamp}_{random}.json
  Cron (process_retry_queue.py) retries every 15 minutes
```

### Local Receipt (uploadlocallat_kuldeep.php)

1. Validate auth token and MIME type
2. Look up customer folder path:
   `/mnt/dropbox/{Year} Customers/{Letter}/{LastName}, {FirstName}/{Survey|Installation}/{Job}/`
3. Move file to customer folder (full-size original preserved permanently)
4. Background: `upload_thumb_generator.py`
   - `thumbs/{name}.webp` (200x200 Q70)
   - `thumbs/mid/{name}.webp` (800px Q80)
5. Track in `local_photos` table

### Staging Cleanup

`process_retry_queue.py` (cron) cleans staging files older than 7 days. By then, the file has been synced to local and WebP derivatives generated.

---

## 6. Photo Display Flows

### 6.1 Scheduler Web UI

**Controller:** `phototab.php` → `photo_index($job_id)`
**View:** `views/photo_tab/photos_index.php`

The scheduler currently pulls from **two sources** and renders both:

#### Source 1: meter_files (DB Query — Correct Path)

```sql
SELECT * FROM meter_files WHERE job_id = '{job_id}' AND file_type = 99 ORDER BY created DESC
```

**Rendering:**
```
For each meter_file:
  IF webpfilename AND uploads/thumbs/{webpfilename} exists:
    thumbnail = base_url()/uploads/thumbs/{webpfilename}          ◄── WebP (correct)
  ELSE:
    thumbnail = thumbnail() helper (GD on-the-fly fallback)

  IF webpfilename AND uploads/webp/{webpfilename} exists:
    lightbox = base_url()/uploads/webp/{webpfilename}             ◄── WebP (correct)
  ELSE:
    lightbox = thumbnail() helper (GD fallback for old photos)
```

Both scheduler and mobile use `uploads/webp/` for standard viewing. This is correct.

#### Source 2: $s3files (Remote API — Legacy, See §11.2)

```php
$s3files = $this->getimagelisting($job_id);
// Calls: https://aeihawaii.com/photoapi/getimagelistingm.php
// Method: scandir('/mnt/aeiserver/{job_id}/')
```

Returns photos from the old `/mnt/aeiserver/` filesystem. See [§11.2](#112-scheduler-calls-scandir-based-endpoint) for why this is a problem.

---

### 6.2 Mobile App

**API chain:**
```
loginapinew.php
  → customerphotostabstatenew($customer_id)
    → getimageforapinew($job_id)
      → POST to getimagelistingnew.php
        → DB: meter_files WHERE job_id AND file_type=99 AND webpfilename IS NOT NULL
```

**URLs returned to app:**
```json
{
  "link":       "https://aeihawaii.com/scheduler/uploads/webp/{webpfilename}",
  "thumb_link": "https://aeihawaii.com/scheduler/uploads/thumbs/{webpfilename}",
  "full_link":  "https://aeihawaii.com/scheduler/uploads/hi-res/{webpfilename}"
}
```

**What the mobile app uses today:**
- Grid view: `thumb_link` → `uploads/thumbs/` (200x200 Q70 WebP)
- Detail view: `link` → `uploads/webp/` (1024px Q80 WebP)
- `full_link` is returned but not yet actively utilized by the app (future HD feature)

The mobile app is correctly serving WebP from `uploads/webp/` and `uploads/thumbs/`.

---

## 7. Download Flow

**Controller:** `phototab.php` → `download_all_photos($job_id)`
**Trigger:** "Download All" button on photo tab

```
1. Query meter_files for job_id (grouped by date)
2. Call getimagelisting($job_id) → gets $s3files
3. Create ZIP in memory:

   FOR EACH meter_file:
     Prefer: uploads/webp/{webpfilename}      (1024px Q80 WebP)
     Fallback: uploads/{unique_filename}       (800x1027 JPEG for old photos)
     Add to ZIP

   FOR EACH s3file:
     Fetch via file_get_contents(URL)          (HTTP, slow)
     Add to ZIP

4. Stream ZIP to browser
```

**Current limitation:** Downloads use `uploads/webp/` (1024px). When hi-res is utilized, downloads should pull from `uploads/hi-res/` (2048px Q82) for better quality.

---

## 8. API Endpoints Reference

### Listing Endpoints

| Endpoint | Query Method | Called By | `link` | `thumb_link` | `full_link` |
|----------|-------------|-----------|--------|--------------|-------------|
| `getimagelistingm.php` | **scandir** `/mnt/aeiserver/` | Scheduler `$s3files` | fetch_image.php URL | N/A | N/A |
| `getimagelisting.php` | **DB** meter_files | Mobile (all customer jobs) | `webp/` | `thumbs/` | `webp/` (**should be hi-res/**) |
| `getimagelistingnew.php` | **DB** meter_files (1 photo) | Mobile (job thumbnail) | `webp/` | `thumbs/` | `hi-res/` |
| `getimagelisting1.php` | **DB** + survey proxy | Mobile (customer tab) | `webp/` | `thumbs/` | `hi-res/` |

### Serving Endpoints

| Endpoint | Method | Notes |
|----------|--------|-------|
| `fetch_image.php` | DB lookup → stream file | Fallback chain: webp/ → uploads/ → /mnt/aeiserver/ |
| `fetch_image1.php` | Filesystem → 302 redirect | Supports `?size=thumb` for thumbs/ |
| Direct Apache static | Serves `uploads/webp/`, `uploads/thumbs/` | Fastest — no PHP overhead |

---

## 9. Storage Layout

### Remote Server (Production)

```
/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/
│
├── staging/                            TEMPORARY — 7-day cleanup
│   ├── {uniqid}_{filename}.jpg         Mobile uploads (full-size original)
│   └── {encrypted_name}.jpg            Scheduler uploads (full-size copy)
│
├── thumbs/                             ACTIVE — 196,377 files
│   └── {webpfilename}.webp             200x200, Q70 WebP (grid thumbnails)
│
├── webp/                               ACTIVE — 196,539 files
│   └── {webpfilename}.webp             1024px max dim, Q80 WebP (standard viewing)
│
├── hi-res/                             GENERATED, FUTURE USE — 84,835 files
│   └── {webpfilename}.webp             2048px max dim, Q82 WebP (HD viewing later)
│
└── *.jpg                               LEGACY WASTE — ~200,000+ files, ~200GB
    └── {encrypted_name}.jpg            Old CI-resized 800x1027 JPEGs
                                        Not read for any photo with webpfilename set.
                                        Retained only as fallback for pre-WebP photos.
```

### Local Server (Archival)

```
/mnt/dropbox/{Year} Customers/
└── {Letter}/
    └── {LastName}, {FirstName}/
        ├── Survey/
        │   └── {CustomerName}, {JobType}-S, {Date}/
        │       ├── photo.jpg              Full-size original (permanent)
        │       └── thumbs/
        │           ├── photo.webp         200x200 Q70
        │           └── mid/
        │               └── photo.webp     800px Q80
        └── Installation/
            └── (same structure)
```

---

## 10. Database Schema

### meter_files (Remote DB: mandhdesign_schedular)

| Column | Type | Description |
|--------|------|-------------|
| `id` | INT PK | Auto-increment |
| `job_id` | INT | `jobs.job_pid` (NOT `jobs.id` — common confusion) |
| `unique_filename` | VARCHAR | CI encrypted name (e.g., `d3a5f8c2e1b7.jpg`) — legacy |
| `original_filename` | VARCHAR | User's original filename |
| `file_size` | INT | Bytes at upload time |
| `file_type` | INT | 99 = photo |
| `webpfilename` | VARCHAR | WebP name (e.g., `SmithJohnAC-I02-18-2026_IMGabc123.webp`) |
| `folder_path` | VARCHAR | Deprecated — empty for new uploads |
| `created` | DATETIME | Upload timestamp |

**Serving logic:** If `webpfilename` is set, serve from `uploads/webp/` and `uploads/thumbs/`. If not set (old photos), fall back to `uploads/{unique_filename}` via GD helper.

---

## 11. Known Issues

### 11.1 Scheduler Web Upload Goes to uploads/ First (Not Staging)

**Problem:** `phototab.php dropImageUpload()` and `preupload.php submit()` use CI's upload library with `upload_path = 'uploads/'`. The file lands as a JPEG in `uploads/` root, gets copied to `staging/`, then CI resize overwrites the `uploads/` copy to 800x1027.

**Expected:** Upload should go directly to `staging/` like the mobile flow. No JPEG should be created in `uploads/` root. No CI resize should happen.

**Impact:** Every scheduler web upload adds another JPEG to the ~200GB of legacy waste in `uploads/`.

---

### 11.2 Scheduler Calls scandir-Based Endpoint (getimagelistingm.php)

**Problem:** The scheduler's `phototab.php getimagelisting()` calls `getimagelistingm.php`, which uses `scandir('/mnt/aeiserver/{job_id}/')` instead of querying meter_files.

**Impact:**
- Photos uploaded via mobile (staging → webp, not /mnt/aeiserver/) may not appear in $s3files
- Old photos in /mnt/aeiserver/ that aren't in meter_files still show up
- Creates duplicate photos in scheduler UI (same photo from meter_files AND from s3files)
- Download All creates duplicates in ZIP

---

### 11.3 getimagelisting.php full_link Points to webp/ Instead of hi-res/

**Problem:** The `getimagelisting.php` endpoint (used by mobile for all-customer-jobs listing) returns `full_link` pointing to `uploads/webp/` instead of `uploads/hi-res/`.

The newer endpoints (`getimagelisting1.php`, `getimagelistingnew.php`) correctly point `full_link` to `uploads/hi-res/`.

---

### 11.4 Local Repo Out of Sync with Production

**Problem:** The local repo at `AEI_PHOTO_API_PROJECT/REMOTE/photoapi/generate_thumbnails.py` had v3.0 (2-tier) while production has v4.0 (3-tier).

**Fixed:** 2026-02-21 — synced all deployed photoapi files from production to local repo.

---

## 12. Resolution Plan

### Fix 1: Scheduler Upload → Staging Direct (§11.1)

**Change `phototab.php dropImageUpload()` and `preupload.php submit()`:**
- Set `$config['upload_path'] = FCPATH . 'uploads/staging/'`
- Remove the copy step (file is already in staging)
- Remove CI resize (800x1027 no longer needed)
- Update `unique_filename` in meter_files INSERT to reference the staging filename

**Verification:** Confirm nothing reads `uploads/{unique_filename}` for new photos (photos with `webpfilename` set). The view already prefers WebP. The `fetch_image.php` fallback to `uploads/{unique_filename}` is only for old photos without `webpfilename`.

**Mobile app impact:** None — mobile uses `upload.php`, not `phototab.php`.

---

### Fix 2: Scheduler Listing → DB-Driven (§11.2)

**Option A:** Switch `phototab.php getimagelisting()` from `getimagelistingm.php` to `getimagelisting.php` (DB-driven).

**Option B (preferred):** Eliminate `$s3files` entirely. The meter_files query in `photo_index()` already returns all photos. For old photos only in `/mnt/aeiserver/`, run a one-time backfill into meter_files.

**Mobile app impact:** None.

---

### Fix 3: Update getimagelisting.php full_link (§11.3)

**Change:** `"full_link" => $staticBase . '/webp/'` → `"full_link" => $staticBase . '/hi-res/'`

This aligns it with `getimagelisting1.php` and `getimagelistingnew.php`. The `full_link` won't be actively used until the hi-res feature is implemented, but the URL should be ready.

**Mobile app impact:** None currently — `full_link` is not yet utilized by the app.

---

### Future: Utilize Hi-Res Tier

When ready:
- Mobile app uses `full_link` → `uploads/hi-res/` for HD viewing and downloads
- Scheduler Download All pulls from `uploads/hi-res/` instead of `uploads/webp/`
- No server-side changes needed — hi-res files are already being generated

### Future: Clean Up Legacy JPEGs

After Fix 1 is deployed and verified:
- No new JPEGs are written to `uploads/` root
- Delete legacy JPEGs for photos that have WebP derivatives (where `webpfilename IS NOT NULL`)
- Estimated savings: ~200GB

---

## Appendix A: Credentials

| Component | Host | User | Password |
|-----------|------|------|----------|
| Remote DB | localhost (on 18.225.0.90) | schedular | M1gif9!6 |
| API auth token | — | — | aei@89806849 |
| Local sync auth | — | — | remote_token |
| SSH | 18.225.0.90 | Julian | PPK key |

## Appendix B: Enhancement History

| ENH | Date | Key Change |
|-----|------|------------|
| PHOTO-002 | 2026-02-04 | Async WebP generation (nohup &), mobile response 2-10s → 0.5s |
| PHOTO-009 | 2026-02-17 | Unified storage: DB-driven reads replace scandir for mobile endpoints |
| PHOTO-011 | 2026-02-09 | Reconciliation, sync source fixes, staging cleanup cron |
| PHOTO-017 | 2026-02-19 | Staging flow, 3-tier WebP (thumbs/webp/hi-res), sync_to_local |
| PHOTO-019 | 2026-02-19 | Local photo tracking (local_photos table, unified_customers) |
| PHOTO-020 | 2026-02-20 | Gallery UX: 4-col grid, lightbox improvements |

## Appendix C: Script Version Alignment

All Python scripts should match between production and local repo:

| Script | Production Version | Local Repo Synced |
|--------|-------------------|-------------------|
| `generate_thumbnails.py` | v4.0 (3-tier) | 2026-02-21 |
| `backfill_thumbnails.py` | 3-tier (1024/2048) | 2026-02-21 |
| `sync_to_local.py` | PHOTO-017 | Previously synced |
| `process_retry_queue.py` | PHOTO-011 | Previously synced |
