# Remote Server Storage Audit

**Server:** 18.225.0.90 (AWS EC2, Amazon Linux)
**Audit Date:** 2026-02-06
**Auditor:** Claude Code

---

## Executive Summary

| Metric | Value |
|--------|-------|
| Total Disk | 985 GB |
| Used | 344 GB (35%) |
| Free | 641 GB (65%) |
| Inodes Used | 1.7M / 65.5M (3%) |

The server is not in immediate danger, but **~35 GB can be recovered with safe, quick cleanup actions**, and an additional **~150+ GB** could be recovered with a data lifecycle policy for old uploads.

### Top Space Consumers

| Path | Size | % of Used |
|------|------|-----------|
| `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads` | 205 GB | 60% |
| `/var/www/vhosts/aeihawaii.com/httpdocs/uploads` | 70 GB | 20% |
| `/mnt/dropbox` | 18 GB | 5% |
| `/backup/mysql` | 14 GB | 4% |
| `/var/www/vhosts/aeihawaii.com/httpdocs/dev` | 8.6 GB | 2.5% |
| SQL dumps (scattered) | 9.4 GB | 2.7% |
| Other vhosts | 5.7 GB | 1.7% |
| `/var/log` | 1.8 GB | 0.5% |
| `/var/lib/mysql` | 4.6 GB | 1.3% |

---

## 1. CRITICAL: Security Issues

### 1.1 Publicly Accessible SQL Dump
- **File:** `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/sl.sql`
- **Size:** 290 MB
- **Last Modified:** 2024-10-28
- **Risk:** This is a full database dump sitting in a web-accessible directory. Anyone who discovers the URL can download the entire database including customer data, credentials, and business records.
- **Action:** DELETE IMMEDIATELY or move outside of httpdocs.

### 1.2 MySQL DB Admin Tool Left in Place
- **File:** `/var/www/vhosts/aeihawaii.com/httpdocs/mysqldbne/4nov2014.zip`
- **Size:** 44 MB
- **Risk:** Old database admin tool from 2014, potentially exploitable.
- **Action:** Delete the entire `mysqldbne/` directory.

---

## 2. HIGH PRIORITY: Easy Wins (~33 GB recoverable)

### 2.1 SQL Dumps in VHost Root (9.1 GB)

These are old database dumps from 2020 sitting in the aeihawaii.com vhost root:

| File | Size | Date |
|------|------|------|
| `latest.sql` | 3.0 GB | May 2020 |
| `latest2dmay2020.sl` | 3.0 GB | May 2020 |
| `mae.sql` | 3.0 GB | Apr 2020 |
| `tracks2.sql` | 66 MB | Apr 2020 |
| `tracks.sql` | 66 MB | Mar 2020 |

Also: `scheduler/system/application/config/tracks1.sql` (66 MB)

**Action:** These are 2-year-old redundant backups. Delete after verifying `/backup/mysql/` has more recent copies.

### 2.2 `/backup/mysql/` Redundant Backups (7+ GB recoverable)

| File | Size | Date | Notes |
|------|------|------|-------|
| `all_databases_backup.sql` | 2.4 GB | Nov 2023 | Superseded by newer backups |
| `full_backup.sql` | 2.4 GB | Dec 2023 | Superseded by newer backups |
| `full_backup2.sql.bz2` | 173 MB | Dec 2023 | Compressed version of above |
| `mandhdesign_schedular.sql` | 3.6 GB | Jul 2025 | Current backup |
| `mandhdesign_schedular_fixed.sql` | 4.5 GB | May 2025 | Superseded by Jul 2025 version |
| `mandhdesign_scrapdb.sql` | 75 MB | Jul 2025 | Current |
| `mysql.sql` | 550 KB | Jul 2025 | Current |
| `tracksmart.sql` | 57 MB | Jul 2025 | Current |

**Action:** Keep the Jul 2025 backups. Delete: `all_databases_backup.sql` (2.4G), `full_backup.sql` (2.4G), `full_backup2.sql.bz2` (173M), `mandhdesign_schedular_fixed.sql` (4.5G). **Saves ~9.5 GB.**

### 2.3 `/dev/` Directory (8.6 GB)

Full development copy of the scheduler application including 22,141 uploaded files (5.9 GB of uploads alone).

| Component | Size |
|-----------|------|
| `dev/scheduler/` | 7.8 GB |
| `dev/uploads/` | 382 MB |
| `dev/assets/` | 384 MB |

**Action:** Determine if this dev environment is still needed. If not, delete entirely. If needed, at minimum delete `dev/scheduler/uploads/` (5.9 GB) and symlink to production uploads or use a small test subset.

### 2.4 Mail Logs (1.3 GB)

Postfix is failing to deliver mail to Google SMTP (connection timeouts to `aspmx.l.google.com:25`). The rotated logs are enormous:

| File | Size |
|------|------|
| `maillog-20260201` | 317 MB |
| `maillog-20260125` | 319 MB |
| `maillog-20260118` | 322 MB |
| `maillog-20260111` | 318 MB |
| `maillog` (current) | 247 MB |

**Root cause:** AWS blocks outbound port 25 by default. Postfix keeps retrying and logging failures.
**Action:** Either configure postfix to use SES/relay on port 587, or disable postfix if mail isn't needed. Delete old rotated logs. Consider adding `maillog` to logrotate with compression and shorter retention.

### 2.5 Vhost Logs (47 MB, stale since 2020)

`/var/www/vhosts/aeihawaii.com/logs/` contains Plesk-era logs last written in 2020:

| File | Size | Last Modified |
|------|------|---------------|
| `access_log.processed` | 37 MB | Apr 2015 |
| `access_log.webstat` | 8 MB | Apr 2015 |
| `error_log.1` | 1.5 MB | Apr 2015 |
| Others | ~1 MB | Various 2013-2020 |

**Action:** Safe to delete entirely (47 MB). Apache now logs elsewhere.

---

## 3. MEDIUM PRIORITY: Unused Applications & Vhosts (~6 GB)

### 3.1 Other Vhosts

| Vhost | Size | Last Activity | Status |
|-------|------|---------------|--------|
| `staging.alternateenergyhawaii.com` | 2.8 GB | Contains 2015 zip files (559M, 455M) | Likely unused |
| `alternateenergyhawaii.com` | 1.7 GB | Old Drupal site with 2015 backup_migrate archives (551M) | Likely unused |
| `mandhdesign.com` | 1.2 GB | 830M in files/, 183M scheduler, 120M clientwork | Likely unused |

**Action:** Verify these domains are no longer active. If decommissioned, archive to S3 and delete. **Saves ~5.7 GB.**

### 3.2 Unused Applications in httpdocs (~580 MB)

| Directory | Size | Description |
|-----------|------|-------------|
| `staging/` | 130 MB | Old staging copy of scheduler |
| `mediawiki/` | 90 MB | Wiki installation (likely unused) |
| `esign/` | 79 MB | E-signature app |
| `support/` | 54 MB | osTicket support system |
| `craft/` | 49 MB | Craft CMS |
| `xpdfbin-linux-3.03/` | 48 MB | PDF binary tools (old version) |
| `hrm/` | 47 MB | HR management app |
| `newphoenix/` | 38 MB | InvoiceNinja (unused since 2016) |
| `MPDF531/` | 30 MB | Duplicate PDF library (also in scheduler/) |
| `tracmor/` | 29 MB | Asset tracking (unused) |
| `scarpdata/` | 27 MB | Unknown/old data |
| `photoapp/` | 25 MB | Old mobile photo app |
| `scaws/` | 22 MB | Unknown |
| `sticket/` | 18 MB | Old ticket system |
| `mysqldbne/` | 44 MB | **DB admin tool (security risk)** |

**Action:** Audit each for active use. The following are almost certainly safe to remove: `xpdfbin-linux-3.03`, `MPDF531` (top-level copy), `newphoenix`, `tracmor`, `scarpdata`, `mysqldbne`, `sticket`.

### 3.3 Duplicate MPDF Libraries (60 MB)

MPDF531 exists in three places:
- `/httpdocs/MPDF531/` (30 MB) — standalone
- `/httpdocs/scheduler/MPDF531/` (27 MB) — used by scheduler
- `/httpdocs/staging/MPDF531/` (3 MB approx) — in staging copy

**Action:** Keep only the scheduler copy. Delete others.

---

## 4. UPLOAD FILES: The Big Picture (275 GB)

This is the core storage challenge on the server.

### 4.1 `scheduler/uploads/` — 205 GB

| Component | Size | File Count | Description |
|-----------|------|------------|-------------|
| Root-level images | 173 GB | 201,293 | JPG/JPEG/PNG photos |
| Root-level PDFs | included | 22,059 | Proposals, contracts |
| `thumbnails/` | 29 GB | 376,512 | Auto-generated thumbnails (multiple sizes per original) |
| `webp/` | 3.9 GB | 4,358 | WebP conversions for mobile app |
| `tempimage/` | 252 KB | minimal | Temp directory (clean) |

**File Age Distribution (root level):**

| Year | Files | Notes |
|------|-------|-------|
| 2011-2014 | 5,127 | Very old |
| 2015 | 25,509 | |
| **2016** | **144,978** | **Anomalous spike (79K in June alone)** |
| 2017-2019 | 9,308 | |
| 2020-2023 | 19,347 | |
| 2024 | 1,204 | |
| 2025-2026 | 17,986 | Recent/active |

**Key finding:** 204,269 files (91%) have not been modified since before 2024. The 2016 spike (particularly June 2016 with 79,099 files) suggests a mass import or migration event.

### 4.2 `httpdocs/uploads/` — 70 GB

Contains 105,489 PDF files (proposals, contracts, permit documents).

| Year | Files |
|------|-------|
| 2011-2014 | 31,873 |
| 2015-2016 | 29,970 |
| 2017-2019 | 18,094 |
| 2020-2023 | 19,550 |
| 2024-2026 | 6,002 |

### 4.3 Recommendations for Upload Storage

**Option A: Archive old files to S3 (Recommended)**
- Move files older than 3 years to S3 Glacier
- Estimated savings: 150-200 GB
- Requires: Update application code to serve from S3 when local file not found
- Cost: ~$0.50/month for 200GB in S3 Glacier

**Option B: Delete orphaned files**
- Cross-reference upload files against `meter_files` database table
- Remove files with no database reference
- The 2016 June spike of 79K files deserves special investigation

**Option C: Compress old thumbnails**
- 376,512 thumbnails at 29 GB
- Could convert to WebP (typically 30-50% smaller)
- Or delete and regenerate on-demand

---

## 5. LOW PRIORITY: Minor Cleanup (~50 MB)

| Item | Size | Action |
|------|------|--------|
| `_svn/` directories (Subversion remnants) | 38 MB | Safe to delete (across ~80 directories) |
| `.bak` files | 14 MB | Review and delete |
| `applicationbak/` directories (4 copies) | 9 MB | Safe to delete |
| `scheduler/assetsbak/` | 892 KB | Safe to delete |
| Old Plesk vhost shells (empty dirs) | negligible | Cosmetic cleanup |
| `/var/log/amazon/` | 182 MB | Review log rotation |
| `/var/log/mysqld.log` | 56 MB | Configure log rotation |

---

## 6. DATABASE ANALYSIS

### 6.1 MySQL On-Disk (4.6 GB)

| Database | Size |
|----------|------|
| `mandhdesign_schedular` | 3.0 GB |
| `mandhdesign_scrapdb` | 65 MB |
| `tracksmart` | 60 MB |

### 6.2 Largest Tables in `mandhdesign_schedular`

| Table | Data (MB) | Index (MB) | Rows | Notes |
|-------|-----------|------------|------|-------|
| `system_price_proposal` | 792 | 128 | 4.3M | Price calculation data |
| `ost_file_chunk` | 342 | 0 | 1,152 | osTicket attachments (297KB avg/row!) |
| `acsystem_price_proposal` | 266 | 54 | 1.4M | AC price calculations |
| `ost_ticket_thread` | 192 | 13 | 159K | osTicket threads |
| `system_price_swhproposal` | 158 | 20 | 666K | SWH price data |
| `variable_job` | 133 | 85 | 2.6M | Job variables |
| `system_price_drwproposal` | 48 | 9 | 173K | DRW price data |
| `jobs` | 41 | 8 | 85K | Core jobs table |
| `meter_files` | 27 | 7 | 203K | Photo file references |
| `activity_log` | 19 | 6 | 608K | Activity logging |

**Notable:**
- `ost_file_chunk`: 342 MB for support ticket file attachments. If osTicket is no longer used, this can be truncated.
- `activity_log`: 608K rows of logging data. Consider archiving entries older than 1 year.
- Price proposal tables (792 + 266 + 158 + 48 = **1,264 MB**): These may contain historical calculations that are never queried. Consider archiving old records.

---

## 7. OTHER OBSERVATIONS

### 7.1 Postfix Mail System
Postfix is actively trying (and failing) to send mail. AWS blocks port 25 by default. Each retry generates log entries, leading to ~300MB/week in maillog growth. **This is a recurring disk space leak.**

### 7.2 Old Kernel Files
Three kernel versions installed in `/boot/` (73 MB total). Only the latest is needed but this is negligible.

### 7.3 `root@62.138.26.149` Directory
A Plesk migration artifact directory exists at `/var/www/root@62.138.26.149/`. Contains old vhost directory structure from a previous server. ~400 KB total, cosmetic cleanup.

### 7.4 The 2016 June Upload Anomaly
79,099 files uploaded in a single month (June 2016) is highly unusual. This was likely a bulk import of historical photos from another system. Many of these may be redundant with files stored elsewhere, or may reference jobs that no longer exist. Worth investigating.

---

## 8. RECOMMENDED CLEANUP PLAN

### Phase 1: Immediate (Low risk, high impact) — ~20 GB

| # | Action | Space Saved | Risk |
|---|--------|-------------|------|
| 1 | Delete `photoapi/sl.sql` | 290 MB | **SECURITY FIX** |
| 2 | Delete `mysqldbne/` | 44 MB | **SECURITY FIX** |
| 3 | Delete SQL dumps from vhost root | 9.1 GB | None (redundant) |
| 4 | Delete redundant MySQL backups | 9.5 GB | None (keep Jul 2025) |
| 5 | Delete old maillog rotations | 1.3 GB | None |
| 6 | Delete old vhost logs | 47 MB | None |

### Phase 2: Short-term (Low risk, moderate effort) — ~12 GB

| # | Action | Space Saved | Risk |
|---|--------|-------------|------|
| 7 | Remove or prune `dev/` directory | 8.6 GB | Low (verify not in use) |
| 8 | Remove `staging` vhost if unused | 2.8 GB | Low (verify) |
| 9 | Remove `alternateenergyhawaii.com` if unused | 1.7 GB | Low (verify) |
| 10 | Remove unused apps (xpdfbin, tracmor, etc.) | ~300 MB | Low |

### Phase 3: Medium-term (Data lifecycle policy) — ~150+ GB potential

| # | Action | Space Saved | Risk |
|---|--------|-------------|------|
| 11 | Investigate 2016 June upload spike | TBD | Medium |
| 12 | Cross-reference uploads against DB (find orphans) | TBD | Medium |
| 13 | Archive pre-2020 uploads to S3 | 150+ GB | Medium (needs code changes) |
| 14 | Convert thumbnails to WebP | ~10 GB | Low |

### Phase 4: Ongoing maintenance

| # | Action | Notes |
|---|--------|-------|
| 15 | Fix or disable Postfix | Stops 300MB/week log growth |
| 16 | Configure `mysqld.log` rotation | Prevent 56 MB+ growth |
| 17 | Set up automated MySQL backup rotation | Keep last 2, delete older |
| 18 | Consider S3 lifecycle for `/mnt/dropbox/` old years | 9 GB for 2025 data |

---

## Appendix A: Complete Directory Tree (Top 2 Levels, Sorted by Size)

```
344G /
├── 306G /var
│   ├── 300G /var/www/vhosts
│   │   ├── 294G aeihawaii.com
│   │   │   └── 285G httpdocs
│   │   │       ├── 206G scheduler (205G uploads)
│   │   │       ├── 70G  uploads (105K PDFs)
│   │   │       ├── 8.6G dev
│   │   │       ├── 342M photoapi
│   │   │       └── ~580M various old apps
│   │   ├── 2.8G staging.alternateenergyhawaii.com
│   │   ├── 1.7G alternateenergyhawaii.com
│   │   └── 1.2G mandhdesign.com
│   ├── 4.7G /var/lib (4.6G mysql)
│   └── 1.8G /var/log (1.5G maillogs)
├── 20G  /mnt (18G dropbox)
├── 14G  /backup (mysql backups)
├── 9.1G SQL dumps in vhost root
└── 2.2G /usr
```

## Appendix B: Quick Cleanup Commands

**WARNING: Review each command before running. Ensure you have recent backups.**

```bash
# Phase 1: Security fixes
rm /var/www/vhosts/aeihawaii.com/httpdocs/photoapi/sl.sql
rm -rf /var/www/vhosts/aeihawaii.com/httpdocs/mysqldbne/

# Phase 1: Redundant SQL dumps
rm /var/www/vhosts/aeihawaii.com/latest.sql
rm /var/www/vhosts/aeihawaii.com/latest2dmay2020.sl
rm /var/www/vhosts/aeihawaii.com/mae.sql
rm /var/www/vhosts/aeihawaii.com/tracks.sql
rm /var/www/vhosts/aeihawaii.com/tracks2.sql
rm /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/config/tracks1.sql

# Phase 1: Redundant MySQL backups
rm /backup/mysql/all_databases_backup.sql
rm /backup/mysql/full_backup.sql
rm /backup/mysql/full_backup2.sql.bz2
rm /backup/mysql/mandhdesign_schedular_fixed.sql

# Phase 1: Old mail logs
rm /var/log/maillog-*

# Phase 1: Old vhost logs
rm -rf /var/www/vhosts/aeihawaii.com/logs/*

# Low priority: SVN remnants
find /var/www/vhosts/aeihawaii.com -name '_svn' -type d -exec rm -rf {} +

# Low priority: bak files
find /var/www/vhosts/aeihawaii.com -name '*.bak' -type f -delete

# Low priority: applicationbak directories
find /var/www/vhosts -name 'applicationbak' -type d -exec rm -rf {} +
```
