# AEI Photo Upload System — Complete Documentation

**Last Updated:** 2026-02-05
**Status:** PARTIALLY OUTDATED — see note below

> **IMPORTANT:** This document predates PHOTO-009 (Unified Storage), PHOTO-017 (3-Tier WebP + Staging),
> and PHOTO-021 (Staging Direct, DB-Only Listing, API Fix). Key changes since this was written:
>
> - **No /mnt/dropbox/ hierarchy writes** — uploads no longer create files in /mnt/dropbox/ on remote
> - **Staging-first** — ALL uploads (mobile + scheduler) land in `uploads/staging/`
> - **3-tier WebP** — `generate_thumbnails.py` v4.0 creates thumbs/ + webp/ + hi-res/ (not single generate_webp.py)
> - **DB-only listing** — scheduler uses `meter_files` only; s3files/filesystem scanning eliminated
> - **No CI resize** — the legacy 800x1027 JPEG resize was removed for scheduler uploads
>
> **Canonical reference:** `PHOTO_SYSTEM_PROCESS_MAP.md` (same directory) is the authoritative post-PHOTO-021 document.

## Overview

Photos enter the system through **three upload paths**, all originating on the **remote server** (18.225.0.90). All uploads land in `uploads/staging/` and are processed by background Python scripts for WebP derivative generation and local server sync. A fourth upload path exists on the local server only.

```
┌─────────────────────────────────────────────────────────────────┐
│  UPLOAD SOURCES                                                 │
│                                                                 │
│  1. Mobile App ──────► photoapi/upload.php                      │
│  2. Scheduler Photo Tab ──► phototab/dropImageUpload            │
│  3. Scheduler Premeasure ──► preupload/submit                   │
│  4. Local Direct Upload ──► upload.aeihawaii.com (local only)   │
└──────────┬──────────────────────┬──────────────────────┬────────┘
           │                      │                      │
           ▼                      ▼                      ▼
┌─────────────────────────────────────────────────────────────────┐
│  REMOTE SERVER (18.225.0.90)                                    │
│                                                                 │
│  STORAGE A: /mnt/dropbox/{Year} Customers/...                   │
│  ├── Organized by customer/type/date                            │
│  ├── Original photos + webp/ subfolder                          │
│  └── Read by: getimagelisting.php (mobile app photo browser)   │
│                                                                 │
│  STORAGE B: scheduler/uploads/ + scheduler/uploads/webp/        │
│  ├── Flat directory, hashed filenames (CodeIgniter encrypt_name)│
│  ├── Original photos + WebP copies side by side                 │
│  └── Read by: scheduler photo tab UI, premeasure gallery        │
│                                                                 │
│  Database: meter_files (file_type=99, folder_path, webpfilename)│
└──────────────────────────┬──────────────────────────────────────┘
                           │ sync_to_local.py (mobile)
                           │ cURL POST (scheduler)
                           ▼
┌─────────────────────────────────────────────────────────────────┐
│  LOCAL SERVER (upload.aeihawaii.com)                             │
│                                                                 │
│  STORAGE C: /mnt/dropbox/{Year} Customers/...                   │
│  ├── Organized by customer/type/date (same hierarchy, diff dates│
│  ├── Original photos + thumbs/ + thumbs/mid/ (WebP thumbnails) │
│  └── Read by: get_survey_photos.php API, test_photo_browser.php │
│                                                                 │
│  Database: unified_customers (folder_path per year)             │
└─────────────────────────────────────────────────────────────────┘
```

---

## Storage Architecture

Every photo uploaded through the remote server ends up in **two separate storage locations**. These are not redundant copies — each serves a different consumer with different requirements.

### Storage A: Remote `/mnt/dropbox/{Year} Customers/`

**Full path:** `/mnt/dropbox/{YYYY} Customers/{FirstLetter}/{LastName, FirstName}/{Survey|Installation}/{Name, Type-S|I, MM-DD-YYYY}/`

**Purpose:** Customer-organized photo archive. This is the structured storage that mirrors how the business thinks about photos — by customer, job type, and date.

**Contents per photo subfolder:**
```
{Name, Type-S, MM-DD-YYYY}/
├── original_photo.jpeg          (original from device or CodeIgniter upload)
└── webp/
    └── {Name}{Type}{Date}_IMG{hash}.webp   (single-size WebP, ~80% quality)
```

**Consumers:**
- `getimagelisting.php` — the mobile app's photo browser. Scans the `webp/` subdirectories to build the image list. This is the ONLY code path that reads from this location.
- `fetch_image.php` — serves individual images from this location when the mobile app requests them.

**Key detail:** The `webp/` subfolder exists solely for the mobile app. The mobile app calls `getimagelisting.php`, which returns URLs pointing to `fetch_image.php`, which streams the WebP files from these directories.

**Filenames:** The original photos keep their device filename (mobile app: `image_picker_XXX.jpg`) or CodeIgniter hashed name (scheduler: `abc123def456.jpg`). The WebP copies use a generated name: `{LastFirst}{JobType}-{PhotoType}{Date}_IMG{uniqueId}.webp`.

### Storage B: Remote `scheduler/uploads/` + `scheduler/uploads/webp/`

**Full path:** `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/`

**Purpose:** Flat working directory for the scheduler web application. CodeIgniter stores uploaded files here with encrypted (hashed) filenames. The scheduler UI reads directly from this directory.

**Contents:**
```
scheduler/uploads/
├── abc123def456.jpg             (CodeIgniter encrypted filename)
├── xyz789ghi012.jpg
├── ...
└── webp/
    ├── {Name}{Type}{Date}_IMG{hash}.webp
    └── ...
```

**Consumers:**
- Scheduler Photo Tab (`phototab.php`) — displays photos in the scheduler web UI. Queries `meter_files.unique_filename` to find files in `scheduler/uploads/`.
- Premeasure Gallery (`preupload.php gallery()`) — displays premeasure photos. Uses `meter_files.webpfilename` to find WebP files in `scheduler/uploads/webp/`.
- Photo download (`preupload.php download_all()`) — zips originals from `scheduler/uploads/`.

**Key detail:** This is why the scheduler photo tab shows ALL photos even when `getimagelisting.php` (mobile app) misses some. The scheduler reads from the flat directory using database filenames — it never depends on the `/mnt/dropbox/` folder structure.

### Storage C: Local `/mnt/dropbox/{Year} Customers/`

**Full path:** `/mnt/dropbox/{YYYY} Customers/{FirstLetter}/{LastName, FirstName}/{Survey|Installation}/{Name, Type-S|I, YYYY-MM-DD}/`

**Purpose:** Dropbox-synced customer photo archive on the local server. This is the canonical photo storage for the business, accessible via Dropbox to office staff.

**Contents per photo subfolder:**
```
{Name, Type-S, YYYY-MM-DD}/
├── IMG_0682.jpeg                 (original filename from device)
├── thumbs/
│   └── IMG_0682.webp             (200x150, ~4KB, gallery grid)
└── thumbs/mid/
    └── IMG_0682.webp             (800x600, ~70KB, detail view)
```

**Consumers:**
- `get_survey_photos.php` — the local photo browser API (SURVEY_PHOTOS enhancement). Returns structured JSON with thumbnail/mid/original URLs.
- `serve_photo.php` — streams photos from this location (path-traversal protected).
- `test_photo_browser.php` — visual test gallery.
- Dropbox sync — the entire `/mnt/dropbox/` mount syncs to Dropbox cloud storage.

**Key differences from remote:**
- **Date format:** Local uses `YYYY-MM-DD`, remote uses `MM-DD-YYYY`
- **Filenames:** Local preserves original device filenames, remote may have CodeIgniter hashed names
- **Thumbnails:** Local has `thumbs/` (200x150) and `thumbs/mid/` (800x600); remote has `webp/` (single size)

---

## Mobile App Image Listing (`getimagelisting.php`)

The mobile app retrieves photos via `POST https://aeihawaii.com/photoapi/getimagelisting.php` with `auth_token` and `job_id`.

**How it finds photos (two-step lookup per job):**

1. **Step 1: Query all jobs for the customer** — Gets every `job_pid` for the customer associated with the requested `job_id`

2. **Step 2a: Use `meter_files.folder_path`** — For each `job_pid`, queries `meter_files` for rows with a non-NULL `folder_path`. Scans the `webp/` subdirectory at that path. This is the fast, reliable path.

3. **Step 2b: Reconstruct path (fallback)** — For `job_pid`s with no `folder_path` in `meter_files`, reconstructs the expected path from job metadata:
   ```
   /mnt/dropbox/{job_year} Customers/{letter}/{name}/{type}/{name, jobtype-S|I, date}/webp/
   ```
   This fallback fails if the photo was stored under the wrong year (e.g., the premeasure bug) or if the path components don't match exactly.

4. **Deduplication** — Tracks scanned directories to avoid returning the same photo twice when both step 2a and 2b point to the same location.

**Returns:** Array of image links in the format `fetch_image.php?job_id={id}&img={webp_filename}`

**Key file:** `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/getimagelisting.php`

---

## Photo Type Determination

All upload paths use the same rule to classify photos as Survey or Installation:

| Job Type Initials | Photo Type | Folder | Code |
|-------------------|------------|--------|------|
| PM (Premeasure) | Survey | `Survey/` | `-S` |
| WM (Water Meter) | Survey | `Survey/` | `-S` |
| AS (As-Built) | Survey | `Survey/` | `-S` |
| RPM (Re-Premeasure) | Survey | `Survey/` | `-S` |
| GCPM (GC Premeasure) | Survey | `Survey/` | `-S` |
| All others (SC, PV, EL, AC, SWH, SP, etc.) | Installation | `Installation/` | `-I` |

---

## Upload Path 1: Mobile App

**Endpoint:** `POST https://aeihawaii.com/photoapi/upload.php`

**Input:** JSON body with `auth_token`, `job_id`, `file_name`, `image_data` (base64)

**Auth:** Hardcoded token `aei@89806849`

**Flow:**

1. Decodes base64 image data
2. Queries `jobs` → `customers` → `job_types` to get customer name, job type initials, job date
3. Determines photo type: **Survey** if job type is PM, WM, AS, RPM, or GCPM; otherwise **Installation**
4. Builds folder path on remote `/mnt/dropbox/`:
   ```
   /mnt/dropbox/{YYYY} Customers/{FirstLetter}/{LastName, FirstName}/
       Survey/{LastName, FirstName, Type-S, MM-DD-YYYY}/
       -- or --
       Installation/{LastName, FirstName, Type-I, MM-DD-YYYY}/
   ```
5. Saves original JPEG to the folder (keeps original filename from mobile app)
6. Copies original to `/var/www/.../scheduler/uploads/` (flat directory)
7. Generates WebP in background via `generate_webp.py` (Python/Pillow) — unique filename using `md5(uniqid(mt_rand()))` hash → saves to `webp/` subfolder + `scheduler/uploads/webp/`
8. Inserts into `meter_files` table (file_type=99) including `folder_path` column
9. **Returns JSON response to mobile app immediately**
10. Triggers `sync_to_local.py` in background (nohup, non-blocking)

**Sync to local** (`sync_to_local.py`):
- POSTs the file + metadata to `https://upload.aeihawaii.com/uploadlocallat_kuldeep.php`
- 3 retries with exponential backoff (2s, 4s, 8s)
- On failure: queues to `queue/` directory for cron retry every 15 minutes

**Key files:**
- `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/upload.php`
- `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/sync_to_local.py`
- `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/generate_webp.py`

---

## Upload Path 2: Scheduler Photo Tab (Drag-and-Drop)

**Endpoint:** `POST https://aeihawaii.com/scheduler/phototab/dropImageUpload/{job_id}`

**Input:** Standard multipart form upload (single file, drag-and-drop UI)

**Auth:** CodeIgniter session (logged-in scheduler user)

**Flow:**

1. Job ID is in the URL — fetches customer name, job type, date from database
2. Auto-determines photo type from job type (same PM/WM/AS/RPM/GCPM → Survey rule)
3. Uploads file to `scheduler/uploads/` via CodeIgniter with encrypted (hashed) filename
4. Builds folder path on remote `/mnt/dropbox/` — **dynamic year** from job date:
   ```
   /mnt/dropbox/{YYYY} Customers/{FirstLetter}/{LastName, FirstName}/
       Survey/{LastName, FirstName, Type-S, MM-DD-YYYY}/
       -- or --
       Installation/{LastName, FirstName, Type-I, MM-DD-YYYY}/
   ```
5. Copies original to the dropbox folder
6. Sends file to local server via **synchronous cURL** to `uploadlocallat_kuldeep.php`
7. Generates WebP via background `generate_webp.py` — unique filename using `md5(uniqid(mt_rand()))` hash
8. Inserts into `meter_files` (file_type=99) including `folder_path` column

**Key file:** `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/phototab.php`

---

## Upload Path 3: Scheduler Premeasure Upload (Bulk)

**Endpoint:** `POST https://aeihawaii.com/scheduler/preupload/submit`

**Input:** Standard multipart form (multi-file), user selects job date, job type, photo type, customer name

**Auth:** CodeIgniter session

**Flow:**

1. User manually selects customer, job type, photo type (Survey/Installation), and date
2. Uploads multiple files to `scheduler/uploads/` with encrypted filenames
3. Builds folder path on remote `/mnt/dropbox/` — **dynamic year** from job date (fixed 2026-02-05):
   ```
   /mnt/dropbox/{YYYY} Customers/{FirstLetter}/{LastName, FirstName}/
       Survey/{LastName, FirstName, Type-S, MM-DD-YYYY}/
       -- or --
       Installation/{LastName, FirstName, Type-I, MM-DD-YYYY}/
   ```
4. Copies originals to the dropbox folder
5. Sends each file to local server via **synchronous cURL** to `uploadlocallat_kuldeep.php`
6. Uses the response body as WebP data, saves to `webp/` subfolder — unique filename using `md5(uniqid(mt_rand()))` hash
7. Inserts into `meter_files` (file_type=99) including `folder_path` column, and into `premeasure_uploads`

**Key file:** `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/preupload.php`

---

## Upload Path 4: Scheduler Website Direct Upload (Local Only)

**Endpoint:** `https://upload.aeihawaii.com/` (index.php)

**Input:** Web form with customer name, job type, date, files

**This is a separate upload UI** on the local server used by field technicians. It does NOT go through the remote server at all.

**Flow:**

1. Files uploaded to `/mnt/dropbox/Uploads/[Name] [Type] [Date]/`
2. If "Auto-sort" is checked, triggers `/var/opt/move_photos/move_photos.py` which moves files into the proper customer folder structure
3. No database insert into `meter_files` — this bypasses the remote DB entirely
4. Thumbnails are generated later by batch scripts, not at upload time

---

## Local Server Reception (`uploadlocallat_kuldeep.php`)

All three remote upload paths send files to this endpoint on the local server.

**Endpoint:** `POST https://upload.aeihawaii.com/uploadlocallat_kuldeep.php`

**Auth:** Token from `.env` file (or fallback `remote_token`)

**Customer folder lookup priority:**
1. `customer_id` + year → query `unified_customers`
2. `customer_id` (any year) → most recent year
3. `first_name` + `last_name` + year → name match
4. `first_name` + `last_name` (any year) → most recent
5. Auto-create new customer folder + insert into `unified_customers`

**Folder structure on local `/mnt/dropbox/`:**
```
/mnt/dropbox/{Year} Customers/{Letter}/{Name}/
    Survey/{Name, Type-S, YYYY-MM-DD}/
        {original_filename}.jpeg
        thumbs/{original_filename}.webp        (200x150, ~4KB)
        thumbs/mid/{original_filename}.webp    (800x600, ~70KB)
    Installation/{Name, Type-I, YYYY-MM-DD}/
        (same structure)
```

**After saving the file**, triggers `upload_thumb_generator.py` in background to create thumbnails.

---

## Key Differences: Remote vs Local Storage

| Aspect | Remote Server | Local Server |
|--------|---------------|--------------|
| **Mount** | `/mnt/dropbox/` (regular directory on root disk, 985GB) | `/mnt/dropbox/` (Dropbox-synced mount) |
| **Filenames** | Hash-based (from CodeIgniter upload) or original (from mobile app) | Original filenames |
| **Thumbnails** | `webp/` subfolder only (single size) | `thumbs/` (200x150) + `thumbs/mid/` (800x600) |
| **Date format in folders** | `MM-DD-YYYY` | `YYYY-MM-DD` |
| **Database** | `meter_files` in `mandhdesign_schedular` | `unified_customers` in `Schedular` |
| **Purpose** | Source of truth for scheduler app, mobile app image listing | Source of truth for photo browsing, customer folder organization |

---

## Thumbnail Generation

| Generator | When | Where | Output |
|-----------|------|-------|--------|
| `generate_webp.py` (remote) | At upload time, background | Remote `webp/` subfolder | Single WebP per image |
| `upload_thumb_generator.py` (local) | After each sync, background | Local `thumbs/` and `thumbs/mid/` | 200x150 + 800px max WebP |
| `generate_folder_thumbs.py` (local) | On-demand / batch | Any local photo folder | Same as above |
| `thumb_mid_generate.py` (local) | Batch processing entire tree | Full year-customer tree | Same as above |
| `thumbnail.php` (local) | On-the-fly for gallery.php | Not saved to disk | 100px JPEG streamed |

---

## Database Tables

### `meter_files` (Remote: `mandhdesign_schedular`)
Stores one row per uploaded photo across all upload paths.

| Column | Purpose |
|--------|---------|
| `job_id` | Links to `jobs.job_pid` |
| `unique_filename` | Hashed filename in `scheduler/uploads/` |
| `original_filename` | Original filename from device |
| `file_type` | `99` = photo |
| `webpfilename` | WebP copy filename |
| `folder_path` | Absolute path where photo was saved (added by PHOTO_FOLDER_PATH enhancement) |
| `created` | Upload timestamp |

### `unified_customers` (Local: `Schedular`)
Maps remote customer IDs to local folder paths. Multiple rows per customer (one per year).

| Column | Purpose |
|--------|---------|
| `remote_customer_id` | Links to remote `customers.id` |
| `folder_path` | Full local path: `/mnt/dropbox/{Year} Customers/{Letter}/{Name}` |
| `folder_year` | Year associated with this folder |

### `customers.folder_path` (Remote: `mandhdesign_schedular`)
Stores the year base folder. Set automatically when a customer is created (since Jan 2025). Contains only the base path (e.g., `/mnt/dropbox/2025 Customers/`), not the full customer-specific path. **Not read by any application code.**

---

## Known Issues

1. ~~**Premeasure upload year hardcoded to 2025**~~ — **FIXED (2026-02-05, PHOTO_LISTING_FIXES).** `preupload.php` now derives the year dynamically from the job date. 262 misplaced folders were moved from `2025 Customers/` to `2026 Customers/` via remediation.

2. **Date format mismatch** — Remote folders use `MM-DD-YYYY`, local folders use `YYYY-MM-DD`. This means the same photo set has different subfolder names on each server. By design; each system expects its own format.

3. **`customers.folder_path` is dead** — The column exists and is populated for 2025+ customers, but no code reads it. It only stores the year base folder, not the full customer path.

4. **Scheduler uploads are synchronous** — Photo Tab and Premeasure uploads use synchronous cURL to send files to the local server. The mobile app path was upgraded to async (background `sync_to_local.py`) but the scheduler paths still block until the local server responds.

## Resolved Issues (PHOTO_LISTING_FIXES, 2026-02-05)

Three bugs prevented the mobile app from listing all photos for some customers. All three were fixed and deployed on 2026-02-05.

| Bug | Root Cause | Fix | Files Changed |
|-----|-----------|-----|---------------|
| **Wrong year folder** | `preupload.php` hardcoded `2025` in dropbox path | Dynamic year from `date("Y", strtotime($norm_date))` | `preupload.php` |
| **Missing `folder_path`** | `preupload.php` and `phototab.php` did not populate `meter_files.folder_path` | Capture `$folder_path_for_db` before `$final_folder` reassignment, include in INSERT | `preupload.php`, `phototab.php` |
| **WebP filename collisions** | All 3 upload paths used `rand(100000, 999999)` — 6 digits, high collision rate | Replaced with `substr(md5(uniqid(mt_rand(), true)), 0, 12)` — 12-char hex hash | `upload.php`, `preupload.php`, `phototab.php` |

**Remediation performed:**
- Step 1: Moved 262 photo folders from `2025 Customers/` to `2026 Customers/` (only folders with 2026 dates in their names)
- Step 2: Backfilled `folder_path` for 4,478 `meter_files` rows (2025+ jobs only)
- Step 3: Checked for missing WebP files (0 found missing)

**Enhancement directory:** `ENHANCEMENTS/PHOTO-007_PHOTO_LISTING_FIXES/` (originals in `ORIGINAL/`, fixed versions in `NEW/`)
